<?php
namespace Moto\Http; use Exception; use Moto; use Zend; class Client extends Zend\Http\Client { protected $_defaultCurlOptions = array( CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0, CURLOPT_HEADER => 0, CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => false, CURLOPT_RETURNTRANSFER => true, CURLOPT_CONNECTTIMEOUT => 10, CURLOPT_TIMEOUT => 20, CURLOPT_PROXY => '' ); protected $_messageKeys = array( 400 => 'bad_request', 403 => 'forbidden', 404 => 'not_found', 408 => 'timeout', 500 => 'internal_server_error' ); protected static $_curlErrors = array( 1 => 'CURLE_UNSUPPORTED_PROTOCOL', 2 => 'CURLE_FAILED_INIT', 3 => 'CURLE_URL_MALFORMAT', 4 => 'CURLE_URL_MALFORMAT_USER', 5 => 'CURLE_COULDNT_RESOLVE_PROXY', 6 => 'CURLE_COULDNT_RESOLVE_HOST', 7 => 'CURLE_COULDNT_CONNECT', 22 => 'CURLE_HTTP_NOT_FOUND', 23 => 'CURLE_WRITE_ERROR', 24 => 'CURLE_MALFORMAT_USER', 26 => 'CURLE_READ_ERROR', 27 => 'CURLE_OUT_OF_MEMORY', 28 => 'CURLE_OPERATION_TIMEOUTED', 33 => 'CURLE_HTTP_RANGE_ERROR', 34 => 'CURLE_HTTP_POST_ERROR', 35 => 'CURLE_SSL_CONNECT_ERROR', 37 => 'CURLE_FILE_COULDNT_READ_FILE', 40 => 'CURLE_LIBRARY_NOT_FOUND', 41 => 'CURLE_FUNCTION_NOT_FOUND', 42 => 'CURLE_ABORTED_BY_CALLBACK', 43 => 'CURLE_BAD_FUNCTION_ARGUMENT', 44 => 'CURLE_BAD_CALLING_ORDER', 45 => 'CURLE_HTTP_PORT_FAILED', 46 => 'CURLE_BAD_PASSWORD_ENTERED', 47 => 'CURLE_TOO_MANY_REDIRECTS', 48 => 'CURLE_UNKNOWN_TELNET_OPTION', 49 => 'CURLE_TELNET_OPTION_SYNTAX', 50 => 'CURLE_OBSOLETE', 51 => 'CURLE_SSL_PEER_CERTIFICATE', 52 => 'CURLE_GOT_NOTHING', 53 => 'CURLE_SSL_ENGINE_NOTFOUND', 54 => 'CURLE_SSL_ENGINE_SETFAILED', 55 => 'CURLE_SEND_ERROR', 56 => 'CURLE_RECV_ERROR', 57 => 'CURLE_SHARE_IN_USE', 58 => 'CURLE_SSL_CERTPROBLEM', 59 => 'CURLE_SSL_CIPHER', 60 => 'CURLE_SSL_CACERT', 61 => 'CURLE_BAD_CONTENT_ENCODING', 63 => 'CURLE_FILESIZE_EXCEEDED', ); protected $_response = null; protected $_tempStream = array(); public function __construct($uri = null, $options = array()) { $defaultSettings = Moto\Config::get('httpClient.settings'); if (is_array($defaultSettings)) { $options = Zend\Stdlib\ArrayUtils::merge(Moto\Util::arrayOnly($defaultSettings, [ 'maxredirects', 'useragent', 'argseparator', ]), $options, true); } else { $defaultSettings = array(); } if (!isset($options['adapter'])) { $options['adapter'] = 'Zend\Http\Client\Adapter\Curl'; } if ($options['adapter'] === 'Zend\Http\Client\Adapter\Curl') { if (!isset($options['curloptions'])) { $options['curloptions'] = array(); } $curlOptions = Moto\Util::getValue($defaultSettings, 'curlOptions'); if (!is_array($curlOptions)) { $curlOptions = array(); } $curlOptions = Zend\Stdlib\ArrayUtils::merge($this->_defaultCurlOptions, $curlOptions, true); if (array_key_exists('connectionTimeout', $defaultSettings)) { $curlOptions[CURLOPT_CONNECTTIMEOUT] = (int) $defaultSettings['connectionTimeout']; } if (array_key_exists('executionTimeout', $defaultSettings)) { $curlOptions[CURLOPT_TIMEOUT] = (int) $defaultSettings['executionTimeout']; } $options['curloptions'] = Zend\Stdlib\ArrayUtils::merge($curlOptions, $options['curloptions'], true); $useProxy = Moto\Config::get('proxy.enabled', false); if ($useProxy) { $options = Zend\Stdlib\ArrayUtils::merge($options, array( 'proxyhost' => Moto\Config::get('proxy.host'), 'proxyport' => Moto\Config::get('proxy.port'), 'proxyuser' => Moto\Config::get('proxy.user'), 'proxypass' => Moto\Config::get('proxy.pass') )); } } if (!isset($options['argseparator'])) { $options['argseparator'] = '&'; } if (isset($options['streamtmpdir'])) { $tempDir = trim((string) $options['streamtmpdir']); } else { $tempDir = trim((string) Moto\Util::getValue($defaultSettings, 'tempDir', '')); } if ($tempDir === '') { $tempDir = '@temp'; } $tempDir = Moto\System::getAbsolutePath($tempDir); if (!file_exists($tempDir)) { Moto\Util::createDir($tempDir); } $options['streamtmpdir'] = $tempDir; parent::__construct($uri, $options); } public function send(Zend\Http\Request $request = null) { try { $this->_response = parent::send($request); } catch (Exception $e) { $this->_response = $e; } return $this->_response; } public function hasErrors() { $hasErrors = false; if (!is_null($this->_response)) { $hasErrors = ($this->_response instanceof Zend\Http\Response) ? !$this->_response->isSuccess() : true; } return $hasErrors; } public function getErrors() { $errors = array(); if ($this->hasErrors()) { $code = 400; $message = 'Unknown error'; if ($this->_response instanceof Zend\Http\Response) { $code = $this->_response->getStatusCode(); } else { if ($this->_response instanceof Exception) { $code = $this->_response->getCode(); $message = $this->_response->getMessage(); } } $key = isset($this->_messageKeys[$code]) ? $this->_messageKeys[$code] : 'bad_request'; $errors = array( array( 'key' => isset($this->_messageKeys[$code]) ? $this->_messageKeys[$code] : 'bad_request', 'code' => $code, 'message' => $message ) ); } return $errors; } protected function openTempStream() { $fp = parent::openTempStream(); $this->_tempStream[] = $fp; return $fp; } protected function _cleanTempFiles() { foreach ($this->_tempStream as $file) { if (!is_resource($file)) { continue; } $info = stream_get_meta_data($file); @fclose($file); if (file_exists($info['uri'])) { @unlink($info['uri']); } } $this->_tempStream = array(); } public function __destruct() { $this->_cleanTempFiles(); } public static function getCurlErrorName($code, $default = null) { if (array_key_exists($code, static::$_curlErrors)) { return static::$_curlErrors[$code]; } return $default; } public function downloadToFile($destination, $options = []) { if (!is_string($destination)) { return false; } $destination = trim($destination); if ($destination === '') { return false; } $partial = (boolean) Moto\Util::getValue($options, 'partial', true); $maxSize = (int) Moto\Util::getValue($options, 'maxSize'); $result = [ 'error' => false, 'destination' => $destination, 'url' => (string) $this->getUri(), 'partial' => $partial, ]; $absolutePath = Moto\System::getAbsolutePath($destination); clearstatcache(true, $absolutePath); $absoluteDirPath = pathinfo($absolutePath, PATHINFO_DIRNAME); Moto\Util::createDir($absoluteDirPath); $range = null; $currentFileSize = 0; if ($partial && file_exists($absolutePath)) { $currentFileSize = filesize($absolutePath); $range = $currentFileSize . '-'; } if ($maxSize > 0) { if (!$range) { $range = '0-'; } $range .= ($currentFileSize + ($maxSize - 1)); } if (is_string($range)) { $this->setOptions([ 'curloptions' => [ CURLOPT_RANGE => $range, ], ]); } $result['range'] = $range; $this->setStream(true); if (Moto\Util::getValue($options, 'debug')) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : start download "' . $result['url'], [ 'range' => $range, 'destination' => $destination, ]); } $result['started_at'] = microtime(true); $this->send(); $result['finished_at'] = microtime(true); $result['total_time'] = $result['finished_at'] - $result['started_at']; $adapter = $this->getAdapter(); $httpResponse = $this->getResponse(); $result['http_code'] = $httpResponse->getStatusCode(); $handle = null; if ($adapter instanceof Zend\Http\Client\Adapter\Curl) { $handle = $adapter->getHandle(); $info = curl_getinfo($handle); $result['connection_info'] = Moto\Util::arrayOnly($info, [ 'content_type', 'http_code', 'total_time', 'redirect_count', 'download_content_length', 'size_download', 'speed_download', ]); } if ($this->hasErrors()) { $httpError = []; if ($handle) { $httpError['code'] = curl_errno($handle); $httpError['message'] = curl_error($handle); $httpError['name'] = Moto\Http\Client::getCurlErrorName($httpError['code']); } $result['error'] = true; $result['connection_error'] = $httpError; if (Moto\Util::getValue($options, 'closeAdapter', true)) { $adapter->close(); } if (Moto\Util::getValue($options, 'debug')) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : failed', [ 'httpCode' => $result['http_code'], 'httpError' => $httpError, ]); } return $result; } if (Moto\Util::getValue($options, 'closeAdapter', true)) { $adapter->close(); } $body = $httpResponse->getBody(); $result['downloaded'] = \mb_strlen($body, '8bit'); clearstatcache(true, $absolutePath); if (file_exists($absolutePath)) { $destination = fopen($absolutePath, 'r+b'); fseek($destination, $currentFileSize); } else { $destination = fopen($absolutePath, 'w+b'); } $written = fwrite($destination, $body); fclose($destination); $result['written'] = $written; if (Moto\Util::getValue($options, 'debug')) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : finish downloading', [ 'downloaded' => $result['downloaded'], 'written' => $written, ]); } return $result; } } 