<?php
 namespace Moto\Json; use Exception; use Illuminate; use Moto; use ReflectionClass; use Zend; use Zend\Json\Server\Error; use Zend\Json\Server\Response; use Zend\Json\Server\Server as Zend_Json_Server; use Zend\Server\Method; class Server extends Zend_Json_Server { protected static $_instance = null; protected $returnResponse = true; protected $overwriteExistingMethods = false; protected $_assignClassMap = array(); public function __construct() { parent::__construct(); $this->init(); } public function init() { $server = $this; $server->assignClass('Moto\Application\Auth\Service', 'AuthService', true); Moto\Hook::trigger(Moto\Hook::BOOTSTRAPPING_JSONRPC_SERVER, $server); $server->assignClass('Moto\Application\Blocks\Service', 'BlocksService'); $server->assignClass('Moto\Application\Users\Service', 'UsersService'); $server->assignClass('Moto\Application\Profile\Service', 'ProfileService'); $server->assignClass('Moto\Application\Roles\Service', 'RolesService'); $server->assignClass('Moto\Application\Languages\Service', 'LanguagesService'); $server->assignClass('Moto\Application\Settings\Service', 'SettingsService'); $server->assignClass('Moto\Application\Pages\Service', 'PagesService'); $server->assignClass('Moto\Application\Menus\Service', 'MenusService'); $server->assignClass('Moto\Application\Styles\Service', 'StylesService'); $server->assignClass('Moto\Application\MediaLibrary\Service', 'MediaLibraryService'); $server->assignClass(Moto\Application\Content\Service::class, 'ContentService'); $server->assignClass('Moto\Application\Updates\Service', 'UpdatesService'); $server->assignClass('Moto\Application\Themes\Service', 'ThemesService'); $server->assignClass('Moto\Application\Theme\Service', 'ThemeService'); $server->assignClass('Moto\Application\Fonts\Service', 'FontsService'); $server->assignClass('Moto\Application\FontsManager\Service', 'FontsManagerService'); $server->assignClass('Moto\Application\Extra\Service', 'ExtraService'); $server->assignClass('Moto\Application\Presets\Service', 'PresetsService'); $server->assignClass('Moto\Application\Widgets\Service', 'WidgetsService'); $server->assignClass('Website\Widgets\MailChimp\Service', 'Widget.MailChimp'); $server->assignClass('Website\Widgets\Disqus\Service', 'Widget.Disqus'); $server->assignClass(Moto\Application\ContentSection\Service::class, 'ContentSection'); $server->assignClass('Moto\Application\Support\Service', 'SupportService'); $server->assignClass('Moto\Application\Content\RenderService', 'Website.RenderService'); if (Moto\System::isAdminEngine()) { $server->assignClass(Moto\Application\Sitemap\Service::class, 'SitemapService'); $server->assignClass('Moto\Application\RobotsTxt\Service', 'RobotsTxtService'); $server->assignClass(Moto\Application\Marketplace\BackendService::class, 'Marketplace.BackendService'); $server->assignClass(Moto\Application\Cache\WebsitePageService::class, 'Cache.WebsitePageService'); $server->assignClass(Moto\Application\Plugins\PluginManagerService::class, 'PluginManagerService'); $server->assignClass(function () { return new Moto\Application\Content\TaxonomyService([ 'modelClass' => Moto\Database\Models\ContentTaxonomyCategory::class, ]); }, 'Content.Taxonomy.Category.Service'); $server->assignClass(function () { return new Moto\Application\Content\TaxonomyService([ 'modelClass' => Moto\Database\Models\ContentTaxonomyTag::class, ]); }, 'Content.Taxonomy.Service'); } Moto\Hook::trigger(Moto\Hook::BOOTSTRAPPED_JSONRPC_SERVER, $server); } protected function _dispatch(Method\Definition $invokable, array $params) { $callback = $invokable->getCallback(); $type = $callback->getType(); if ('function' == $type) { $function = $callback->getFunction(); return call_user_func_array($function, $params); } $class = $callback->getClass(); $method = $callback->getMethod(); if ('static' == $type) { if (method_exists($class, 'getResourceName')) { $resourceName = $class::getResourceName(); if (!empty($resourceName)) { $acl = Moto\Application\Acl\Adapter::getInstance(); $user = Moto\Authentication\Service::getUser(); $userRole = (null === $user ? 'guest' : strtolower($user->role_name)); if (method_exists($class, 'getResourcePrivilege')) { $privilege = $class::getResourcePrivilege($method); } else { $privilege = $method; } if (!$acl->isAllowed($userRole, $resourceName, $privilege)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE); } } } if (method_exists($class, 'setRequest')) { $class::setRequest($this->getRequest()); } return call_user_func_array(array($class, $method), $params); } $object = $invokable->getObject(); if (!is_object($object)) { $invokeArgs = $invokable->getInvokeArguments(); if (!empty($invokeArgs)) { $reflection = new ReflectionClass($class); $object = $reflection->newInstanceArgs($invokeArgs); } else { $object = new $class; } } if ($object instanceof Moto\Service\AbstractService) { $resourceName = $object->getResourceName(); if (!empty($resourceName)) { $acl = Moto\Application\Acl\Adapter::getInstance(); $user = Moto\Authentication\Service::getUser(); $userRole = (null === $user ? 'guest' : strtolower($user->role_name)); $privilege = $object->getResourcePrivilege($method); if (!$acl->isAllowed($userRole, $resourceName, $privilege)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_ACCESS_DENIED_MESSAGE, Moto\System\Exception::ERROR_ACCESS_DENIED_CODE); } } $object->setRequest($this->getRequest()); } return call_user_func_array(array($object, $method), $params); } public function getRequest() { if (null === ($request = $this->request)) { $this->setRequest(new Moto\Json\Server\Request()); Moto\System\Request::setRequest($this->request); } return $this->request; } public function setRequest(Zend\Json\Server\Request $request) { if ($request->isBatch()) { Moto\Hook::trigger(Moto\Hook::JSONRPC_SERVER_SET_BATCH_REQUEST, $request); } else { Moto\Hook::trigger(Moto\Hook::JSONRPC_SERVER_SET_REQUEST, $request); } parent::setRequest($request); return $this; } public static function getInstance() { if (is_null(static::$_instance)) { static::$_instance = new static(); } return static::$_instance; } public static function call($serviceMethod, $params = array()) { $server = static::getInstance(); if (preg_match('/^(.*)\.([^\.]+)$/', $serviceMethod, $match)) { $namespace = $match[1]; $server->forceAssign($namespace); } if ($server->getFunctions()->hasMethod($serviceMethod)) { $invokable = $server->getFunctions()->getMethod($serviceMethod); return $server->_dispatch($invokable, $params); } } public function handle($request = false) { if ($request instanceof Request) { $this->setRequest($request); } $request = $this->getRequest(); if ($request->isBatch()) { $response = new Moto\Json\Server\Response\HttpBatch(); $queue = $request->getQueue(); for ($i = 0, $count = count($queue); $i < $count; $i++) { $this->setResponse(new Response()); $response->addResponse(parent::handle($queue[$i])); } $response->setServiceMap($this->getServiceMap()); } else { $response = parent::handle(); } $this->setResponse($response); if ($response->isError() && APPLICATION_ENV !== 'production') { $this->_handleDatabaseError($response); } $this->_shutdown($response); return Moto\System::getResponse()->setContent($response); } protected function _handleDatabaseError(Response $response) { $data = $response->getError()->getData(); if ($data instanceof \Zend\Db\Adapter\Exception\InvalidQueryException) { $previous = $data->getPrevious(); Moto\System\Log::error($previous->getMessage()); } } public function fault($fault = null, $code = 404, $data = null) { $exception = null; if ($data instanceof Exception) { $exception = $data; } if ($data instanceof Moto\Exception) { $data = $data->getData(); } elseif ($data instanceof Illuminate\Database\Eloquent\ModelNotFoundException) { $fault = Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE; $code = Moto\System\Exception::ERROR_NOT_FOUND_CODE; $data = [ 'errors' => [ ] ]; } elseif ($data instanceof Illuminate\Database\QueryException) { $fault = Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE; $code = Moto\System\Exception::ERROR_BAD_REQUEST_CODE; $data = [ 'errors' => [ [ 'type' => 'QueryException', 'code' => $data->getCode(), 'message' => $data->getMessage(), ], ], ]; } if ($exception && Moto\System::isDevelopmentStage()) { $exceptionDump = [ 'class' => get_class($exception), 'code' => $exception->getCode(), 'message' => $exception->getMessage(), 'point' => $exception->getLine() . ' :: ' . $exception->getFile(), ]; if (is_array($data)) { $data['exception'] = $exceptionDump; } Moto\System\Log::error('[ Exception ] => ' . print_r($exceptionDump, true) . "\n" . $exception->getTraceAsString()); } return parent::fault($fault, $code, $data); } public function _shutdown($response) { Moto\Hook::trigger(Moto\Hook::SYSTEM_SHUTDOWN, $response); } public function resetAssignClassMap() { $this->_assignClassMap = []; return $this; } public function assignClass($constructor, $namespace, $lock = false) { if (array_key_exists($namespace, $this->_assignClassMap) && $this->_assignClassMap[$namespace]['lock']) { return false; } $this->_assignClassMap[$namespace] = array( 'constructor' => $constructor, 'namespace' => $namespace, 'lock' => $lock, ); return $this; } public function forceAssign($namespace) { if (!empty($this->_assignClassMap[$namespace])) { $params = $this->_assignClassMap[$namespace]; if (!empty($params['constructor'])) { $constructor = $params['constructor']; if (is_callable($constructor)) { $constructor = $constructor($namespace); } $this->setClass($constructor, $namespace); } $this->_assignClassMap[$namespace] = null; } } protected function _handle() { $request = $this->getRequest(); Moto\Hook::trigger(Moto\Hook::JSONRPC_SERVER_DISPATCH, $request); $method = $request->getMethod(); if (preg_match('/^(.*)\.([^\.]+)$/', $method, $match)) { $namespace = $match[1]; $this->forceAssign($namespace); } parent::_handle(); Moto\Hook::trigger(Moto\Hook::JSONRPC_SERVER_DISPATCHED, $request, $this->getResponse()); } public function setReturnResponse($flag = true) { $this->returnResponse = true; return $this; } } 