<?php
 namespace Moto; use Moto; use Zend\Stdlib\ArrayUtils; class Render { const MAIN_NAMESPACE = '__main__'; const DEFAULT_OPTIONS = '__default'; protected static $_instances = array(); protected static $_inited = false; public static function getInstance($name = self::MAIN_NAMESPACE) { static::init(); if (!array_key_exists($name, static::$_instances)) { static::$_instances[$name] = static::_createRenderEngine($name); } return static::$_instances[$name]; } public static function dropInstance($name) { if (empty($name)) { return false; } if (array_key_exists($name, static::$_instances)) { unset(static::$_instances[$name]); } return true; } public static function init() { if (static::$_inited) { return; } \Twig_Autoloader::register(); static::$_inited = true; } protected static function _createRenderEngine($name) { $options = static::getOptionsByName($name); $class = $options['loader']['type']; $loader = new $class($options['loader']['options']); if (is_string($options['environment']['cache'])) { $options['environment']['cache'] = new Moto\Twig\Cache\Filesystem($options['environment']['cache']); } $options['environment']['base_template_class'] = Moto\Twig\Template::class; $engine = new Moto\Twig\Environment($loader, $options['environment']); $engine->setEngineName($name); $helper = new \Twig_SimpleFilter('json_decode', function ($str, $flag = true) { if (is_string($str)) { return json_decode($str, $flag); } return $str; }); $engine->addFilter($helper); $helper = new \Twig_SimpleFilter('encrypt', function ($value) { return Moto\System::encrypt($value); }); $engine->addFilter($helper); $helper = new \Twig_SimpleFilter('page_html_content', function (\Twig_Environment $twig, $value, $section = null, $type = '') { if (defined('Moto\Hook::RENDER_FILTER__PAGE_HTML_CONTENT')) { $_value = Moto\Hook::trigger(Moto\Hook::RENDER_FILTER__PAGE_HTML_CONTENT, $value, $section, $type); if (is_string($_value)) { $value = $_value; } } return $value; }, array( 'is_safe' => array('html'), 'needs_environment' => true )); $engine->addFilter($helper); $helper = new \Twig_SimpleFilter('base64_encode', function (\Twig_Environment $twig, $value) { return base64_encode($value); }, array( 'is_safe' => array('html'), 'needs_environment' => true )); $engine->addFilter($helper); $helper = new \Twig_SimpleFilter('toArray', function ($value) { return Moto\Util::toArray($value); }, array( 'is_safe' => array('html'), 'needs_environment' => false )); $engine->addFilter($helper); $helper = new \Twig_SimpleFunction('arrayToAttributes', function (\Twig_Environment $twig, $attributes, $options = array(), $context = array()) { $result = ''; if (!is_array($attributes) && !is_object($attributes)) { return ''; } foreach ($attributes as $name => $value) { if (is_array($value) || is_object($value)) { $value = json_encode($value); } $result .= ' ' . $name; if ($value !== null) { $result .= '="' . twig_escape_filter($twig, $value) . '"'; } } return $result; }, array('is_safe' => array('html'), 'needs_environment' => true)); $engine->addFunction($helper); $engine->addExtension(new \Twig_Extension_StringLoader()); $assetExtension = new Moto\Twig\Extension\AssetExtension(); $assetExtension->setEnvironment($engine); $engine->addExtension($assetExtension); if (!empty($options['extensions']['assetExtension']['options'])) { $assetExtension->setOptions($options['extensions']['assetExtension']['options']); } $assetExtension->setOption('autoAddPath', true); if (!empty($options['addPath'])) { foreach ($options['addPath'] as $key => $value) { $assetExtension->addPath(Moto\System::getRelativePath($value), $key); } } $extension = new Moto\Twig\Extension\LinkerExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\ContentHelperExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\EntertainmentExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\LiveChatExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\MotoCallbackExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = Moto\System::app('StyleHelper'); $extension->setOptions(Moto\Util::getValue($options, 'extensions.StyleHelperExtension.options')); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\WidgetsExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $extension = new Moto\Twig\Extension\ElementsExtension(); $extension->setEnvironment($engine); $engine->addExtension($extension); $function = new \Twig_SimpleFunction('getClickAction', function (\Twig_Environment $twig, $name, $options = array(), $context = array()) { return Moto\ClickAction\Factory::create($name, (array) $options); }, array('is_safe' => array('html'), 'needs_environment' => true)); $engine->addFunction($function); $engine->addGlobal('isServer', true); $engine->addGlobal('isClient', false); $engine->addGlobal('BRAND', Moto\System\Brand::getInstance()); $engine->addGlobal('FEATURES', Moto\Features::getList()); $engine->addGlobal('WEBSITE', Moto\Website\Settings::get()); $engine->addGlobal('WEBSITE_ADDRESS_HASH', Moto\Website\Settings::getAddressHash()); $engine->addGlobal('SYSTEM', Moto\System\Settings::get()); $engine->addGlobal('GOOGLE_MAP_API_KEY', Moto\Util::getValue(Moto\Website\Integration::first('google_map'), 'api_key', '')); $engine->addGlobal('features', Moto\Features::getList()); $engine->addGlobal('website', Moto\Website\Settings::get()); Moto\Hook::trigger(Moto\Hook::TWIG_ENGINE__BOOTED, $engine, $name); switch ($name) { case 'admin': Moto\Hook::trigger(Moto\Hook::TWIG_ENGINE_ADMIN__BOOTED, $engine); break; case 'string': Moto\Hook::trigger(Moto\Hook::TWIG_ENGINE_STRING__BOOTED, $engine); break; case '__main__': Moto\Hook::trigger(Moto\Hook::TWIG_ENGINE_WEBSITE__BOOTED, $engine); break; case 'less': Moto\Hook::trigger(Moto\Hook::TWIG_ENGINE_LESS__BOOTED, $engine); break; } $dispatcher = Moto\System::getEventDispatcher(); $dispatcher->dispatch(Moto\Twig\Environment::class, $engine); return $engine; } public static function getOptionsByName($name = self::MAIN_NAMESPACE, $useDefaultOptions = true) { $options = Moto\Config::get('renderEngine.' . $name, array()); if ($useDefaultOptions) { $defaultOptions = Moto\Config::get('renderEngine.' . self::DEFAULT_OPTIONS, array()); $options = ArrayUtils::merge($defaultOptions, $options); } if (!empty($options['loader']['options'])) { foreach ($options['loader']['options'] as $key => $value) { $options['loader']['options'][$key] = Moto\System::getAbsolutePath($value); } } if (!empty($options['environment']['cache'])) { $options['environment']['cache'] = Moto\System::getAbsolutePath($options['environment']['cache']); } if (empty($options['extensions']['assetExtension']['options']['baseUrl'])) { if (Moto\Version::getCurrentBuild() > 26) { $options['extensions']['assetExtension']['options']['baseUrl'] = Moto\System::getRelativeUrl(); } else { $options['extensions']['assetExtension']['options']['baseUrl'] = Moto\Website\Settings::get('address'); } } if (empty($options['extensions']['assetExtension']['options']['basePath'])) { $options['extensions']['assetExtension']['options']['basePath'] = Moto\Config::get('rootPath'); } return $options; } public static function onCacheClean($event = null) { $options = Moto\Config::get('renderEngine'); if (!is_array($options)) { return; } foreach ($options as $name => $value) { if (!empty($value['environment']['cache'])) { $cacheDir = Moto\System::getAbsolutePath($value['environment']['cache']); if (is_dir($cacheDir)) { Moto\Util::deleteDir($cacheDir, false); } } } return true; } } 