<?php
namespace Moto\System\Backup; use Moto; use Illuminate; use JsonSerializable; abstract class AbstractModel implements JsonSerializable, Illuminate\Contracts\Support\Arrayable { protected $_attributes = []; protected $_hidden = []; protected $_visible = []; protected $_readOnlyMode = false; final public function __construct(array $attributes = []) { $this->fill($attributes); } protected function enableReadOnly() { $this->_readOnlyMode = true; } protected function disableReadOnly() { $this->_readOnlyMode = false; } public function isReadOnly() { return $this->_readOnlyMode; } public function fill(array $attributes) { foreach ($attributes as $name => $value) { $this->setAttribute($name, $value); } return $this; } public function unsetAttribute($name) { if ($this->isReadOnly()) { return false; } unset($this->_attributes[$name]); return true; } public function setAttribute($name, $value) { if ($this->isReadOnly()) { return false; } $method = 'set' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } $this->_attributes[$name] = $value; return true; } public function getAttribute($name) { $value = null; if (array_key_exists($name, $this->_attributes)) { $value = $this->_attributes[$name]; } $method = 'get' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { $value = $this->{$method}($value); } return $value; } public function toArray() { $attributes = $this->_attributes; if (count($this->_visible) > 0) { $attributes = Moto\Util::arrayOnly($attributes, $this->_visible); } $attributes = Moto\Util::arrayExcept($attributes, $this->_hidden); $attributes = $this->_mutateAttributes($attributes); return $attributes; } protected function _mutateAttributes($attributes) { foreach ($attributes as $name => $value) { $attributes[$name] = $this->_mutateAttribute($name, $value); } return $attributes; } protected function _mutateAttribute($name, $value) { $method = 'mutate' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { $value = $this->{$method}($value); } if (is_object($value) && method_exists($value, 'toArray')) { $value = $value->toArray(); } return $value; } public function jsonSerialize() { return $this->toArray(); } public function __get($name) { return $this->getAttribute($name); } public function __set($name, $value) { $this->setAttribute($name, $value); } public function __isset($name) { return array_key_exists($name, $this->_attributes); } public function __unset($name) { $this->unsetAttribute($name); } } 