<?php
namespace Moto\System\Backup\Step; use Moto; use Carbon\Carbon; class DatabaseDumpingSqlStep extends Moto\System\Backup\Step\AbstractStep { const NAME = null; protected $_tablePrefix; public function handle($backup) { try { $filePath = $backup->tempPath . '/sql_dump/structure.sql'; $absolutePath = Moto\System::getAbsolutePath($filePath); Moto\Util::filePutContents($absolutePath, ''); $destination = function ($code) use ($absolutePath) { Moto\Util::filePutContents($absolutePath, $code, FILE_APPEND); }; $this->generateStructure($destination); $backup->addFile($filePath, 'mt-backup/sql/structure.sql'); $filePath = $backup->tempPath . '/sql_dump/content.sql'; $absolutePath = Moto\System::getAbsolutePath($filePath); Moto\Util::filePutContents($absolutePath, ''); $destination = function ($code, $meta = null) use ($absolutePath) { Moto\Util::filePutContents($absolutePath, $code, FILE_APPEND); }; $this->generateContent($destination); $backup->addFile($filePath, 'mt-backup/sql/content.sql'); } catch (\Exception $e) { $error = [ 'name' => 'MODULE.TOOLS.BACKUPS.ERROR_MESSAGE.BACKUP_STEP_FAILED', 'params' => [ 'message' => $e->getMessage(), 'code' => $e->getCode(), ] ]; if ($e instanceof Moto\Exception) { $error = [ 'name' => $e->getMessage(), 'params' => $e->getErrors(), ]; } return $this->returnError($error); } return $this->returnCompleted(); } public function getBackupMetaInformation() { $tables = (array) $this->getAttribute('tables'); $metaTables = []; foreach ($tables as $table => $properties) { $plugin = Moto\Util::getValue($properties, 'plugin'); if (!$plugin) { continue; } $metaTables[] = $properties; } if (count($metaTables) < 1) { return null; } return [ 'tables' => $metaTables, ]; } protected function generateContent($destination = null) { $proxy = (object) [ 'current' => null, 'code' => '', ]; if ($destination && !is_callable($destination)) { throw new Moto\Exception('Invalid param "destination"'); } if (!$destination) { $destination = function ($code) use ($proxy) { $proxy->code .= $code; }; } $processor = function ($header, $code = null, $meta = null) use ($proxy, $destination) { if (!$code) { return; } $comment = ''; if (is_array($meta)) { $comment = '-- '; $comment .= 'Table : ' . Moto\Database\Util::backQuoteName($meta['table']) . '; Records : ' . $meta['queryLines'] . '; Part : ' . $meta['queriesPart']; $comment .= "\n"; } else { $meta = [ 'table' => Moto\Util::getValue($proxy->current, 'table'), ]; } $meta['type'] = 'sql'; $current = $proxy->current; $plugin = Moto\Util::getValue($current, 'plugin'); if ($plugin) { $connector = Moto\System\PluginManager::getConnector($plugin); if (!$connector) { throw new \RuntimeException('Cant retrieve connector for plugin "' . $plugin . '"'); } $backupProvider = $connector->getBackupProvider(); if (!$backupProvider) { throw new \RuntimeException('Cant retrieve backup provider for plugin "' . $plugin . '"'); } $code = $backupProvider->sanitizeExportedContent($code, $meta, $header); } if (!$code) { return; } if (is_array($code)) { $code = $header . "\n" . implode(",\n", $code) . ";\n"; } else { $code = $header . "\n" . $code . ";\n"; } $destination($comment . $code); }; $destination($this->generateCommonBanner()); $exporter = $this->getExporter(); $tables = (array) $this->getAttribute('tables'); foreach ($tables as $table => $properties) { if (array_key_exists('dump', $properties)) { if (!in_array('content', (array) $properties['dump'], true)) { continue; } } $proxy->current = $properties; try { $exporter->getTableContent($table, [ 'processor' => $processor, ]); } catch (\Exception $e) { throw new Moto\System\Exception('MODULE.TOOLS.BACKUPS.ERROR_MESSAGE.FAILED_EXPORT_TABLE_CONTENT', 500, [ 'table' => $table, 'exception' => $e->getMessage(), ]); } $destination("\n"); } $destination($this->generateCommonFooter()); return $proxy->code; } protected function generateStructure($destination = null) { $proxy = (object) [ 'current' => null, 'code' => '', ]; if ($destination && !is_callable($destination)) { throw new Moto\Exception('Invalid param "destination"'); } if (!$destination) { $destination = function ($code) use ($proxy) { $proxy->code .= $code; }; } $processor = function ($code = null) use ($proxy, $destination) { if (!$code) { return; } $current = $proxy->current; $comment = ''; $meta = [ 'table' => Moto\Util::getValue($current, 'table'), 'type' => 'sql', ]; if (Moto\Util::getValue($current, 'removeForeignKeyName', true)) { $code = Moto\Database\Export\Util::removeForeignKeyName($code); } $plugin = Moto\Util::getValue($current, 'plugin'); if ($plugin) { $connector = Moto\System\PluginManager::getConnector($plugin); if (!$connector) { throw new \RuntimeException('Cant retrieve connector for plugin "' . $plugin . '"'); } $backupProvider = $connector->getBackupProvider(); if (!$backupProvider) { throw new \RuntimeException('Cant retrieve backup provider for plugin "' . $plugin . '"'); } $code = $backupProvider->sanitizeExportedStructure($code, $meta); } if (!$code) { return; } $destination($comment . $code); }; $destination($this->generateCommonBanner()); $exporter = $this->getExporter(); $tables = (array) $this->getAttribute('tables'); foreach ($tables as $table => $properties) { if (array_key_exists('dump', $properties)) { if (!in_array('structure', (array) $properties['dump'], true)) { continue; } } $proxy->current = $properties; try { $processor($exporter->getTableStructure($table) . "\n"); } catch (\Exception $e) { throw new Moto\System\Exception('MODULE.TOOLS.BACKUPS.ERROR_MESSAGE.FAILED_EXPORT_TABLE_STRUCTURE', 500, [ 'table' => $table, 'exception' => $e->getMessage(), ]); } } $destination($this->generateCommonFooter()); return $proxy->code; } protected function getExporter() { return Moto\Database\Export\SqlExport::getInstance(); } public function getTablePrefix() { if ($this->_tablePrefix === null) { $this->_tablePrefix = Moto\Database\Provider::getTablePrefix(); } return $this->_tablePrefix; } protected function generateCommonBanner() { $code = []; $code[] = 'SET FOREIGN_KEY_CHECKS=0;'; $code[] = 'SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";'; $code[] = 'SET time_zone = "+00:00";'; $code[] = ''; $code[] = '/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;'; $code[] = '/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;'; $code[] = '/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;'; $code[] = '/*!40101 SET NAMES ' . Moto\Config::get('database.charset', 'utf8mb4') . ' */;'; return implode("\n", $code) . "\n\n"; } protected function generateCommonFooter() { $code = []; $code[] = 'SET FOREIGN_KEY_CHECKS=1;'; $code[] = '/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;'; $code[] = '/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;'; $code[] = '/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;'; return implode("\n", $code) . "\n"; } public static function prepareStepAttributes($attributes, $plugins) { $proxy = (object) [ 'tables' => [], ]; $tables = Moto\Database\Provider::getSystemTables(); $sanitize = function ($index, $value) use ($proxy) { if (is_array($value)) { $data = $value; if (!array_key_exists('table', $data) && is_string($index)) { $data['table'] = $index; } } else { $data = [ 'table' => $value, ]; } $tableName = trim((string) Moto\Util::getValue($data, 'table')); if (!preg_match('/^[a-z][a-z0-9\_\-]*$/i', $tableName)) { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException('Invalid table name "' . $tableName . '"'); } return null; } if (array_key_exists($tableName, $proxy->tables)) { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException('Table "' . $tableName . '" already exists on table list'); } return null; } return $data; }; foreach ($tables as $index => $value) { $data = $sanitize($index, $value); if ($data) { $proxy->tables[$data['table']] = $data; } } foreach ($plugins as $plugin) { $backupProvider = $plugin->getBackupProvider(); if (!$backupProvider) { continue; } $tables = $backupProvider->getTables(); if (!is_array($tables)) { continue; } foreach ($tables as $index => $value) { $data = $sanitize($index, $value); if ($data) { $data['plugin'] = $plugin->getName(); $proxy->tables[$data['table']] = $data; } } } $attributes['tables'] = $proxy->tables; return $attributes; } } 