<?php
namespace Moto\System\Backup\Step; use Moto; use RecursiveDirectoryIterator; class FileCopyingStep extends Moto\System\Backup\Step\AbstractStep { const NAME = 'file:copying'; public function handle($backup) { $meta = (array) $this->getAttribute('meta'); $virtual = $backup->getVirtualStorage(); $totalFiles = (int) $this->getPreviousResult('totalFiles'); if ($totalFiles < 1) { $totalFiles = $virtual->getQueue()->count(); } $copyingRepeating = (int) $this->getPreviousResult('copyingRepeating'); $copyingRepeating++; $meta['runs'] = $copyingRepeating; $meta['total'] = $totalFiles; $this->setAttribute('meta', $meta); Moto\System\Log::debug("\tattach disk storage"); $backup->attachDiskStorage(); Moto\System\Log::debug("\tattached => flushing [$copyingRepeating]"); $backup->flush(); $meta['remain'] = $virtual->getQueue()->count(); $meta['passed'] = $meta['total'] - $meta['remain']; $this->setAttribute('meta', $meta); if ($virtual->isFlushed()) { Moto\System\Log::debug("\tflushed"); return $this->returnCompleted(); } Moto\System\Log::debug("\tneed to repeat copying"); return $this->returnNeedRepeat([ 'totalFiles' => $totalFiles, 'copyingRepeating' => $copyingRepeating, ]); } } 