<?php
namespace Moto\System\Backup\Step; use Moto; use RecursiveDirectoryIterator; class FileScanningStep extends Moto\System\Backup\Step\AbstractStep { const NAME = 'file:scanning'; public function handle($backup) { Moto\System\Log::debug("\tstart scanning"); $stats = [ 'timing' => microtime(1), 'delta_memory_get_peak_usage' => memory_get_peak_usage(), 'delta_memory_get_usage' => memory_get_usage(), ]; $list = $this->findAndAddFiles($backup); $stats['timing'] = abs(microtime(1) - $stats['timing']); $stats['delta_memory_get_peak_usage'] = abs(memory_get_peak_usage() - $stats['delta_memory_get_peak_usage']); $stats['delta_memory_get_usage'] = abs(memory_get_peak_usage() - $stats['delta_memory_get_usage']); $stats['memory_get_peak_usage'] = memory_get_peak_usage(); $stats['memory_get_usage'] = memory_get_peak_usage(); $stats['count_files'] = count($list); $stats['encoded_list'] = strlen(json_encode($list)); foreach ($stats as $index => $value) { if (is_float($value)) { $stats[$index] = number_format($value, 3); } else { $stats[$index] = number_format($value); } } Moto\System\Log::debug("\tscanning done : found " . count($list) . ' file(s)'); $this->setAttribute('meta', [ 'files' => count($list), ]); Moto\Util::filePutContents(Moto\System::getAbsolutePath('@websiteBackupTempDir/latest_file_scan_result.json'), json_encode($list, JSON_PRETTY_PRINT)); return $this->returnCompleted(); } protected function findAndAddFiles($backup = null) { $root = Moto\System::getAbsolutePath('@website'); $options = [ 'prependFiles' => [ '.htaccess', 'api.php', 'app.php', 'common.php', 'index.php', ], 'createDirs' => [ ], 'createNotWebIndexingDirs' => [ '@websiteBackupDir', '@pluginsTempDir', '@cacheDir', '@cacheWebsitePageDir', '@temp', '@updateTemp', '@tempUploads', '@websiteBackupTempDir', '@systemLogDir', '@widgetsStorageDir', '@marketplaceTempDir', ], 'ignoreTargets' => [ '@temp', '@updateTemp', '@tempUploads', '@websiteBackupDir', '@websiteBackupTempDir', '@websiteStorageDir/maintenance.json', '@websiteSettings', ], 'ignoreDirs' => [ '.git', '.svn', '.hg', 'node_modules', ], ]; $processor = function ($file, $relativePath) use ($backup) { if ($file->isDir()) { $backup->addEmptyDir($relativePath); } else { $backup->addFile($relativePath); } }; $continueScan = function ($file) { if ($file->isDir() && file_exists($file->getPathname() . '/.ignore')) { return false; } return true; }; $options['processor'] = $processor; $convertToRelativePath = function ($value) { $value = trim($value); if ($value !== '' && $value[0] === '@') { $value = Moto\System::getRelativePath($value); } return $value; }; $pathsForScan = [ '@admin', '@websiteContentDir', '@systemIncludes', '@userUploads', '@plugins', ]; $pathsForScan = $this->_updateOptions('pathsForScan', $pathsForScan, $convertToRelativePath); $options['prependFiles'] = $this->_updateOptions('prependFiles', $options['prependFiles'], $convertToRelativePath); $options['ignoreTargets'] = $this->_updateOptions('ignoreTargets', $options['ignoreTargets'], $convertToRelativePath); $options['ignoreDirs'] = $this->_updateOptions('ignoreDirs', $options['ignoreDirs'], $convertToRelativePath); $options['createDirs'] = $this->_updateOptions('createDirs', $options['createDirs'], $convertToRelativePath); $options['createNotWebIndexingDirs'] = $this->_updateOptions('createNotWebIndexingDirs', $options['createNotWebIndexingDirs'], $convertToRelativePath); foreach ($options['createDirs'] as $path) { $backup->addEmptyDir($path); } foreach ($options['createNotWebIndexingDirs'] as $path) { $backup->addEmptyDir($path); $backup->addFromString($path . '/index.html', '<!DOCTYPE html><head><meta http-equiv="refresh" content="0; url=../" /></head><body></body>'); } foreach ($options['prependFiles'] as $path) { $backup->addFile($path); } $list = []; foreach ($pathsForScan as $index => $relativePath) { $relativePath = trim($relativePath); if (empty($relativePath)) { continue; } if ($backup->getCurrentStorage()->hasName($relativePath)) { Moto\System\Log::debug('[FileScanningStep] : skip scan by "already" ' . $relativePath); continue; } if (in_array($relativePath, $options['ignoreTargets'], true)) { Moto\System\Log::debug('[FileScanningStep] : ignore path "' . $relativePath . '" by "ignoreTargets"'); continue; } Moto\System\Log::debug('[FileScanningStep] : start scan ' . $relativePath); $backup->addEmptyDir($relativePath); $list[] = $relativePath; $list = Moto\Util::scanRecursiveDirectory($root, $relativePath, $options, $list); } return $list; } protected function _updateOptions($name, array $target, \Closure $sanitizer = null) { $manager = Moto\System\Backup\BackupManager::getInstance(); $optionValue = $manager->getConfig('steps.file:scanning.' . $name); if ($sanitizer) { $target = array_map($sanitizer, $target); } if (empty($optionValue)) { return $target; } if (is_string($optionValue)) { $optionValue = explode(',', $optionValue); } if (!is_array($optionValue)) { return $target; } $optionValue = array_map('trim', $optionValue); if ($optionValue[0] === '+') { array_shift($optionValue); } else { $target = []; } foreach ($optionValue as $value) { $value = trim($value); if ($value === '') { continue; } if ($sanitizer) { $value = $sanitizer($value); } $target[] = $value; } $target = array_unique($target); $target = array_values($target); return $target; } } 