<?php
 namespace Moto\System\ContentSection; use Doctrine\Common\Inflector\Inflector; use Illuminate\Support\Collection; use Moto; use Moto\Module\Blog\PostContentPage; use Zend; abstract class ContentProvider { const DEFINITION_CLASSIFICATION_TAXONOMY = 'taxonomy'; const NAME = null; const PAGE__INDEX = 'index'; const PAGE__POST = 'post'; const PAGE__TAG = 'tag'; const PAGE__CATEGORY = 'category'; protected $baseDefinitionNames = ['index', 'post']; use Moto\System\Traits\OptionsTrait; protected $_options = []; protected $labels = []; protected $cache = []; protected $helper; protected $manager; protected $websiteApplicationClass; protected $websiteApplication; protected $app; protected $widgetAlias = [ ]; public function __construct($app) { $this->app = $app; } public function bootstrap() { } public function setManager(Moto\System\ContentSection\ContentSectionManager $manager) { $this->manager = $manager; return $this; } public function isAllowedForUsing() { return true; } public function getWebsiteApplicationClass() { if (!$this->websiteApplicationClass) { throw new \Exception('Content provider doesnt have website application class [' . get_class($this) . ']'); } return $this->websiteApplicationClass; } public function getLabel($name, $default = null) { if (array_key_exists($name, $this->labels)) { return $this->labels[$name]; } return $default; } public function registerAsWebsiteApplication($manager, $asName = null) { if (empty($asName)) { $asName = $this->getNamespace(); } $app = $this->getWebsiteApplication(); if (!$manager->addSection($asName, $app)) { Moto\System\Log::critical('[Content Provider] : cant add provider AsWebsiteApplication ', [ 'name' => $asName, 'this' => get_class($this), '$app' => get_class($app), ]); return false; } Moto\Hook::on(Moto\Hook::WIDGET_BREADCRUMBS__FULL_PAGE_COLLECTION_FILLED, [$app, 'onFillingBreadcrumbs']); return true; } public function registerAsHomePage($service, $asName = null) { if (empty($asName)) { $asName = $this->getNamespace(); } if (!$service->addProvider($asName, [ 'label' => $this->getLabel('HOME_PAGE_PROVIDER_LABEL', ucwords($asName) . ' # ' . __LINE__), 'class' => $this->getWebsiteApplicationClass(), ])) { Moto\System\Log::critical('[Content Provider] : cant add provider AsHomePage ', [ 'name' => $asName, 'this' => get_class($this), ]); return false; } return true; } public function registerClickActions($manager, $asName = null) { if (empty($asName)) { $asName = $this->getNamespace(); } $manager->setClickActionAlias($asName . '.index', 'page'); $manager->setClickActionAlias($asName . '.post', 'page'); foreach ($this->getTaxonomyDefinitions() as $name => $taxonomy) { $manager->setClickActionAlias($asName . '.' . $name, 'taxonomy'); } return true; } public function getManager() { return $this->manager; } public function hasHelper() { return (!empty($this->helper)); } public function getHelper() { if (is_object($this->helper)) { return $this->helper; } if (empty($this->helper)) { throw new \RuntimeException('This provider doesnt have helper'); } $helper = Moto\System::app($this->helper); $helper->setType($this->getName()); $helper->setProvider($this); $helper->prepareHelper(); $this->helper = $helper; return $helper; } public function getName() { return static::NAME; } public function getDefaultProperties() { return []; } public function getNamespace() { return $this->getName(); } public function getMainPageType() { return $this->getNamespace() . '.' . static::PAGE__INDEX; } public function getPostPageType() { return $this->getNamespace() . '.' . static::PAGE__POST; } public function getTaxonomyDefinitions() { if (is_array($this->_options['taxonomies'])) { $this->_options['taxonomies'] = new Collection($this->_options['taxonomies']); $this->_options['taxonomies']->transform(function ($attributes, $name) { $definition = TaxonomyDefinition::createFromArray($attributes); if (empty($definition->name)) { $definition->name = $name; } $definition->setProvider($this); return $definition; }); } return $this->_options['taxonomies']; } public function getTaxonomyDefinition($name, $property = null, $default = null) { if (empty($name)) { return null; } $taxonomy = $this->getTaxonomyDefinitions()->get($name); if ($property === null) { return $taxonomy; } return Moto\Util::getValue($taxonomy, $property, $default); } public function createTaxonomyDefinition(array $attributes) { if (empty($attributes['name']) || empty($attributes['uri'])) { return false; } $name = $attributes['name']; if (in_array($name, $this->baseDefinitionNames, true)) { return false; } $definitions = $this->getTaxonomyDefinitions(); if ($definitions->has($name)) { return false; } $uri = $attributes['uri']; $uris = $definitions->pluck('uri', 'uri')->all(); $uris = array_filter($uris); for ($index = 0; $index < 1000; $index++) { if (!array_key_exists($uri, $uris)) { break; } $uri = $attributes['uri'] . '-' . ($index + 1); } $attributes['uri'] = $uri; if (empty($attributes['nameInPlural'])) { $attributes['nameInPlural'] = Inflector::pluralize($attributes['name']); } if (empty($attributes['type'])) { $attributes['type'] = 'many'; } $attributes['isSystem'] = (boolean) Moto\Util::getValue($attributes, 'isSystem', false); $definition = TaxonomyDefinition::createFromArray($attributes); $template = $this->getHelper()->getOrCreateTaxonomyTemplate($definition); $definition->template = $template->id; $definitions->offsetSet($name, $definition); $this->saveConfiguration(); return $definition; } public function updateTaxonomyDefinition($name, array $values) { $taxonomy = $this->getTaxonomyDefinition($name); if (!$taxonomy) { return false; } unset($values['classification']); $taxonomy->fill($values); $this->saveConfiguration(); return $taxonomy; } public function deleteTaxonomyDefinition($name) { $definitions = $this->getTaxonomyDefinitions(); $taxonomy = $definitions->get($name); if (!$taxonomy) { return false; } if ($taxonomy->isSystem || !$taxonomy->isTaxonomy()) { return false; } $template = $this->getTemplate($name); if ($template instanceof Moto\Application\Pages\PageModel) { $table = Moto\System::getDbTable('pages'); $table->deleteById($template->id); } elseif ($template instanceof Moto\Database\Page) { $template->delete(); } else { throw new \RuntimeException('Unknown template type'); } Moto\Database\Models\ContentTaxonomy::query() ->where('type', '=', $taxonomy->fullName) ->delete(); $definitions->offsetUnset($name); $this->saveConfiguration(); return true; } public function getTaxonomyTypes() { $namespace = $this->getNamespace(); return $this->getTaxonomyDefinitions()->transform(function ($taxonomy) use ($namespace) { return $namespace . '.' . $taxonomy->name; })->values()->all(); } public function getProperties() { return $this->getOptions(); } public function getFrontendConfig() { $config = $this->getProperties(); $config = json_decode(json_encode($config), true); $config['definitions'] = $this->getDefinitions()->toArray(); $config['taxonomies'] = $this->getTaxonomyDefinitions(); return $config; } public function getProperty($name, $default = null) { return $this->getOption($name, $default); } public function setProperties(array $properties) { $this->setOptions($properties); return $this; } public function transformRawProperties($callback) { if (!is_callable($callback)) { return false; } $result = call_user_func($callback, $this->_options); if (!is_array($result)) { return false; } $this->_options = $result; return true; } public function saveConfiguration() { return $this->getManager()->saveConfiguration(); } public function getSettingInputFilter() { return new Moto\Application\ContentSection\InputFilter\Save(); } protected function getCache($name) { if (array_key_exists($name, $this->cache)) { return $this->cache[$name]; } return false; } protected function setCache($name, $value) { $this->cache[$name] = $value; return $this; } public function dropCache() { $this->cache = []; return $this; } public function getMainPageId() { $id = $this->getDefinition('index', 'template'); if (empty($id)) { $id = $this->getProperty('page_id'); } return (int) $id; } public function getMainPage() { $page = $this->getCache(__FUNCTION__); if ($page) { return $page; } $table = Moto\System::getDbTable('pages'); $page = null; $id = $this->getMainPageId(); if ($id > 0) { $page = $table->getById($id); } if (!$page) { $items = $table->select([ 'type' => $this->getMainPageType(), ]); $page = $items->current(); } if ($page) { $this->setCache(__FUNCTION__, $page); } return $page; } public function getUri() { return $this->getMainPage()->url; } public function getAbsoluteUrl($query = null) { return $this->getMainPage()->getAbsoluteUrl($query); } public function getWebsiteApplication() { if ($this->websiteApplication) { return $this->websiteApplication; } $class = $this->getWebsiteApplicationClass(); $this->app->singleton($class); $this->websiteApplication = $this->app->make($class); return $this->websiteApplication; } public function getDefinitions() { if (is_array($this->_options['definitions'])) { $this->_options['definitions'] = new Collection($this->_options['definitions']); $this->_options['definitions']->transform(function ($attributes, $name) { $definition = Definition::createFromArray($attributes); if (empty($definition->name)) { $definition->name = $name; } $definition->setProvider($this); return $definition; }); } return $this->_options['definitions']; } public function getDefinition($type, $property = null, $default = null) { $definitions = $this->getDefinitions(); if (!$definitions instanceof Collection) { Moto\System\Log::emergency(__METHOD__ . ' => ' . json_encode([ 'provider' => $this->getNamespace(), 'options' => $this->_options, ], JSON_PRETTY_PRINT)); } return Moto\Util::getValue($definitions->get($type), $property, $default); } public function wrapByContentPage($target) { $page = null; if ($target instanceof Moto\Database\Models\ContentTaxonomy) { $template = $this->getTemplate($target->getMetaType('taxonomy')); if ($template) { $page = new Moto\Website\ContentTaxonomyPage(); $page->setTemplateEntity($template); $page->setContentEntity($target); } } elseif ($target instanceof Moto\Application\Pages\PageModel) { if ($target->isPost()) { $page = new PostContentPage($target); } } return $page; } public function getTemplates() { $collection = new Collection(); foreach ($this->getDefinitions() as $name => $definition) { $template = $this->getTemplate($name); if ($template) { $collection->put($name, $template); } } foreach ($this->getTaxonomyDefinitions() as $name => $definition) { $template = $this->getTemplate($name); if ($template) { $collection->put($name, $template); } } return $collection; } protected function findDefinition($name) { if (in_array($name, $this->baseDefinitionNames, true)) { return $this->getDefinition($name); } $definition = $this->getTaxonomyDefinition($name); if (!$definition) { $definition = $this->getDefinition($name); } return $definition; } public function getTemplate($type) { $template = $this->getCache(__FUNCTION__ . '|' . $type); if ($template) { return $template; } $table = Moto\System::getDbTable('pages'); $table->useResultAsModel(true); $id = null; $definition = $this->findDefinition($type); if ($definition) { $id = $definition->template; } if (empty($id)) { $id = $this->getProperty($type . '_template_id'); } $id = (int) $id; $template = null; if ($id > 0) { $template = $table->getById($id); } elseif (Moto\System::isDevelopmentStage()) { Moto\System\Log::emergency($this->getNamespace() . ' : options => ' . var_export([ 'type' => $type, 'key' => 'definitions.' . $type . '.template', 'definitions' => $this->getDefinitions()->toArray(), ], true)); throw new \RuntimeException($this->getNamespace() . ' : Cant find ID # ' . var_export($id, true) . ' for template : ' . var_export($type, true)); } if (!$template && Moto\System::isDevelopmentStage()) { throw new \RuntimeException($this->getNamespace() . ' : Cant load template : ' . var_export($type, true) . ' with ID ' . var_export($id, true)); } if (!$template) { $items = $table->select([ 'type' => 'template.' . $this->getNamespace() . '.' . $type, ]); $template = $items->current(); } if (!$template) { $template = $table->getByUrl($this->getProperty($type . '_template')); } if ($template) { $this->setCache(__FUNCTION__ . '|' . $type, $template); } return $template; } public function findTemplateFor($target) { if ($target instanceof Moto\Application\Pages\PageModel) { if ($target->isPost()) { return $this->getPostTemplate(); } } return false; } public function getPostTemplate() { return $this->getTemplate(static::PAGE__POST); } public function getPostQuery($where = []) { $query = Moto\Database\Page::query(); $query->where('type', '=', $this->getPostPageType()); return $query; } public function resolveSitemapPreferenceForTaxonomy(Moto\Database\Models\ContentTaxonomy $entity, array $preferences) { $response = [ 'priority' => '0.5', 'frequency' => NULL, ]; $type = $entity->type; if (array_key_exists($type, $preferences)) { $response = array_merge($response, $preferences[$type]); } else { $type = $this->getNamespace() . '.taxonomy'; if (array_key_exists($type, $preferences)) { $response = array_merge($response, $preferences[$type]); } } $response['type'] = $entity->type; return $response; } public function resolveWidget($shortName, $currentInfo = []) { if (!empty($currentInfo)) { Moto\System\Log::debug('[ContentProvider] : Widget info maybe already resolved ' . var_export([ 'widget' => $shortName, '$currentInfo' => $currentInfo, ], true)); return $currentInfo; } if (array_key_exists($shortName, $this->widgetAlias)) { $parent = $this->widgetAlias[$shortName]; } else { $parent = 'blog.' . $shortName; } $info = Moto\System\Widgets\Factory::getWidgetInfo($parent); if (!is_array($info) || empty($info['renderClass'])) { Moto\System\Log::error('[ContentProvider] : Cant find parent widget or empty "renderClass" ' . var_export([ 'parent' => $parent, 'info' => $info, ], true)); return $currentInfo; } $info['name'] = $this->getNamespace() . '.' . $shortName; $class = $info['renderClass']; $info['constructor'] = function ($name, $options) use ($class) { $widget = new $class($options); $widget->setWidgetName($name); return $widget; }; return $info; } } 