<?php
 namespace Moto\System\ContentSection; use Illuminate\Support\Arr; use Illuminate\Support\Collection; use InvalidArgumentException; use Moto; use Zend; class ContentSectionManager { const SETTING_KEY = 'content_sections'; const VERSION_PROPERTY = '__version'; const DEFAULT_CONFIGURATION = [ 'registered' => [ 'blog' => [ 'name' => 'blog', 'provider' => Moto\Module\Blog\BlogContentProvider::class, ], ], ]; protected $app; protected $configuration = [ 'registered' => [ 'blog' => [ 'name' => 'blog', 'provider' => Moto\Module\Blog\BlogContentProvider::class, ], ], ]; protected $providers = []; public function __construct(Moto\System\Application $app) { $this->app = $app; $this->loadConfiguration(); } protected function loadConfiguration() { $configuration = $this->getRawSettings(); if (is_object($configuration)) { $configuration = json_encode($configuration); } if (is_string($configuration)) { $configuration = json_decode($configuration, true); } $this->configuration = $this->migrateConfiguration($configuration); } protected function migrateConfiguration($configuration) { if (array_key_exists(static::VERSION_PROPERTY, $configuration)) { return $configuration; } $configuration[static::VERSION_PROPERTY] = 1; $default = $this->getDefaultConfiguration(); $configuration['registered'] = $default['registered']; foreach ($configuration['providers'] as $index => $provider) { $configuration['providers'][$index] = array_merge([ static::VERSION_PROPERTY => 1, ], $provider); } return $configuration; } public function getConfiguration() { return $this->configuration; } public function getDefaultConfiguration() { $settings = static::DEFAULT_CONFIGURATION; if (is_string($settings)) { $settings = json_decode($settings, true); } return $settings; } protected function getRawSettings() { if (!is_string(static::SETTING_KEY)) { throw new \RuntimeException('Setting key not string'); } $value = Moto\Website\Settings::get(static::SETTING_KEY); if (!$value) { $value = $this->getDefaultConfiguration(); } return $value; } protected function getSetting($name, $default = null) { return Moto\Util::getValue($this->configuration, $name, $default); } public function registeredProvider($name) { return Arr::has($this->configuration, 'registered.' . $name); } protected function isCompatibleProvider($provider) { if ($provider instanceof ContentProvider) { $name = $provider->getName(); if (!is_string($name)) { return false; } $name = trim($name); if ($name === '') { return false; } return true; } return false; } public function getProvider($name) { if (!is_string($name)) { throw new \InvalidArgumentException('Type is not string'); } if (array_key_exists($name, $this->providers)) { return $this->providers[$name]; } if (!$this->registeredProvider($name)) { return false; } $provider = $this->resolveProvider($name); if (!$provider) { throw new \Exception('Cant create provider : ' . var_export($name, true)); } $provider->bootstrap(); $this->providers[$name] = $provider; return $provider; } protected function resolveProvider($name) { $class = trim((string) $this->getSetting('registered.' . $name . '.provider')); if ($class === '' || !class_exists($class)) { return false; } $options = (array) $this->getSetting('providers.' . $name); try { $provider = $this->app->make($class, ['app' => $this->app]); } catch (\Exception $e) { Moto\System\Log::error('[' . __METHOD__ . '] : Exception [' . $e->getCode() . '] ' . $e->getMessage()); return false; } if (!$this->isCompatibleProvider($provider)) { Moto\System\Log::error('[' . __METHOD__ . '] : Provider "' . get_class($provider) . '" not compatible'); return false; } $provider->setProperties($options); $provider->setManager($this); return $provider; } public function getProviders() { return $this->providers; } public function getAvailableProviders() { $collection = new Collection(); foreach ($this->getSetting('registered') as $name => $settings) { try { if (array_key_exists('plugin', $settings)) { if (!Moto\System\PluginManager::isActivated($settings['plugin'])) { continue; } } $provider = $this->getProvider($name); if (!$provider) { continue; } $collection->offsetSet($name, $provider); } catch (\Exception $e) { Moto\System\Log::error("Exception :  [{$e->getCode()}] {$e->getMessage()}"); } } return $collection; } public function addProvider(ContentProvider $provider) { if (!$this->isCompatibleProvider($provider)) { throw new InvalidArgumentException('Provider not compatible'); } $name = $provider->getName(); if ($this->registeredProvider($name)) { return false; } $this->providers[$name] = $provider; return true; } public function register(ContentProvider $provider, Moto\System\PluginConnector $plugin) { if (1 === 2) { Moto\System\Integration\LiveChatManager::register(); } if (!$this->isCompatibleProvider($provider)) { throw new InvalidArgumentException('Provider not compatible'); } $name = $provider->getName(); if (!is_string($name)) { throw new InvalidArgumentException('Provider is invalid'); } $name = trim($name); if ($name === '') { throw new InvalidArgumentException('Provider has empty name'); } if ($this->registeredProvider($name)) { throw new InvalidArgumentException('Provider "' . $name . '" already registered'); } $properties = $provider->getDefaultProperties(); if (!is_array($properties)) { throw new InvalidArgumentException('Provider has wrong default properties type'); } $this->configuration['providers'][$name] = $properties; $this->configuration['registered'][$name] = [ 'name' => $provider->getName(), 'provider' => get_class($provider), 'plugin' => $plugin->getName(), ]; $this->providers[$name] = $provider; $provider->setManager($this); $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); try { $this->saveConfiguration(); $helper = $provider->getHelper(); if ($helper) { $helper->checkOrInstall(); } $connection->commit(); } catch (\Exception $e) { unset($this->providers[$name]); unset($this->configuration['providers'][$name]); unset($this->configuration['registered'][$name]); $connection->rollBack(); Moto\System\Log::emergency('[Content Provider] : error on register provider => ' . var_export([ 'provider' => [ 'name' => $name, 'class' => get_class($provider), ], 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), 'line' => $e->getLine(), ], ], true)); throw $e; } return $this; } public function unregister($provider) { $name = null; if ($provider instanceof ContentProvider) { if (!$this->isCompatibleProvider($provider)) { return false; } $name = $provider->getName(); } elseif (is_string($provider)) { $name = $provider; } if (!$this->registeredProvider($name)) { return false; } unset($this->providers[$name]); unset($this->configuration['registered'][$name]); unset($this->configuration['providers'][$name]); $this->saveConfiguration(); return true; } public function syncConfiguration() { foreach ($this->providers as $provider) { $name = $provider->getName(); if (!$this->registeredProvider($name)) { continue; } $this->configuration['providers'][$name] = $provider->getProperties(); } } public function saveConfiguration() { $this->syncConfiguration(); return Moto\Website\Settings::add(static::SETTING_KEY, $this->configuration, 'array'); } public function getFrontendConfig() { $config = []; $this->getAvailableProviders(); foreach ($this->getProviders() as $name => $provider) { $config[$name] = $provider->getFrontendConfig(); } $config = json_decode(json_encode($config), true); return $config; } public function requireProvider($name) { $instance = $this->getProvider($name); if ($instance) { return $instance; } throw new \RuntimeException('Unknown content provider: ' . var_export($name, true)); } } 