<?php
namespace Moto\System\Dependency; use Moto; use JsonSerializable; abstract class AbstractDependency implements JsonSerializable { protected $_attributes = []; protected $_appends = []; protected $_hidden = []; protected $_visible = []; public function __construct($attributes = []) { $this->fill($attributes); } abstract public function getProgress(); abstract public function prepareDependencies(); abstract public function downloadDependencies($limits = []); abstract public function installDependencies($limits = []); abstract public function cleaningTemporary(); public function fill($attributes) { if (!is_array($attributes)) { return false; } foreach ($attributes as $name => $value) { if (!$this->setAttribute($name, $value)) { return false; } } return true; } public function getAttributes() { return $this->_attributes; } public function setAttribute($name, $value) { $method = 'set' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } $this->_attributes[$name] = $value; return true; } public function getAttribute($name) { $value = Moto\Util::getValue($this->_attributes, $name); $method = 'get' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } return $value; } public function toArray() { $result = []; if (count($this->_visible)) { $attributes = $this->_visible; } else { $attributes = array_keys($this->_attributes); } $attributes = Moto\Util::arrayExcept(array_flip($attributes), $this->_hidden); $attributes = array_keys($attributes); $attributes = array_merge($attributes, $this->_appends); foreach ($attributes as $attribute) { $result[$attribute] = $this->getAttribute($attribute); } return $result; } public function jsonSerialize() { return $this->toArray(); } public function __set($name, $value) { $this->setAttribute($name, $value); } public function __get($name) { return $this->getAttribute($name); } } 