<?php
namespace Moto\System\Dependency; use Moto; class WebsiteTheme extends Moto\System\Dependency\AbstractDependency { protected $_attributes = [ 'target' => null, 'update' => null, ]; public function getProgress() { $stats = [ 'total' => 1, 'downloaded' => (int) Moto\Util::getValue($this->_attributes, 'update.downloaded'), 'installed' => (int) Moto\Util::getValue($this->_attributes, 'update.installed'), ]; return $stats; } public function setTargetAttribute($value) { if ($this->_attributes['target']) { return false; } if (!is_array($value)) { return false; } $value = Moto\Util::arrayOnly($value, ['name', 'label', 'version', 'build', 'template_id']); if (count($value) !== 5) { return false; } $this->_attributes['target'] = $value; return true; } public function setUpdateAttribute($update) { $required = Moto\Util::arrayOnly($update, [ 'name', 'build', 'version', 'min_engine_version', 'min_engine_build', 'downloadable', 'url', 'file_size', 'file_md5', ]); if (count($required) !== 9) { return false; } $update['downloaded'] = (boolean) Moto\Util::getValue($update, 'downloaded', false); $update['installed'] = (boolean) Moto\Util::getValue($update, 'installed', false); $this->_attributes['update'] = $update; return true; } public function prepareDependencies() { if (!$this->_attributes['target'] || !$this->_attributes['update']) { throw new Moto\Exception('Required attributes are empty'); } $this->_attributes['update']['tempFilePath'] = '@updateTemp/' . $this->_attributes['target']['name'] . '_latest.zip'; $this->_attributes['update']['downloaded'] = $this->isDependencyAreFullyDownloaded($this->_attributes['update']); return true; } protected function isDependencyAreFullyDownloaded($dependency) { $destination = trim((string) Moto\Util::getValue($dependency, 'tempFilePath')); $absolutePath = Moto\System::getAbsolutePath($destination); if (!file_exists($absolutePath)) { return false; } return (filesize($absolutePath) === $dependency['file_size'] && md5_file($absolutePath) === $dependency['file_md5']); } protected function isDownloadedDependencyAreBad($dependency) { $destination = trim((string) Moto\Util::getValue($dependency, 'tempFilePath')); $absolutePath = Moto\System::getAbsolutePath($destination); if (!file_exists($absolutePath)) { return false; } $fileSize = filesize($absolutePath); if ($fileSize === $dependency['file_size']) { $fileMd5 = md5_file($absolutePath); if ($fileMd5 === $dependency['file_md5']) { return false; } Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : hash of downloaded dependency invalid', [ 'file_md5' => $fileMd5, 'dependency' => Moto\Util::arrayOnly($dependency, ['file_md5', '_uid', 'uid', 'id', 'path']), ]); return true; } elseif ($fileSize > $dependency['file_size']) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : downloaded dependency biggest that need', [ 'file_size' => $fileSize, 'dependency' => Moto\Util::arrayOnly($dependency, ['file_size', '_uid', 'uid', 'id', 'path']), ]); return true; } return false; } public function downloadDependencies($limits = []) { $destination = $this->_attributes['update']['tempFilePath']; $absolutePath = Moto\System::getAbsolutePath($destination); if (file_exists($absolutePath)) { if ($this->isDependencyAreFullyDownloaded($this->_attributes['update'])) { $this->_attributes['update']['downloaded'] = true; return true; } if ($this->isDownloadedDependencyAreBad($this->_attributes['update'])) { unlink($absolutePath); } } $url = $this->_attributes['update']['url']; $curlOptions = [ CURLOPT_FOLLOWLOCATION => false, CURLOPT_CONNECTTIMEOUT => 10, CURLOPT_TIMEOUT => 15, ]; if (Moto\System::isDevelopmentStage()) { $devOption = Moto\Config::get('dev_update_theme.curloptions'); if (is_array($devOption)) { $curlOptions = $devOption; } } $client = new Moto\Http\Client(null, [ 'streamtmpdir' => '@updateTemp', 'curloptions' => $curlOptions, ]); $client->setUri($url); try { $result = $client->downloadToFile($destination, [ 'partial' => true, ]); if ($result['error']) { throw new Moto\Exception('Error while download archive'); } if ($this->isDownloadedDependencyAreBad($this->_attributes['update'])) { throw new Moto\Exception('Error on verification downloaded archive'); } if ($this->isDependencyAreFullyDownloaded($this->_attributes['update'])) { $this->_attributes['update']['downloaded'] = true; } } catch (\Exception $e) { throw new Moto\System\Exception('Cant download theme archive', 500, [ [ 'name' => 'THEME_ARCHIVE_NOT_DOWNLOADED', 'params' => [ ], ] ]); } return true; } protected function extractDependency($dependency) { $destination = $dependency['tempFilePath']; $absolutePath = Moto\System::getAbsolutePath($destination); if (!file_exists($absolutePath)) { throw new Moto\Exception('Dependency archive not exists'); } $archive = new \ZipArchive(); if (!$archive->open($absolutePath)) { throw new Moto\Exception('Cant open archive'); } $tempDirPath = trim((string) Moto\Util::getValue($dependency, 'tempDirPath', '')); if ($tempDirPath === '') { $tempDirPath = $destination . '.tmp'; $dependency['tempDirPath'] = $tempDirPath; } $absoluteTempDirPath = Moto\System::getAbsolutePath($tempDirPath); if (file_exists($absoluteTempDirPath)) { Moto\Util::emptyDir($absoluteTempDirPath); } else { Moto\Util::createDir($absoluteTempDirPath); } try { $extractedStatus = $archive->extractTo($absoluteTempDirPath); $archive->close(); } catch (\Exception $e) { $extractedStatus = false; } if (!$extractedStatus) { throw new Moto\Exception('Error while extracting archive'); } return $dependency; } protected function applyDependencyContent($dependency) { $theme = $this->target; if (!is_array($theme)) { throw new Moto\Exception('Cant retrieve information about theme'); } $sourcePath = $dependency['tempDirPath'] . '/' . $theme['name']; $absoluteSourcePath = Moto\System::getAbsolutePath($sourcePath); if (empty($sourcePath) || empty($absoluteSourcePath) || !is_dir($absoluteSourcePath)) { throw new Moto\Exception('Source path not found'); } $destination = '@themes/' . $theme['name']; $absoluteDestinationPath = Moto\System::getAbsolutePath($destination); $files = Moto\Util::scanDir($absoluteSourcePath); $report = Moto\Util::checkCopyingFiles($files, $absoluteSourcePath, $absoluteDestinationPath); if ($report['error']) { throw new Moto\System\Exception('CANT_COPY_FILES', 500, [ [ 'name' => 'APPLY_CANT_COPY', 'params' => $report['errors'], ], ]); } $fileIndex = array_search('theme.json', $files, true); if ($fileIndex === false) { throw new Moto\Exception('Cant find "theme.json" on temp folder'); } $settingsFile = $files[$fileIndex]; unset($files[$fileIndex]); if (!Moto\Util::copyFiles($files, $absoluteSourcePath, $absoluteDestinationPath)) { throw new Moto\Exception('Error while coping files'); } if (!Moto\Util::copyFile($absoluteSourcePath . '/' . $settingsFile, $absoluteDestinationPath . '/' . $settingsFile)) { throw new Moto\Exception('Error while coping files'); } if ($theme['name'] === Moto\Website\Settings::get('theme')) { Moto\Features::disableByMask('theme'); Moto\Website\Theme::importFeatures($theme['name']); Moto\Website\Theme::importSpacings($theme['name'], 'update'); Moto\Website\Theme::importGridOptions($theme['name'], 'update'); Moto\Website\Theme::importHeadingSpacings($theme['name'], 'update'); Moto\Website\Theme::importPresetsEditKeys($theme['name']); Moto\Website\Theme::importPresets($theme['name'], 'update'); Moto\Website\Theme::importTextStyles($theme['name'], 'update'); if ((bool) Moto\Features::isEnabled('theme_customized_lists_styles')) { $options = [ 'properties' => [ 'desktop.base.^ul li&', 'desktop.base.^ol li&', 'tablet.base.^ul li&', 'tablet.base.^ol li&', 'mobile-h.base.^ul li&', 'mobile-h.base.^ol li&', 'mobile-v.base.^ul li&', 'mobile-v.base.^ol li&', ] ]; Moto\Website\Theme::updateTextStylesFromNormal($options); } Moto\Website\Theme::importContentSections($theme['name']); Moto\System\Style::rebuildAll(); } Moto\Util::emptyDir($absoluteSourcePath); return $dependency; } public function installDependencies($limits = []) { $dependency = $this->_attributes['update']; try { $dependency = $this->extractDependency($dependency); if (!$dependency) { throw new Moto\Exception('Failed on extractDependency'); } } catch (\Exception $e) { throw new Moto\System\Exception($e->getMessage(), $e->getCode(), [ [ 'name' => 'ARCHIVE_NOT_EXTRACTED', ] ]); } try { $dependency = $this->applyDependencyContent($dependency); if (!$dependency) { throw new Moto\Exception('Failed on applyDependencyContent'); } } catch (\Exception $e) { if ($e instanceof Moto\System\Exception) { throw $e; } throw new Moto\System\Exception($e->getMessage(), $e->getCode(), [ [ 'name' => 'APPLY_NOT_COPIED', ] ]); } $dependency['installed'] = true; $this->_attributes['update'] = $dependency; return true; } public function cleaningTemporary() { $tempFilePath = trim((string) Moto\Util::getValue($this->_attributes, 'update.tempFilePath')); if ($tempFilePath !== '') { $absoluteTempFilePath = Moto\System::getAbsolutePath($tempFilePath); if ($absoluteTempFilePath !== '' && file_exists($absoluteTempFilePath)) { @unlink($absoluteTempFilePath); } } $tempDirPath = trim((string) Moto\Util::getValue($this->_attributes, 'update.tempDirPath')); if ($tempDirPath !== '') { $absoluteTempDirPath = Moto\System::getAbsolutePath($tempDirPath); if ($absoluteTempDirPath !== '' && is_dir($absoluteTempDirPath)) { Moto\Util::deleteDir($absoluteTempDirPath); } } return true; } } 