<?php
 namespace Moto\System\Integration; use Illuminate\Support\Arr; use Illuminate\Support\Collection; use Moto; use InvalidArgumentException; abstract class AbstractManager { const SETTING_KEY = null; const NONE = 'none'; const VERSION_PROPERTY = '__version'; const DEFAULT_CONFIGURATION = []; protected $configuration = []; protected $providers = []; protected $app; abstract protected function isCompatibleProvider($provider); public function __construct($app) { $this->app = $app; $this->loadConfiguration(); } protected function loadConfiguration() { $configuration = $this->getRawSettings(); if (is_object($configuration)) { $configuration = json_encode($configuration); } if (is_string($configuration)) { $configuration = json_decode($configuration, true); } $this->configuration = $this->migrateConfiguration($configuration); } protected function migrateConfiguration($configuration) { if (array_key_exists(static::VERSION_PROPERTY, $configuration)) { return $configuration; } $configuration[static::VERSION_PROPERTY] = 1; $default = $this->getDefaultConfiguration(); $configuration['registered'] = $default['registered']; foreach ($configuration['providers'] as $index => $provider) { $configuration['providers'][$index] = array_merge([ static::VERSION_PROPERTY => 1, ], $provider); } if (!array_key_exists(static::NONE, $configuration['providers'])) { $configuration['providers'][static::NONE] = $default['providers'][static::NONE]; } return $configuration; } protected function getRawSettings() { if (!is_string(static::SETTING_KEY)) { throw new \RuntimeException('Setting key not string'); } $value = Moto\Website\Settings::get(static::SETTING_KEY); if (!$value) { $value = $this->getDefaultConfiguration(); } return $value; } public function syncConfiguration() { foreach ($this->providers as $provider) { $this->configuration['providers'][$provider->getName()] = $provider->getOptions(); } } public function deactivate() { $this->configuration['provider'] = static::NONE; return $this; } public function activate($provider) { if (!$this->isCompatibleProvider($provider)) { throw new InvalidArgumentException('Provider not compatible'); } $this->configuration['provider'] = $provider->getName(); return $this; } public function saveConfiguration() { $this->syncConfiguration(); return Moto\Website\Settings::set(static::SETTING_KEY, $this->configuration); } public function getDefaultConfiguration() { $settings = static::DEFAULT_CONFIGURATION; if (is_string($settings)) { $settings = json_decode($settings, true); } return $settings; } protected function getSetting($name, $default = null) { return Moto\Util::getValue($this->configuration, $name, $default); } public function exportEnvironment() { $environment = $this->configuration; $environment = Arr::only($environment, ['provider', 'options', 'providers']); $environment['available'] = []; $available = $this->getAvailableProviders(); foreach ($available as $provider) { $env = $provider->exportEnvironment(); if (!is_array($env)) { continue; } if (!array_key_exists('name', $env)) { $env['name'] = $provider->getName(); } $environment['available'][] = $env; } return $environment; } public function getAvailableProviders() { $collection = new Collection(); foreach ($this->getSetting('registered') as $name => $settings) { try { if (array_key_exists('plugin', $settings)) { if (!Moto\System\PluginManager::isActivated($settings['plugin'])) { continue; } } $provider = $this->getProvider($name); $collection->offsetSet($name, $provider); } catch (\Exception $e) { Moto\System\Log::error("Exception :  [{$e->getCode()}] {$e->getMessage()}"); } } return $collection; } public function isAvailableProvider($name) { $settings = $this->getSetting('registered.' . $name); if (!is_array($settings)) { return false; } if (array_key_exists('plugin', $settings)) { if (!Moto\System\PluginManager::isActivated($settings['plugin'])) { return false; } } try { $this->getProvider($name); return true; } catch (\Exception $e) { return false; } } public function registeredProvider($name) { if ($name === static::NONE) { return true; } return Arr::has($this->configuration, 'registered.' . $name); } public function getCurrentProvider() { $name = $this->getSetting('provider'); if (!$this->isAvailableProvider($name)) { $name = static::NONE; } return $this->getProvider($name); } protected function resolveProvider($name) { $class = trim((string) $this->getSetting('registered.' . $name . '.provider')); if ($class === '' || !class_exists($class)) { return false; } $options = (array) $this->getSetting('providers.' . $name); try { $provider = $this->app->make($class); } catch (\Exception $e) { Moto\System\Log::error('[' . __METHOD__ . '] : Exception [' . $e->getCode() . '] ' . $e->getMessage()); return false; } if (!$this->isCompatibleProvider($provider)) { Moto\System\Log::error('[' . __METHOD__ . '] : Provider "' . get_class($provider) . '" not compatible'); return false; } $provider->setOptions($options); return $provider; } public function getProvider($name) { if (!$this->registeredProvider($name)) { throw new \Exception('Unknown provider : ' . var_export($name, true)); } if (array_key_exists($name, $this->providers)) { return $this->providers[$name]; } $provider = $this->resolveProvider($name); if (!$provider) { throw new \Exception('Cant create provider : ' . var_export($name, true)); } $this->providers[$name] = $provider; return $provider; } public function getInputFilter($name) { if (is_array($name)) { $name = Moto\Util::getValue($name['provider']); } return $this->getProvider($name)->getInputFilter(); } public function register($provider, Moto\System\PluginConnector $plugin) { if (!$this->isCompatibleProvider($provider)) { throw new InvalidArgumentException('Provider not compatible'); } $name = $provider->getName(); if (!is_string($name)) { throw new InvalidArgumentException('Provider is invalid'); } $name = trim($name); if ($name === '') { throw new InvalidArgumentException('Provider has empty name'); } if ($this->registeredProvider($name)) { throw new InvalidArgumentException('Provider "' . $name . '" already registered'); } $properties = $provider->getDefaultProperties(); if (!is_array($properties)) { throw new InvalidArgumentException('Provider has wrong default properties type'); } $this->configuration['providers'][$name] = $properties; $this->configuration['registered'][$name] = [ 'name' => $provider->getName(), 'provider' => get_class($provider), 'plugin' => $plugin->getName(), ]; $this->providers[$name] = $provider; $this->saveConfiguration(); return $this; } protected function isNotSystem($name) { $plugin = Arr::get($this->configuration['registered'], $name . '.plugin'); return !empty($plugin); } public function unregisterByProvider($provider) { if (!$this->isCompatibleProvider($provider)) { throw new InvalidArgumentException('Provider not compatible'); } return $this->unregisterByName($provider->getName()); } public function unregisterByPlugin($plugin) { if ($plugin instanceof Moto\System\PluginConnector) { $plugin = $plugin->getName(); } foreach ($this->configuration['registered'] as $name => $info) { if (!array_key_exists('plugin', $info) || $info['plugin'] !== $plugin) { continue; } $this->unregisterByName($name); } return $this; } protected function unregisterByName($name) { if (!is_string($name)) { throw new InvalidArgumentException('Provider name is invalid'); } $name = trim($name); if ($name === '') { throw new InvalidArgumentException('Provider has empty name'); } if (!$this->registeredProvider($name)) { throw new InvalidArgumentException('Provider "' . $name . '" not registered'); } if (!$this->isNotSystem($name)) { throw new InvalidArgumentException('Provider "' . $name . '" is system'); } unset($this->configuration['providers'][$name]); unset($this->configuration['registered'][$name]); unset($this->providers[$name]); $this->saveConfiguration(); return $this; } } 