<?php
namespace Moto\System; use Moto; use Zend; use Zend\Log\Logger; use Zend\Log\Writer; class Log { protected static $_initialized = false; protected static $_logLevelName = 'info'; protected static $_options = [ 'application' => array( 'level' => 'info', ), 'php' => array( 'level' => E_ALL ^ E_NOTICE ^ E_WARNING ^ E_STRICT ^ E_DEPRECATED, ), ]; protected static $_levelsMap = array( 'debug' => Logger::DEBUG, 'info' => Logger::INFO, 'notice' => Logger::NOTICE, 'warning' => Logger::WARN, 'error' => Logger::ERR, 'critical' => Logger::CRIT, 'alert' => Logger::ALERT, 'emergency' => Logger::EMERG, ); protected static $_logger; protected static $_enabled = false; public static function init($options = null) { if (static::$_initialized) { return; } static::_setOptions($options); static::setErrorLevel(static::_getOption('application.level')); static::_initPhpLog(); static::_initApplicationLog(); static::$_initialized = true; } protected static function _setOptions($options) { if (is_array($options)) { static::$_options = Zend\Stdlib\ArrayUtils::merge(static::$_options, $options); } } protected static function _getOption($name, $default = null) { return Moto\Util::getValue(static::$_options, $name, $default); } public static function setErrorLevel($level) { if (static::$_initialized) { return false; } if (!is_string($level)) { return false; } $level = trim($level); $level = strtolower($level); if (!array_key_exists($level, static::$_levelsMap)) { return false; } static::$_logLevelName = $level; return true; } public static function getErrorLevel() { return static::$_logLevelName; } protected static function _getErrorLevelNumber() { return static::$_levelsMap[static::$_logLevelName]; } protected static function _initPhpLog() { error_reporting((int) static::_getOption('php.level', E_ALL ^ E_NOTICE ^ E_WARNING ^ E_STRICT ^ E_DEPRECATED)); @ini_set('display_errors', 'off'); @ini_set('log_errors', 'on'); $logFile = (string) Moto\System::getAbsolutePath('@phpErrorsLogFile'); $logFile = trim($logFile); if ($logFile === '') { return false; } $systemLogDir = dirname($logFile); if (!is_dir($systemLogDir)) { Moto\Util::createDir($systemLogDir); } if (!is_writable($systemLogDir)) { return false; } if (!file_exists($logFile)) { Moto\Util::filePutContents($logFile, ''); } if (!is_writable($logFile)) { return false; } @ini_set('error_log', $logFile); return true; } protected static function _initApplicationLog() { $logFile = (string) Moto\System::getAbsolutePath('@applicationLogFile'); $logFile = trim($logFile); if ($logFile === '') { return false; } $systemLogDir = dirname($logFile); if (!is_dir($systemLogDir)) { Moto\Util::createDir($systemLogDir); } if (!is_writable($systemLogDir)) { return false; } if (!file_exists($logFile)) { Moto\Util::filePutContents($logFile, ''); } if (!is_writable($logFile)) { return false; } static::$_logger = new Logger(); $writer = new Writer\Stream($logFile); $filter = new Zend\Log\Filter\Priority(static::_getErrorLevelNumber()); $writer->addFilter($filter); static::$_logger->addWriter($writer); Logger::registerErrorHandler(static::$_logger); static::$_enabled = true; return true; } public static function getLogger() { return static::$_logger; } public static function emergency($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->emerg($message, $extra); return true; } public static function alert($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->alert($message, $extra); return true; } public static function critical($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->crit($message, $extra); return true; } public static function error($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->err($message, $extra); return true; } public static function warning($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->warn($message, $extra); return true; } public static function notice($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->notice($message, $extra); return true; } public static function info($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->info($message, $extra); return true; } public static function debug($message, $extra = array()) { if (!static::$_enabled) { return false; } static::getLogger()->debug($message, $extra); return true; } public static function deprecatedMethod($method, $class = null, array $extra = []) { if (!static::$_enabled) { return false; } if (!(boolean) static::_getOption('application.deprecated')) { return false; } if (is_array($class)) { $extra = $class; $class = null; } $message = '[DEPRECATED] : Called '; if (is_string($class) && $class !== '') { $message .= ' class "' . $class . '"'; } $message .= ' method "' . $method . '"'; if (!empty($extra)) { $message .= ' with params =>'; } static::getLogger()->warn($message, $extra); return true; } } 