<?php
 namespace Moto\System\Marketplace\Product; use Moto; use Illuminate; use Exception; use Moto\Application\Pages\PageModel; class PageInstaller extends Moto\System\Marketplace\ProductInstaller { const PRODUCT_TYPE = 'page'; protected $dependencies; protected function getValidationErrors() { $errors = parent::getValidationErrors(); $meta = $this->getMetaFile(); $sourceDir = $meta->requireSourceDir(); $options = $meta->options; return $errors; } protected function getDependencies() { if (!$this->dependencies) { $this->dependencies = new Illuminate\Support\Collection(); $this->initDependencies($this->dependencies); } return $this->dependencies; } protected function requireMetaOption($name) { $options = $this->getMetaFile()->options; $value = Moto\Util::getValue($options, $name); if (empty($value)) { throw new \Exception('Oooops'); } return $value; } protected function initDependencies(Illuminate\Support\Collection $dependencies) { $file = $this->getAbsoluteSourcePath() . '/' . $this->requireMetaOption('dependencies.path'); $data = file_get_contents($file); $data = json_decode($data, true); if (!is_array($data)) { throw new \Exception(__CLASS__ . '::' . __FUNCTION__ . '::' . __LINE__); } if (Moto\Util::getValue($data, 'version') !== 1) { throw new \Exception(__CLASS__ . '::' . __FUNCTION__ . '::' . __LINE__); } $content = $data['content']; foreach ($content as $items) { $name = $items['name']; $table = $items['table']; $dependency = new Illuminate\Support\Collection($items['records']); if ($table === 'styles') { $dependency = $dependency->keyBy('class_name'); } $dependencies->put($name, $dependency); } if (!$dependencies->has('styles')) { $dependencies->put('styles', new Illuminate\Support\Collection()); } return $dependencies; } protected function getDependency($name) { $dependencies = $this->getDependencies(); if ($dependencies->has($name)) { return $dependencies->get($name); } return null; } public function getContentTemplate() { $source = $this->getAbsoluteSourcePath() . '/' . $this->requireMetaOption('sections.content.template.path'); if (file_exists($source)) { return file_get_contents($source); } return false; } protected function duplicateContent(array $options = []) { $content = $this->getContentTemplate(); $containers = Moto\Application\Content\Util::findContainers($content); if (!empty($containers)) { $containersStyles = $this->getDependency('styles@containers'); $styles = $this->getDependency('styles'); if (!$containersStyles) { throw new \Exception(__CLASS__ . '::' . __FUNCTION__ . '::' . __LINE__); } foreach ($containers as $containerClassName) { $newClassName = 'moto-container_content_' . Moto\Util::getUniqueId(); $content = str_replace($containerClassName, $newClassName, $content); $style = $containersStyles->pull($containerClassName); if (!$style) { throw new \Exception(__CLASS__ . '::' . __FUNCTION__ . '::' . __LINE__); } $style['name'] = $newClassName; $style['class_name'] = $newClassName; $styles->put($newClassName, $style); } } return $content; } protected function duplicatePage() { $properties = $this->requireMetaOption('properties'); $properties['parent_id'] = 0; $query = Moto\Database\Page::query(); $query->where('parent_id', '=', $properties['parent_id']); $filter = new Moto\Filter\UniqueDatabaseValue([ 'query' => $query, 'column' => 'url', 'startIndex' => 2, ]); $properties['url'] = $filter->filter($properties['url']); $lastIndex = (int) $filter->getLastIndex(); if ($lastIndex > 0) { $properties['name'] .= ' ' . $lastIndex; $properties['title'] .= ' ' . $lastIndex; } $content = $this->duplicateContent(); $page = new PageModel(); $page->setFromArray($properties); $page->content = $content; return $page; } protected function importDependencies($return = false) { $imported = new Illuminate\Support\Collection(); $styles = $this->getDependency('styles'); foreach ($styles as $attributes) { $style = new Moto\Database\Models\Style($attributes); foreach ($attributes as $attribute => $value) { $style->setAttribute($attribute, $value); } $style->save(); $imported->push($style); } return $imported; } protected function runInstall() { $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); $page = null; $imported = null; try { $page = $this->duplicatePage(); $page->save(); $this->importDependencies(); } catch (\Exception $e) { $connection->rollBack(); throw $e; } $connection->commit(); return [ 'uid' => $this->uid, 'id' => (int) $page->id, 'name' => $page->name, 'url' => $page->url, 'type' => $page->type, ]; } } 