<?php
 namespace Moto\System\Marketplace\Product; use Moto; use Carbon\Carbon; use Exception; class PluginInstaller extends Moto\System\Marketplace\ProductInstaller { const PRODUCT_TYPE = 'plugin'; protected function createMetaFileIfNeed() { $sourcePath = $this->getAbsoluteSourcePath(); $metaFilePath = $sourcePath . '/' . Moto\System\Marketplace\MetaFile::META_FILE_NAME; if (file_exists($metaFilePath)) { return true; } $meta = Moto\System\PluginManager::getMetaInformation($sourcePath); if (!$meta) { return false; } $data = [ 'uid' => $this->uid, 'type' => $this->getProductType(), 'options' => $meta, ]; Moto\Util::filePutContents($metaFilePath, json_encode($data, JSON_PRETTY_PRINT)); return true; } protected function extractArchive() { $result = parent::extractArchive(); $this->createMetaFileIfNeed(); return $result; } protected function getValidationErrors() { $errors = []; $sourcePath = $this->getAbsoluteSourcePath(); $meta = Moto\System\PluginManager::getMetaInformation($sourcePath); if (!$meta) { $errors[] = 'INVALID_PLUGIN_META_DATA'; } return $errors; } protected function isNeedConfirmation() { return (boolean) Moto\System\PluginManager::findLocalPluginByName($this->getMetaFile()->options->name); } protected function runInstall() { $sourcePath = $this->getAbsoluteSourcePath(); $destinationPath = Moto\System\PluginManager::getPluginPathByName($this->getMetaFile()->options->name); $absoluteDestinationPath = Moto\System::getAbsolutePath($destinationPath); Moto\Util::copyDir($sourcePath, $absoluteDestinationPath); unlink($absoluteDestinationPath . '/' . Moto\System\Marketplace\MetaFile::META_FILE_NAME); $plugin = Moto\System\PluginManager::findLocalPluginByName($this->getMetaFile()->options->name); return $plugin->toArray(); } } 