<?php
 namespace Moto\System; use Illuminate\Support\Str; use Moto; use Composer; class MarketplaceManager { use Moto\System\Traits\OptionsTrait; protected $_options = [ ]; protected $classMap = [ '_default_' => [ 'MetaFile' => Moto\System\Marketplace\MetaFile::class, 'MetaFileOptions' => Moto\System\Marketplace\MetaFileOptions::class, ], 'Block' => [ 'Installer' => Moto\System\Marketplace\Product\BlockInstaller::class, ], 'Page' => [ 'Installer' => Moto\System\Marketplace\Product\PageInstaller::class, ], 'Plugin' => [ 'Installer' => Moto\System\Marketplace\Product\PluginInstaller::class, ], ]; public function createProductInstaller($type) { $class = $this->resolveClass($type, 'Installer'); if (!class_exists($class)) { Moto\System\Log::critical('Required class "' . $class . '" not exists, type is : ' . var_export($type, true)); throw new \RuntimeException('Installer for type ' . var_export($type, true) . ' not exists'); } $installer = new $class(); $installer->setAttribute('type', $type); $installer->setManager($this); return $installer; } public function resolveClass($type, $target, $debug = false) { if (is_object($type) && method_exists('getProductType', $type)) { $type = $type->getProductType(); } if (!is_string($target) || !is_string($type)) { return false; } $type = strtolower($type); $type = Str::studly($type); $class = Moto\Util::getValue($this->classMap, $type . '.' . $target); if (!$class) { $class = Moto\Util::getValue($this->classMap, '_default_' . '.' . $target); } if ($debug) { echo '$target : ' . var_export($target, true) . ' $type : ' . var_export($type, true) . ' $class : ' . var_export($class, true) . "\n"; } return $class; } } 