<?php
namespace Moto\System; use Moto; abstract class PluginConnector { CONST PLUGIN_NAME = null; protected $_backupProvider; protected $_autoloadExtended; final public function __construct() { } abstract public function compatibleApiVersions(); public function getDetails() { $plugin = PluginManager::findLocalPluginByName($this->getName()); if ($plugin) { return $plugin->toArray(); } return null; } final public function getName() { return (string) static::PLUGIN_NAME; } public function getRequirementsErrors() { return null; } public function hasVendors() { return false; } public function extendAutoload() { if (!$this->hasVendors()) { return true; } if ($this->_autoloadExtended) { return true; } $vendorsPath = $this->getVendorsAbsolutePath(); if (!is_dir($vendorsPath)) { throw new Moto\Exception('Plugin "vendors" folder not exists', 500, [ 'plugin' => $this->getName(), 'vendorsPath' => Moto\Util::getRelativePath($vendorsPath, Moto\System::getAbsolutePath('@website')), ]); } Moto\System\AutoloadManager::getInstance()->extendAutoload($vendorsPath); $this->_autoloadExtended = true; return true; } public function getVendorsAbsolutePath() { return $this->getAbsolutePath() . '/vendor'; } public function bootstrap() { } public function getNamespace() { return ''; } final public function getFolder() { return Moto\System\PluginManager::getPluginFolderByName($this->getName()); } final public function getPath() { return Moto\System\PluginManager::getPluginPathByName($this->getName()); } final public function getAbsolutePath() { return Moto\System::getAbsolutePath($this->getPath()); } final public function getRelativePath() { return Moto\System::getRelativePath($this->getPath()); } final public function getAbsoluteUrl() { return Moto\System::getAbsoluteUrl($this->getPath()); } final public function getRelativeUrl() { return Moto\System::getRelativeUrl($this->getPath()); } public function getNgModuleNames() { return array( 'backend' => str_replace('/', '.', $this->getName()) . '.backend', 'frontend' => str_replace('/', '.', $this->getName()) . '.frontend', ); } public function getWidgets() { return []; } public function getAssets() { return []; } public function install() { } public function isInstalled() { return Moto\System\PluginManager::isInstalled($this->getName()); } public function activate() { } public function isActivated() { return Moto\System\PluginManager::isActivated($this->getName()); } public function getBackupProvider() { if (!$this->_backupProvider) { return null; } if (is_object($this->_backupProvider)) { return $this->_backupProvider; } $class = null; $parameters = []; if (is_string($this->_backupProvider)) { $class = $this->_backupProvider; } if (is_array($this->_backupProvider)) { $class = Moto\Util::getValue($this->_backupProvider, 'class'); $parameters = (array) Moto\Util::getValue($this->_backupProvider, 'parameters'); } if (!class_exists($class)) { Moto\System\Log::alert('Plugin "' . $this->getName() . '" require not existed class "' . $class . '"'); if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException('Plugin "' . $this->getName() . '" require not existed class "' . $class . '"'); } $this->_backupProvider = null; return null; } $this->_backupProvider = Moto\System::app($class, $parameters); return $this->_backupProvider; } public function deactivate() { } public function uninstall() { } public function getUpdateSteps() { return null; } final public function processAction($name, $params = null) { $method = 'on' . Moto\Util::toStudlyCase(Moto\Util::toSnakeCase($name)) . 'Action'; if (method_exists($this, $method)) { return $this->{$method}($params); } return null; } public function updateDatabase($params) { return true; } final public function fireEvent($name, $params = null, $silent = false) { $method = 'on' . Moto\Util::toStudlyCase(Moto\Util::toSnakeCase($name)); if (method_exists($this, $method)) { try { return $this->{$method}($params); } catch (\Exception $e) { if (!$silent) { throw $e; } } } } } 