<?php
 namespace Moto\System; use Moto; class PluginManager { const API_VERSION = 1; const PRIORITY_DEFAULT = 50; protected static $_websitePluginsDir = '@plugins'; protected static $_pluginMetaFile = 'plugin.meta.php'; protected static $_maxHeaderSize = 10240; protected static $_nameDelimiter = '@'; protected static $_initialized = false; protected static $_connectors = array(); protected static $_booted = false; protected static $_bootedPlugins = array(); protected static $_installedPlugins = array(); protected static $_pluginsLoaded = false; public static function init($bootPlugins = false) { if (static::$_initialized) { return; } static::$_initialized = true; static::loadData(true); if (Moto\System::isUpdateEngine()) { return; } if (Moto\System::isInstallEngine()) { return; } if ($bootPlugins) { static::bootAllPlugins(); } } public static function loadData($reload = false) { if (!Moto\System::isInstalled()) { return false; } if ($reload || count(static::$_installedPlugins) === 0) { Moto\Website\Settings::init(); $installedPlugins = Moto\Website\Settings::get('installed_plugins'); if (is_array($installedPlugins)) { static::$_installedPlugins = static::_sanitizeInstalledList($installedPlugins); } static::$_pluginsLoaded = true; } return true; } public static function isSupports($name) { return false; } protected static function _sanitizeInstalledList($list) { if (is_string($list)) { $list = json_decode($list, true); } if (!is_array($list)) { return array(); } $result = array(); foreach ($list as $name => $item) { if (!is_array($item)) { continue; } if (!array_key_exists('name', $item)) { continue; } if (!array_key_exists('connector_class', $item)) { continue; } if (!array_key_exists('priority', $item)) { $item['priority'] = static::PRIORITY_DEFAULT; } $result[$item['name']] = $item; } return $result; } public static function saveInstalledList() { if (!static::$_pluginsLoaded) { static::loadData(true); } $list = array_values(static::$_installedPlugins); usort($list, function ($a, $b) { if ($a['priority'] === $b['priority']) { return 0; } return ($a['priority'] < $b['priority']) ? -1 : 1; }); return Moto\Website\Settings::add('installed_plugins', $list, 'array'); } public static function isFolderContainPlugin($folder) { return file_exists(Moto\System::getAbsolutePath($folder) . '/' . static::$_pluginMetaFile); } public static function getUpdateList() { $plugins = static::findLocalPlugins(); if (!$plugins) { return array(); } return $plugins->toArray(array('name', 'version', 'build')); } protected static function _isValidMetaItem($name, $value) { if (!is_string($name)) { return false; } switch ($name) { case 'name': $isValid = preg_match('/^[a-z0-9\-\_\\' . static::$_nameDelimiter . ']{3,}$/', $value); break; case 'version': $isValid = preg_match('/^\d[\d\.a-z]*$/i', $value); break; case 'build': $isValid = preg_match('/^[\d]{1,8}$/', $value); break; case 'injector': case 'connector_file': $isValid = preg_match('/^[a-z][a-z0-9\/]{1,128}\.php$/i', $value); break; case 'connector_class': $isValid = preg_match('/^[a-z][a-z0-9\\\]{3,128}$/i', $value); break; default: $isValid = !preg_match('/[<>]/', $value); break; } return (boolean) $isValid; } protected static function _sanitizeMetaItemValue($name, $value) { switch ($name) { case 'build': $value = (int) $value; break; } return $value; } public static function getMetaInformation($absolutePath) { if (!is_string($absolutePath)) { return false; } if (is_dir($absolutePath)) { $absolutePath .= '/' . static::$_pluginMetaFile; } elseif (basename($absolutePath) !== static::$_pluginMetaFile) { return false; } if (!file_exists($absolutePath)) { return false; } $fileSize = filesize($absolutePath); $fileHandle = fopen($absolutePath, 'r'); $content = fread($fileHandle, min($fileSize, static::$_maxHeaderSize)); fclose($fileHandle); $content = str_replace("\r", "\n", $content); $content = explode("\n", $content); $header = false; $meta = array(); foreach ($content as $line) { $line = trim($line); if ($line === '') { continue; } if (strpos($line, '/*') === 0) { $header = true; continue; } if (strpos($line, '*/') === 0) { break; } if (!$header) { continue; } if (preg_match('/^[\s*@]*([a-z\s]{3,})\s*:(.*)$/i', $line, $match)) { $key = $match[1]; $key = trim($key); $key = strtolower($key); $key = preg_replace('/[\s]+/', '_', $key); $value = trim($match[2]); if (static::_isValidMetaItem($key, $value) && !array_key_exists($key, $meta)) { $meta[$key] = static::_sanitizeMetaItemValue($key, $value); } } } return $meta; } protected static function _isValidMeta($meta, $folder) { if (!is_array($meta)) { return false; } if (empty($meta['name'])) { return false; } if (empty($meta['version'])) { return false; } if (empty($meta['build'])) { return false; } if (empty($meta['injector'])) { return false; } if (empty($meta['connector_class'])) { return false; } $nameToFolder = str_replace(static::$_nameDelimiter, '/', $meta['name']); if ($folder !== $nameToFolder) { return false; } return true; } protected static function _getPluginInformationFromFile($folder) { $path = static::$_websitePluginsDir . '/' . $folder; $absolutePath = Moto\System::getAbsolutePath($path); if (is_dir($absolutePath)) { $absolutePath .= '/' . static::$_pluginMetaFile; } else { if (basename($absolutePath) !== static::$_pluginMetaFile) { return false; } } if (!file_exists($absolutePath)) { return false; } $result = array(); $meta = static::getMetaInformation($absolutePath); if (!static::_isValidMeta($meta, $folder)) { return false; } $result['folder'] = $path; $result['meta'] = $meta; return new Moto\System\Plugins\PluginItem($result); } public static function findLocalPlugins($filter = null) { $pluginsDir = Moto\System::getAbsolutePath(static::$_websitePluginsDir); $plugins = array(); if (!is_callable($filter)) { $filter = function () { return true; }; } $options = array( 'addDir' => true, 'maxLevel' => 1, 'compareFunction' => function ($dir = '', $item = '', $root = '', $type = '') { if ((string) $type !== 'dir') { return false; } return PluginManager::isFolderContainPlugin($root . '/' . $dir . '/' . $item); }, 'skipThisPathFunction' => function ($root = null, $dir = null) { return file_exists($root . '/' . $dir . '/' . static::$_pluginMetaFile); }, ); $list = Moto\Util::scanDir($pluginsDir, '', $options); foreach ($list as $item) { $plugin = static::_getPluginInformationFromFile($item); if (!$plugin) { continue; } if (!$filter('plugin', $plugin)) { continue; } $plugins[] = $plugin; } $plugins = new Moto\System\Plugins\PluginCollection($plugins); return $plugins; } public static function findLocalPluginByName($name) { if (static::_isValidMetaItem($name, 'name')) { return static::_getPluginInformationFromFile(static::getPluginFolderByName($name)); } return null; } public static function isActivated($name) { return Moto\Util::getValue(static::$_installedPlugins, $name . '.activated', false); } public static function isInstalled($name) { return array_key_exists($name, static::$_installedPlugins); } protected static function _isAllow($action, $plugin) { if (Moto\System::isInstallEngine()) { return true; } return (boolean) (Moto\System::getUser()); } protected static function _isDeniedThrowError($action, $plugin) { if (!static::_isAllow($action, $plugin)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array( 'name' => $plugin, 'action' => 'plugin:' . $action, )); } } public static function activate($name) { $name = (string) $name; $name = trim($name); static::_isDeniedThrowError('activate', $name); if (!static::isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $plugin = Moto\System\PluginManager::findLocalPluginByName($name); if (!$plugin) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } if (static::isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ALREADY_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $connector = static::_createConnector($name, $plugin); if (!$connector || $connector->getName() !== $name) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $apiVersion = $connector->compatibleApiVersions(); if (!is_array($apiVersion) || !in_array(static::API_VERSION, $apiVersion)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_COMPATIBLE', Moto\System\Exception::ERROR_CONFLICT_MESSAGE, array( 'name' => $name, 'pluginApiVersion' => $apiVersion, 'currentApiVersion' => static::API_VERSION, )); } $errors = null; try { $errors = $connector->getRequirementsErrors(); } catch (\Exception $e) { if (method_exists($e, 'getErrors')) { $errors = $e->getErrors(); } else { $errors = array( 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) ); } } if ($errors !== null) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_FAILED_DEPENDENCY', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $errors); } try { $connector->extendAutoload(); $connector->activate(); } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant activated because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); $errors = []; if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } $errors['exception'] = [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ]; throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ACTIVATION_FAILED', Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } static::$_installedPlugins[$name]['activated'] = true; static::saveInstalledList(); return true; } public static function install($name) { if (!static::$_pluginsLoaded) { static::loadData(true); } $name = (string) $name; $name = trim($name); $plugin = Moto\System\PluginManager::findLocalPluginByName($name); if (!$plugin) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } static::_isDeniedThrowError('install', $name); if (static::isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ALREADY_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $record = array( 'name' => $plugin->getName(), 'version' => $plugin->getVersion(), 'build' => $plugin->getBuild(), 'priority' => $plugin->metaGet('priority', static::PRIORITY_DEFAULT), 'activated' => false, 'connector_class' => $plugin->metaGet('connector_class'), 'created_at' => time(), ); if ($plugin->metaHas('connector_file')) { $record['connector_file'] = $plugin->metaGet('connector_file'); } $connector = static::_createConnector($name, $plugin); if (!$connector || $connector->getName() !== $name) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $apiVersion = $connector->compatibleApiVersions(); if (!is_array($apiVersion) || !in_array(static::API_VERSION, $apiVersion)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_COMPATIBLE', Moto\System\Exception::ERROR_CONFLICT_MESSAGE, array( 'name' => $name, 'pluginApiVersion' => $apiVersion, 'currentApiVersion' => static::API_VERSION, )); } $errors = null; try { $errors = $connector->getRequirementsErrors(); } catch (\Exception $e) { if (method_exists($e, 'getErrors')) { $errors = $e->getErrors(); } else { $errors = array( 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) ); } } if ($errors !== null) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_FAILED_DEPENDENCY', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $errors); } try { $connector->extendAutoload(); $connector->install(); } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant installed because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); $errors = []; if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } $errors['exception'] = [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ]; throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_INSTALLATION_FAILED', Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } static::$_installedPlugins[$name] = $record; static::saveInstalledList(); return true; } public static function deactivate($name) { static::_isDeniedThrowError('deactivate', $name); if (!static::isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE); } $plugin = Moto\System\PluginManager::findLocalPluginByName($name); if ($plugin) { $pluginInjector = $plugin->getPath() . '/' . $plugin->metaGet('injector'); Moto\System::removeInjector($pluginInjector); } static::$_installedPlugins[$name]['activated'] = false; static::saveInstalledList(); try { $connector = static::getConnector($name); if ($connector) { $connector->deactivate(); } } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] throw exception on deactivating [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } } return true; } public static function uninstall($name) { static::_isDeniedThrowError('uninstall', $name); if (!static::isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE); } if (static::isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_IS_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE); } $plugin = Moto\System\PluginManager::findLocalPluginByName($name); if ($plugin) { $pluginInjector = $plugin->getPath() . '/' . $plugin->metaGet('injector'); Moto\System::removeInjector($pluginInjector); } try { $connector = static::getConnector($name); if (array_key_exists($name, static::$_installedPlugins)) { unset(static::$_installedPlugins[$name]); } static::saveInstalledList(); if ($connector) { $connector->extendAutoload(); $connector->uninstall(); } } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] throw exception on uninstalling [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } } return true; } public static function getPluginFolderByName($name) { $name = (string) $name; $name = str_replace(array('.', '@'), '/', $name); return $name; } public static function getPluginPathByName($name) { return static::$_websitePluginsDir . '/' . static::getPluginFolderByName($name); } protected static function _createConnector($name, $meta) { $name = (string) $name; $name = trim($name); if ($name === '') { return null; } if ($meta instanceof Moto\System\Plugins\PluginItem) { $meta = $meta->toArray(); } $class = Moto\Util::getValue($meta, 'connector_class'); if (empty($class)) { return null; } if (!class_exists($class, false)) { $file = Moto\Util::getValue($meta, 'connector_file'); if (!empty($file)) { $filePath = static::getPluginPathByName($name) . '/' . $file; $absoluteFilePath = Moto\System::getAbsolutePath($filePath); if (file_exists($absoluteFilePath)) { include_once $absoluteFilePath; } else { return null; } } } if (!class_exists($class)) { return null; } try { $connector = new $class(); if ($connector instanceof Moto\System\PluginConnector) { return $connector; } } catch (\Exception $e) { Moto\System\Log::error('Exception on creating plugin connector : ' . $e->getMessage(), array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return null; } public static function getConnector($name) { $name = (string) $name; $name = trim($name); if ($name === '') { return null; } if (array_key_exists($name, static::$_connectors)) { return static::$_connectors[$name]; } if (!static::isInstalled($name)) { return null; } $plugin = static::findLocalPluginByName($name); if (!$plugin) { return null; } $connector = static::_createConnector($name, $plugin); static::$_connectors[$name] = $connector; return $connector; } public static function isBooted() { return static::$_booted; } public static function isBootedPlugin($name) { return array_key_exists($name, static::$_bootedPlugins); } public static function bootAllPlugins() { if (static::isBooted()) { return false; } foreach (static::$_installedPlugins as $item) { if ($item['activated']) { static::bootPlugin($item['name']); } } static::$_booted = true; } public static function bootPlugin($name) { if (static::isBootedPlugin($name)) { return false; } $connector = static::getConnector($name); if (!$connector) { return false; } try { $connector->extendAutoload(); $connector->bootstrap(); } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant bootstrap because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } return false; } return true; } public static function getUpdateSteps($name) { if (Moto\System\PluginManager::isInstalled($name)) { $connector = Moto\System\PluginManager::getConnector($name); if (!$connector) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $activated = Moto\System\PluginManager::isActivated($name); $steps = array( 'downloadArchive', 'extractArchive', 'checkFiles', ); if ($activated) { $steps[] = 'enableMaintenance'; } $steps = array_merge($steps, array( 'updateFiles', 'clearSystemCache', 'updateDatabase', )); if ($activated) { $steps = array_merge($steps, array( 'cleanCache', 'optimizeStyles', 'rebuildStyles', 'disableMaintenance', )); } $steps = array_merge($steps, array( 'finishUpdate', )); } else { $steps = array( 'downloadArchive', 'extractArchive', 'checkFiles', 'updateFiles', 'finishUpdate', ); } return $steps; } } 