<?php
namespace Moto\System; use Moto; class ProductInformation { const DELIMITER = '@'; const ERROR_REQUEST_SIGN_IS_EMPTY = 'ERROR_REQUEST_SIGN_IS_EMPTY'; const ERROR_CANT_ENCRYPT_MESSAGE = 'ERROR_CANT_ENCRYPT_MESSAGE'; protected static $_filePath = '@productInformationFile'; protected static $_data = null; protected static $_initialized = false; public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::loadData(); } public static function validate($data) { if (!is_array($data)) { return false; } $value = (string) Moto\Util::getValue($data, 'product_id'); if (!preg_match('/^[a-z0-9]{32,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'request_sign'); if (!preg_match('/^[a-z0-9\/\+\=\:]{8,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'token'); if (!preg_match('/^[a-z0-9\/\+\=\:\@\.]{48,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'template'); if (!preg_match('/^[0-9]{5,}$/', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'synced_at'); if (!preg_match('/^[0-9]{5,}$/', $value)) { return false; } return true; } public static function update($information) { if (!static::validate($information)) { return false; } static::$_data = $information; static::_updateDatabase(); static::_updateFile(); return true; } protected static function _updateDatabase() { if (!Moto\System::isDatabaseConnected()) { return false; } try { if (Moto\System\Settings::isExists('product_information')) { Moto\System\Settings::set('product_information', static::$_data); } else { Moto\System\Settings::add('product_information', static::$_data, 'array'); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::warning('Can not update "product_information" file', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return false; } return true; } protected static function _updateFile() { try { $filePath = Moto\System::getAbsolutePath(static::$_filePath); if (empty($filePath)) { throw new \Exception(static::$_filePath . ':FilePathNotFound'); } $content = '<?php return ' . var_export(static::$_data, true) . ';'; Moto\Util::filePutContents($filePath, $content); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::warning('Cant update "product_information" file', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return false; } return true; } public static function getProductId() { return Moto\Util::getValue(static::$_data, 'product_id', ''); } public static function getToken() { return static::getProductId() . static::DELIMITER . Moto\Util::getValue(static::$_data, 'token', ''); } public static function get($name = null, $default = null) { if ($name === null) { return static::$_data; } return Moto\Util::getValue(static::$_data, $name, $default); } public static function isExists($name) { return (Moto\Util::getValue(static::$_data, $name, null) !== null); } public static function isReady() { return is_array(static::$_data) && !empty(static::$_data['product_id']) && !empty(static::$_data['request_sign']); } public static function loadData() { if (static::$_data) { return true; } $data = Moto\System\Settings::get('product_information'); if (is_array($data)) { static::$_data = $data; return true; } $data = static::getFromFile(); if (!static::validate($data)) { return false; } static::$_data = $data; static::_updateDatabase(); return true; } public static function getFromFile() { $filePath = Moto\System::getAbsolutePath(static::$_filePath); if (!file_exists($filePath)) { return null; } $lvl = error_reporting(); $data = null; try { $data = include $filePath; } catch (\Exception $e) { } error_reporting($lvl); if (!static::validate($data)) { return null; } return $data; } public static function encryptMessage($rawMessage, $method = Moto\System\Encryption::METHOD_JSON) { if ($method === null) { $method = Moto\System\Encryption::METHOD_JSON; } $sign = Moto\System\ProductInformation::get('request_sign'); if (empty($sign)) { throw new Moto\System\Exception(static::ERROR_REQUEST_SIGN_IS_EMPTY); } $message = Moto\System\Encryption::encrypt($rawMessage, $method, $sign); if (empty($message)) { throw new Moto\System\Exception(static::ERROR_CANT_ENCRYPT_MESSAGE); } return $message; } } 