<?php
 namespace Moto\System; use Moto; class Style { protected static $_options = array( 'fontsPartLength' => 5, 'deferredRebuildEnabled' => true, ); public static function setOption($name, $value) { if (!is_string($name)) { return false; } $name = trim($name); if ($name === '') { return false; } static::$_options[$name] = $value; return true; } public static function getOption($name, $default = null) { if (array_key_exists($name, static::$_options)) { return static::$_options[$name]; } return $default; } public static function rebuildAll($event = false) { if ($event instanceof \Zend\EventManager\Event) { $useDeferred = ($event->getName() !== Moto\Hook::SYSTEM_SHUTDOWN); } else { $useDeferred = ($event !== true); } if ($useDeferred && !static::getOption('deferredRebuildEnabled')) { return; } if ($useDeferred) { Moto\Hook::once(Moto\Hook::SYSTEM_SHUTDOWN, 'Moto\System\Style::rebuildAll'); return; } Moto\System\Style::buildLessVariables(); Moto\System\Style::buildFonts(); Moto\System\Style::buildColorTheme(); Moto\System\Style::buildStyles(); Moto\System\Style::buildPresets(); Moto\System\Style::buildExtraSpacings(); Moto\System\Style::buildLess($event); } public static function buildFonts() { $query = Moto\Database\Models\Font::query(); $query->where('active', true); $fonts = $query->orderBy('name')->get(); $import = array( 'google' => array( 'family' => array(), 'subsets' => array(), 'one' => array(), ) ); if ($fonts->count() < 1) { Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userFontsFile'), ''); return true; } $custom = ''; foreach ($fonts as $font) { if ($font->provider === 'google') { $family = str_replace(' ', '+', $font->name); if (is_array($font->active_variants) && count($font->active_variants) > 0) { $family .= ':' . implode(',', $font->active_variants); } $import[$font->provider]['family'][] = $family; if (is_array($font->active_subsets) && count($font->active_subsets) > 0) { $import[$font->provider]['subsets'] = array_merge($import[$font->provider]['subsets'], $font->active_subsets); } continue; } if ($font->provider === 'custom') { $css = $font->generateCssContent(); if (is_string($css) && $css !== '') { $custom .= $css . "\n"; } } } $css = "\n"; if (!empty($import['google']['family'])) { $parts = array_chunk($import['google']['family'], static::$_options['fontsPartLength']); foreach ($parts as $part) { $css .= '@import url(//fonts.googleapis.com/css?family=' . implode('|', $part); if (!empty($import['google']['subsets'])) { $import['google']['subsets'] = array_unique($import['google']['subsets']); $css .= '&subset=' . implode(',', $import['google']['subsets']); } $css .= ");\n"; } } $css .= $custom; Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userFontsFile'), $css); return true; } public static function buildLessVariables($event = null) { $content = ''; if (Moto\Version::getCurrentBuild() > 26) { $content .= "@websiteAddress: '" . rtrim(Moto\System::getRelativeUrl(), '/') . "';\n"; $content .= "@websiteMediaUrl: '" . Moto\System::getRelativeUrl('@userUploads') . "';\n"; $content .= "@currentThemeDir: '" . Moto\System::getRelativePath('@currentTheme') . "';\n"; $content .= "@currentThemeUrl: '" . Moto\System::getRelativeUrl('@currentTheme') . "';\n"; } else { $websiteAddress = rtrim(Moto\Website\Settings::get('address'), '/'); $content .= "@websiteAddress: '$websiteAddress';\n"; $content .= "@websiteMediaUrl: '" . Moto\System::getAbsoluteUrl('@userUploads') . "';\n"; $currentTheme = Moto\System::getRelativePath('@currentTheme'); $content .= "@currentThemeDir: '" . $currentTheme . "';\n"; $content .= "@currentThemeUrl: '" . $websiteAddress . '/' . $currentTheme . "';\n"; } $features = Moto\Features::getList(); if (is_array($features)) { $content .= "\n"; foreach ($features as $name => $value) { if (!preg_match('/^theme_/', $name)) { continue; } $value = (int) $value; $content .= "@feature_{$name}: {$value};\n"; } } if (Moto\Features::isEnabled('theme_spacings')) { $spacings = Moto\Website\Settings::get('spacings'); if (is_string($spacings)) { $spacings = json_decode($spacings, true); } if (is_array($spacings)) { $content .= "\n"; $devicesWithExtraSpacings = []; foreach ($spacings as $device => $sizes) { if (!is_array($sizes)) { continue; } $extraSpacings = []; foreach ($sizes as $size => $value) { if (is_array($value)) { if (empty($value['value'])) { continue; } $extraSpacings[] = $size; $value = $value['value']; } elseif (empty($value)) { $value .= '\'\''; } else { $value = (string) $value; $value = str_replace('px', '', $value); $value .= 'px'; } $content .= "@spacing_{$device}_{$size}: {$value};\n"; } if (count($extraSpacings) > 0) { $content .= "@extra_spacings_{$device}: " . implode(', ', $extraSpacings) . ";\n"; $devicesWithExtraSpacings[] = $device; } } if (count($devicesWithExtraSpacings) > 0) { $content .= "@devices_with_extra_spacings: " . implode(', ', $devicesWithExtraSpacings) . ";\n"; } } } $grid = Moto\Website\Settings::get('theme_grid'); if (is_array($grid)) { $content .= "\n"; foreach ($grid as $name => $value) { $content .= "@grid-{$name}: {$value};\n"; } } $headings = Moto\Website\Settings::get('theme_headings'); if (is_object($headings)) { $content .= "\n"; foreach ($headings as $name => $value) { $content .= "@spacing_{$name}: {$value};\n"; } } Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/variables/website.less'), $content); } public static function buildColorTheme($event = null) { $colors = Moto\Website\Settings::get('colors'); if (is_string($colors)) { $colors = json_decode($colors, true); } $twig = Moto\Render::getInstance('less'); $content = $twig->render('@lessTemplates/variables/colorizer.less.twig', array( 'colors' => $colors )); Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/variables/colorizer.less'), $content); } public static function buildStyles($event = null) { $twig = Moto\Render::getInstance('less'); $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(true); $items = $table->getList(); $content = $twig->render('@lessTemplates/styler.less.twig', array( 'items' => $items['records'] )); Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/styler.less'), $content); } public static function buildPresets($event = null) { $content = ''; if (!Moto\Features::isEnabled('theme_presets')) { Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/presets.less'), $content); return; } $twig = Moto\Render::getInstance('less'); $twig->addGlobal('FEATURES', Moto\Features::getList()); $items = Moto\Database\Models\Preset::query()->get(); if ($items->count()) { $content = $twig->render('@lessTemplates/presets.less.twig', array( 'items' => $items )); } Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/presets.less'), $content); } public static function buildExtraSpacings($event = null) { $content = ''; if (!Moto\Features::isEnabled('theme_spacings')) { Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/extra_spacings.less'), $content); return; } $twig = Moto\Render::getInstance('less'); $spacings = Moto\Website\Settings::get('spacings'); if (is_string($spacings)) { $spacings = json_decode($spacings, true); } $extra_spacings = []; if (is_array($spacings)) { foreach ($spacings as $device => $sizes) { if (!is_array($sizes)) { continue; } $extra_spacings[$device] = []; foreach ($sizes as $size => $value) { if (is_array($value) && !empty($value['value'])) { $extra_spacings[$device][] = $size; } } } } $content = $twig->render('@lessTemplates/spacings/extra.less.twig', array( 'extra_spacings' => $extra_spacings )); Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userLessDir/extra_spacings.less'), $content); } public static function buildLess($event = false) { if ($event instanceof \Zend\EventManager\Event) { $useDeferred = ($event->getName() !== Moto\Hook::SYSTEM_SHUTDOWN); } else { $useDeferred = ($event !== true); } if ($useDeferred) { Moto\Hook::once(Moto\Hook::SYSTEM_SHUTDOWN, 'Moto\System\Style::buildLess'); return; } try { require_once 'Lessphp/lessc.inc.php'; $lessc = new \lessc(); $lessc->setImportDir(Moto\Config::get('rootPath')); if (Moto\System::getStage() != Moto\System::ENV_DEVELOPMENT) { $lessc->setFormatter('compressed'); } if (Moto\System::getPath('systemWebsiteStyleLessDir')) { $lessFilePath = Moto\System::getAbsolutePath('@systemWebsiteStyleLessDir/style.less'); } else { $lessFilePath = Moto\System::getAbsolutePath('@systemIncludes/templates/less/website/style.less'); } if (defined('Moto\Hook::BOOTSTRAPPED_LESS_COMPILER')) { Moto\Hook::trigger(Moto\Hook::BOOTSTRAPPED_LESS_COMPILER, $lessc); } $css = $lessc->compileFile($lessFilePath); Moto\Util::filePutContents(Moto\System::getAbsolutePath('@userStylesFile'), $css); if (defined('Moto\Hook::WEBSITE_STYLES_FILE_SAVED')) { Moto\Hook::trigger(Moto\Hook::WEBSITE_STYLES_FILE_SAVED, '@userStylesFile'); } } catch (\Exception $e) { Moto\System\Log::error('ERROR_ON_BUILD_LESS', array('code' => $e->getCode(), 'message' => $e->getMessage())); } } } 