<?php
 namespace Moto\System\Task; use Illuminate\Contracts\Support\Arrayable; use Moto; use Illuminate; use Illuminate\Bus\Queueable; use Illuminate\Queue\InteractsWithQueue; use Illuminate\Contracts\Queue\ShouldQueue; use Illuminate\Foundation\Bus\Dispatchable; use Illuminate\Queue\SerializesModels; use Ramsey\Uuid\Uuid; use JsonSerializable; use Exception; abstract class AbstractTask implements ShouldQueue, JsonSerializable, Illuminate\Contracts\Support\Arrayable { use Dispatchable; use InteractsWithQueue; use Queueable; use SerializesModels; public $queue; protected $uuid = null; protected $pushed = false; public function getName() { return array_last(explode('\\', get_class($this))); } public function getLabel() { return 'TASK.' . strtoupper($this->getName()); } protected function localStorage() { return $this->getStateModel()->storage->getOrCreate($this->getUuid()); } protected function response() { return $this->getStateModel()->response->getOrCreate($this->getUuid()); } public function getProgress() { return null; } public function meta() { return $this->getStateModel()->meta; } protected function app($resource = null) { return Moto\System::app($resource); } public $stateModel; public function setStateModel(Moto\System\Task\Database\JobTaskState $state) { $this->stateModel = $state; if ($state->queue) { $this->allOnQueue($state->queue); } } public function getStateModel() { if ($this->stateModel instanceof Moto\System\Task\Database\JobTaskState) { return $this->stateModel; } $repository = $this->app('task.state'); $this->stateModel = $repository->getOrCreate($this); return $this->stateModel; } public function getUuid() { if ($this->uuid) { return $this->uuid; } $this->uuid = Uuid::uuid4()->toString(); return $this->uuid; } public function getQueue() { if ($this->queue) { return $this->queue; } $this->queue = 'task:' . Uuid::uuid4()->toString(); return $this->queue; } public function isPushed() { return $this->pushed; } public function pushed() { $this->pushed = true; $this->meta()->pushed(); $this->save(); } public function release($delay = 0) { if (!$this->job) { return false; } if ($this->job->isReleased()) { return false; } return $this->job->release($delay); } final public function handle() { $exception = null; $response = null; $meta = $this->meta(); try { $meta->onExecuting($this); $this->save(); $response = $this->executing(); } catch (Exception $exception) { $response = $this->returnError($exception); } if (!$response instanceof ExecutingResult) { $response = ($response === true) ? $this->returnCompleted() : $this->returnError($response); } $meta->onCompleted($this, $response); $meta->save(); if ($exception) { throw $exception; } if ($response->isNeedRepeat()) { $this->release(); } } public function failed(Exception $exception) { $meta = $this->meta(); $meta->onCompleted($this, $this->returnError($exception)); $meta->save(); } protected function returnCompleted($response = null) { return new ExecutingResult([ 'type' => ExecutingResult::TYPE__COMPLETED, 'completed' => true, 'response' => $response, ]); } protected function returnNeedRepeat($response = null) { return new ExecutingResult([ 'type' => ExecutingResult::TYPE__NEED_REPEAT, 'needRepeat' => true, 'response' => $response, 'isError' => false, ]); } protected function returnError($error) { if ($error instanceof \Exception) { $error = [ 'type' => 'exception', 'code' => $error->getCode(), 'message' => $error->getMessage(), 'exception' => get_class($error), ]; } return new ExecutingResult([ 'type' => ExecutingResult::TYPE__ERROR, 'completed' => false, 'error' => $error, ]); } protected function executing() { return $this->returnCompleted(); } public function save() { $state = $this->getStateModel(); if ($state instanceof Moto\System\Task\Database\JobTaskState) { $state->save(); } } public function jsonSerialize() { return $this->toArray(); } public function toArray() { $state = $this->getStateModel(); $attributes = [ 'uuid' => $this->getUuid(), 'name' => $this->getName(), 'label' => $this->getLabel(), 'queue' => $this->getQueue(), 'state' => $state instanceof Arrayable ? $state->toArray() : $state, ]; return $attributes; } } 