<?php
 namespace Moto\System\Task\Casts; use InvalidArgumentException; use Illuminate\Contracts\Database\Eloquent\CastsAttributes; use Moto\System\Task\Storage\StorageInterface; use Illuminate\Support\Collection; class StorageCast implements CastsAttributes { protected $class; public function __construct($class = Collection::class) { if (!is_string($class) || !class_exists($class)) { throw new InvalidArgumentException('Invalid type class or not exists'); } $this->class = $class; } public function get($model, string $key, $value, array $attributes) { if ($value === null) { $value = data_get($attributes, $key); } if (is_string($value)) { $value = $this->decode($value); } if (is_object($value)) { if ($value instanceof StorageInterface) { $value->setStorageOwner($model); } return $value; } return $this->class::make($value, $model); } public function set($model, string $key, $value, array $attributes) { if ($value === null) { $value = data_get($attributes, $key); } if ($value === null) { $value = []; } return $this->encode($value); } protected function decode($value) { if ($value === null) { return []; } $value = base64_decode($value); $value = unserialize($value); return $value; } protected function encode($value) { $value = serialize($value); $value = base64_encode($value); return $value; } } 