<?php
 namespace Moto\System\Task\Database; use Exception; use Moto; use Illuminate; class DatabaseMigration { const INITIATOR__INSTALLER = '@INSTALL'; const INITIATOR__UPDATER = '@UPDATE'; protected $schema; protected $initiator; protected $tables = [ 'job_tasks', 'jobs_pool', ]; public function getTables() { return $this->tables; } protected function getSchemaBuilder() { if (!$this->schema) { $this->schema = Moto\Database\Provider::getSchemaBuilder(); } return $this->schema; } protected function isTableExists($name) { return $this->getSchemaBuilder()->hasTable($name); } public function isNeedMigrate() { foreach ($this->tables as $tableName) { if (!$this->isTableExists($tableName)) { return true; } } return false; } protected function createAllTables() { foreach ($this->tables as $tableName) { if (!$this->createTable($tableName)) { return false; } } return true; } public function createTable($name) { if ($this->isTableExists($name)) { return true; } switch ($name) { case 'job_tasks': return $this->createJobTasksTable($name); case 'jobs_pool': return $this->createJobsPoolTable($name); } throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } protected function createJobTasksTable($tableName) { $schemaBuilder = $this->getSchemaBuilder(); $this->info('Creating table `' . $tableName . '`'); $schemaBuilder->create($tableName, function ($table) use ($schemaBuilder) { $table->bigIncrements('id'); $table->unsignedInteger('build')->nullable(); $table->unsignedInteger('created_by')->nullable(); $table->string('name'); $table->string('uuid', 36); $table->string('queue', 191); $table->longText('meta')->nullable(); $table->longText('storage')->nullable(); $table->timestamp('expired_at')->nullable(); $table->timestamps(); $table->unique('uuid', 'task_uuid'); $table->index('queue', 'task_queue'); $table->index(['created_by', 'build'], 'task_created'); }); $this->info('Table was created'); return true; } protected function createJobsPoolTable($tableName) { $schemaBuilder = $this->getSchemaBuilder(); $this->info('Creating table `' . $tableName . '`'); $schemaBuilder->create($tableName, function ($table) use ($schemaBuilder) { $table->bigIncrements('id'); $table->string('queue', 191); $table->longText('payload'); $table->unsignedTinyInteger('attempts'); $table->unsignedInteger('reserved_at')->nullable(); $table->unsignedInteger('available_at'); $table->unsignedInteger('created_at'); $table->index('queue', 'job_queue'); }); $this->info('Table was created'); return true; } protected function info($message, $context = []) { Moto\System\Log::info((string) $this->initiator . ' : ' . $message, $context); } protected function error($message, $context = []) { Moto\System\Log::error((string) $this->initiator . ' : ' . $message, $context); } public function install() { try { $this->initiator = static::INITIATOR__INSTALLER; $this->createAllTables(); } catch (Exception $e) { $this->error('Task Manager Exception: [ ' . $e->getCode() . ' ] ' . $e->getMessage()); throw $e; } $this->initiator = null; return true; } public function update($fromBuild = 0) { try { $this->initiator = static::INITIATOR__UPDATER; $this->createAllTables(); } catch (Exception $e) { $this->error('Task Manager Exception: [ ' . $e->getCode() . ' ] ' . $e->getMessage()); throw $e; } $this->initiator = null; return true; } } 