<?php
 namespace Moto\System\Task\Database; use Moto; use Moto\System\Task; use Illuminate; use Ramsey\Uuid\Uuid; class JobTaskState extends Moto\Database\BaseModel { protected $table = 'job_tasks'; protected $attributes = [ ]; protected $fillable = [ 'build', 'created_by', 'name', 'uuid', 'queue', 'meta', 'storage', 'expired_at', ]; protected $casts = [ 'build' => 'int', 'created_by' => 'int', 'meta' => Task\Casts\StorageCast::class . ':' . Task\Storage\MetaStorage::class, 'storage' => Task\Casts\StorageCast::class . ':' . Task\Storage\GlobalStorage::class, 'response' => Task\Casts\StorageCast::class . ':' . Task\Storage\GlobalStorage::class, 'errors' => Task\Casts\StorageCast::class, ]; protected $dates = [ 'expired_at', ]; protected $hidden = [ 'storage', ]; public function __construct(array $attributes = []) { $this->uuid = Uuid::uuid4()->toString(); $this->build = Moto\Version::getBuild(); $user = Moto\System::getUser(); if ($user) { $this->created_by = $user->id; } parent::__construct($attributes); } public function toResponse() { return $this->meta; } public function isCompleted() { return $this->meta->completed; } public function isFailed() { return $this->meta->failed; } public function isFinished() { return ($this->isCompleted() || $this->isFailed()); } public function isRunning() { return $this->meta->isRunning(); } public function isJobInPool() { if (!$this->exists) { return null; } return JobPool::query()->where('queue', $this->queue)->exists(); } public function getJobFromPool() { if (!$this->exists) { return null; } return JobPool::query()->where('queue', $this->queue)->first(); } } 