<?php
 namespace Moto\System\Task\Storage; use Moto; use Illuminate; use Illuminate\Support\Collection; use Moto\System\Task\AbstractTask; use Moto\System\Task\ExecutingResult; use Moto\System\AttributesBag; use Ramsey\Uuid\Uuid; class MetaStorage extends AttributesBag implements Moto\System\Task\Storage\StorageInterface { protected $attributes = [ 'uuid' => null, 'serialized' => 0, 'queue' => null, 'pushed' => false, 'execution' => null, 'current' => [], 'completed' => false, 'failed' => null, 'steps' => [], ]; protected $owner; public function __construct($attributes = []) { $this->uuid = Uuid::uuid4()->toString(); $this->attributes['errors'] = new Collection(); parent::__construct($attributes); } protected function getStepsAttribute($value) { if (empty($value)) { $this->attributes['steps'] = new Collection(); } return $this->attributes['steps']; } protected function setStepsAttribute($value) { return false; } public function setPushedAttribute($value) { return false; } public function setErrorsAttribute($value) { return false; } public function pushed() { $this->attributes['pushed'] = true; } public function setStorageOwner($owner = null) { $this->owner = $owner; if ($owner) { $this->queue = $owner->queue; } } public function getStorageOwner() { return $this->owner; } public function get($name, $default = null) { return $this->getAttribute($name, $default); } public function put($name, $value) { return $this->setAttribute($name, $value); } public function save() { if (!$this->owner) { throw new Moto\Exception(__METHOD__ . ' : doesnt have owner'); } return $this->owner->save(); } protected function getStep($uuid) { if (!$this->steps->offsetExists($uuid)) { throw new Moto\Exception('Unknown step uuid : ' . var_export($uuid, true)); } return $this->steps->offsetGet($uuid); } protected function updateStep($uuid, $attributes) { foreach ($this->steps as $index => $step) { if ($uuid !== Moto\Util::getValue($step, 'uuid')) { continue; } $step = array_merge($step, $attributes); $this->steps->offsetSet($index, $step); return true; } return false; } protected function taskToBag(AbstractTask $task, array $attributes = []) { $bag = new AttributesBag(); $attributes = array_merge([ 'uuid' => $task->getUuid(), 'name' => $task->getName(), 'completed' => false, 'running' => false, ], $attributes); $progress = $task->getProgress(); if ($progress) { $attributes['progress'] = $progress; } $bag->fill($attributes); return $bag; } public function setSteps(Collection $sequence) { if ($this->pushed) { return false; } $steps = new Collection(); $position = 0; foreach ($sequence as $task) { $steps->offsetSet($task->getUuid(), $this->taskToBag($task, [ 'position' => $position++, ])); } $this->attributes['steps'] = $steps; $this->setCurrent($sequence->first()); } public function setCurrent($bag) { if ($bag instanceof AbstractTask) { $bag = $this->taskToBag($bag); } if (is_string($bag)) { $bag = $this->getStep($bag); } $this->current = $bag; } public function onExecuting(AbstractTask $task) { $current = $this->current; if ($current->uuid !== $task->getUuid()) { throw new Moto\Exception(__METHOD__ . ' # ' . __LINE__); } $step = $this->getStep($task->getUuid()); $step->increment('attempts'); $step['running'] = true; $execution = clone $step; $execution['start_at'] = microtime(true); $this->execution = $execution; return $this; } protected function getNotCompletedStep() { return $this->steps->sortBy('position') ->firstWhere('completed', false); } public function onCompleted(AbstractTask $task, ExecutingResult $result) { $execution = $this->execution; if ($execution->uuid !== $task->getUuid()) { throw new Moto\Exception(__METHOD__ . ' # ' . __LINE__); } $step = $this->getStep($task->getUuid()); $execution['response'] = $result->getResponse(); $execution['running'] = false; $execution['stop_at'] = microtime(true); $execution['working'] = $execution['stop_at'] - $execution['start_at']; $step['running'] = false; $progress = $task->getProgress(); if ($progress) { $execution['progress'] = $progress; $step['progress'] = $progress; } if ($result->isError()) { $step['failed'] = true; $execution['failed'] = true; $this->errors->push($result->getError()); return $this; } if ($result->isCompleted()) { $step['completed'] = true; $execution['completed'] = true; } $current = $this->getNotCompletedStep(); if (!$current) { $this->completed = true; } $this->setCurrent($current); return $this; } public function onFailed(AbstractTask $task) { $this->updateStep($task->getUuid(), [ 'completed' => true, 'running' => false, ]); return $this; } public function dump() { $mini = function ($step) { if (!$step) { return null; } return implode(', ', array_map(function ($a) { return var_export($a, true); }, Moto\Util::arrayOnly(json_decode(json_encode($step), true), ['name', 'completed', 'running', 'attempts']))); }; $dump = [ 'queue' => $this->queue, 'current' => $mini($this->current), 'execution' => $mini($this->execution), 'next' => $mini($this->next), 'steps' => $this->steps->map($mini), ]; return $dump; } public function isRunning() { return Moto\Util::getValue($this->execution, 'running'); } public function toArray($attributes = []) { $data = parent::toArray($attributes); if (!empty($data['steps'])) { $data['steps'] = array_values($data['steps']); } return $data; } public static function make($items = [], $model = null) { $collection = new static($items); $collection->setStorageOwner($model); return $collection; } public function __sleep() { return [ 'attributes', ]; } public function __wakeup() { } } 