<?php
 namespace Moto\System\Task; use Illuminate\Contracts\Debug\ExceptionHandler; use Illuminate\Queue\Failed\NullFailedJobProvider; use Moto; use Illuminate; class TaskServiceProvider extends Illuminate\Queue\QueueServiceProvider { protected $defer = true; public function register() { $this->registerManager(); $this->registerStateRepository(); $this->registerWorker(); } protected function registerManager() { $this->app->singleton('task.manager', function () { return tap(new Moto\System\Task\TaskManager($this->app), function ($manager) { $migration = new Moto\System\Task\Database\DatabaseMigration(); if ($migration->isNeedMigrate()) { try { Moto\System\Log::info('[TaskManager] : Update database for Task Manager'); $migration->update(); Moto\System\Log::info('[TaskManager] : Database updated'); } catch (\Exception $e) { Moto\System\Log::critical("[TaskManager] : Database NOT updated => [{$e->getCode()}] {$e->getMessage()}"); } } $this->registerConnectors($manager); }); }); } protected function registerStateRepository() { $this->app->singleton('task.state', function () { return new Moto\System\Task\TaskStateRepository($this->app['task.manager']); }); } protected function registerWorker() { $this->app->singleton('task.worker', function () { return new TaskWorker( $this->app['task.manager'], $this->app['events'], $this->app[ExceptionHandler::class] ); }); } public function provides() { return [ 'task.manager', 'task.worker', 'task.state', ]; } } 