<?php
 namespace Moto\System\Task; use JsonSerializable; use Moto; use Illuminate; use Closure; use Ramsey\Uuid\Uuid; use RuntimeException; class TaskWrapper implements JsonSerializable { const DEFAULT_NAME = null; const DEFAULT_LABEL = null; use Moto\System\Traits\AttributesTrait; protected $attributes = [ 'name' => null, 'label' => null, 'queue' => null, ]; protected $appends = [ 'name', 'label', 'state', 'meta', ]; protected $sequence = null; protected $stateModel; protected $mainTask; public function getNameAttribute($value) { if (empty($value)) { $name = static::DEFAULT_NAME; if (empty($name)) { $name = array_last(explode('\\', get_class($this))); } $this->attributes['name'] = $name; } return $this->attributes['name']; } public function getLabelAttribute($value) { if (empty($value)) { $label = static::DEFAULT_LABEL; if (empty($label)) { $label = 'TASK.' . strtoupper(Moto\Util::toSnakeCase($this->name)); } $this->attributes['label'] = $label; } return $this->attributes['label']; } public function getQueueAttribute($value) { if (empty($value)) { $this->attributes['queue'] = 'task:' . Uuid::uuid4()->toString(); } return $this->attributes['queue']; } public function getMetaAttribute() { return $this->state->meta; } public function getStateAttribute() { if ($this->stateModel) { return $this->stateModel; } $repository = Moto\System::app('task.state'); $this->stateModel = $repository->createNew($this->queue, [ 'name' => $this->name, ]); return $this->stateModel; } public function isEmpty() { return $this->getSequence()->isEmpty(); } protected function getSequence() { if (!$this->sequence) { $this->sequence = new Illuminate\Support\Collection(); } return $this->sequence; } protected function sanitizeSubTask($task) { if (is_string($task)) { if (!class_exists($task)) { throw new RuntimeException('Invalid : ' . var_export($task, true)); } $task = new $task($this->state); } if ($task instanceof AbstractTask) { $task->setStateModel($this->state); } else { throw new RuntimeException('Invalid'); } return $task; } public function isLocked() { return $this->mainTask !== null; } public function prependSubTask($task) { if ($this->isLocked()) { return false; } $this->getSequence()->prepend($this->sanitizeSubTask($task)); return true; } public function pushSubTask($task) { if ($this->isLocked()) { return false; } $this->getSequence()->push($this->sanitizeSubTask($task)); return true; } public function getMainTask() { if ($this->mainTask) { return $this->mainTask; } $state = $this->state; $sequence = $this->getSequence(); $state->meta->setSteps($sequence); $mainTask = $sequence->shift(); $state->save(); $mainTask->chain($sequence->all()); $mainTask->allOnQueue($state->queue); $this->mainTask = $mainTask; $state->save(); return $this->mainTask; } } 