<?php
 namespace Moto\System\Traits; use Moto; use Illuminate\Contracts\Support\Arrayable; use RuntimeException; trait AttributesTrait { public function fill(array $attributes) { if (property_exists($this, 'fillable') && is_array($this->fillable) && count($this->fillable) > 0) { $attributes = Moto\Util::arrayOnly($attributes, $this->fillable); } foreach ($attributes as $attribute => $value) { $this->setAttribute($attribute, $value); } } public function getAttribute($name, $default = null) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } $value = $default; if (array_key_exists($name, $this->attributes)) { $value = $this->attributes[$name]; } $method = 'get' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } return $value; } public function requireAttribute($attribute) { $value = $this->getAttribute($attribute); if (empty($value)) { throw new Moto\Exception('Attribute "' . $attribute . '" is required'); } return $value; } public function setAttribute($name, $value) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } $method = 'set' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } $this->attributes[$name] = $value; return true; } public function unsetAttribute($name) { unset($this->attributes[$name]); } public function hasAttribute($name) { return array_key_exists($name, $this->attributes); } public function toArray($attributes = []) { $data = []; if (empty($attributes)) { $attributes = array_keys($this->attributes); } foreach ($attributes as $attribute) { if (!array_key_exists($attribute, $this->attributes)) { continue; } $value = $this->attributes[$attribute]; $data[$attribute] = $value instanceof Arrayable ? $value->toArray() : $value; } if (property_exists($this, 'appends') && is_array($this->appends) && count($this->appends) > 0) { foreach ($this->appends as $attribute) { $value = $this->getAttribute($attribute); $data[$attribute] = $value instanceof Arrayable ? $value->toArray() : $value; } } return $data; } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { $json = json_encode($this->jsonSerialize(), $options); if (json_last_error() !== JSON_ERROR_NONE) { throw new RuntimeException('Error encoding object "' . get_class($this) . '" to JSON (' . json_last_error_msg() . ')'); } return $json; } public function offsetExists($offset) { return $this->hasAttribute($offset); } public function offsetGet($offset) { return $this->getAttribute($offset); } public function offsetSet($offset, $value) { $this->setAttribute($offset, $value); } public function offsetUnset($offset) { $this->unsetAttribute($offset); } public function __get($name) { return $this->getAttribute($name); } public function __set($name, $value) { $this->setAttribute($name, $value); } public function __isset($name) { return $this->hasAttribute($name); } public function __unset($name) { $this->unsetAttribute($name); } } 