<?php
 namespace Moto\System\Widgets; use Illuminate\Support\Collection; use Moto; class AbstractContainerWidget extends AbstractWidget { protected $_defaultOptions = array(); protected $_templateType = 'templates'; protected $_templatePath = null; public $children = array(); public function __construct($content) { $this->children = (array) Moto\Util::getFrom($content, 'children', array()); $this->children = new Collection($this->children); parent::__construct($content); } public function init() { parent::init(); $this->initChildren(); } public function isContainer() { return true; } public function initChildren() { $children = $this->children; $childrenCount = count($children); foreach ($children as $index => $data) { if (is_array($data)) { $widget = Moto\System\Widgets\Factory::create($data); } else { $widget = Moto\System\Widgets\Factory::createById($data); } if (!$widget) { $widget = Moto\System\Widgets\Factory::createBrokenWidget($data, $this->getRenderEngine()); } $widget->setParent($this, [ 'index' => $index, 'last' => $index === ($childrenCount - 1), 'first' => $index === 0, ]); $this->children[$index] = $widget; } } public function getTemplatePath($preset = null) { if (!empty($this->_templatePath)) { return $this->_templatePath; } return parent::getTemplatePath($preset); } public function _exportDataAfter($data) { $children = array(); foreach ($this->children as $widget) { if (!is_object($widget)) { continue; } $children[] = $widget->exportData(); } $data['children'] = $children; return $data; } public function toArray($hierarchy = false) { $data = parent::toArray(); if ($hierarchy) { $children = $this->children->map(function ($widget) use ($hierarchy) { return $widget->toArray($hierarchy); }); } else { $children = $this->children->map(function ($widget) { return $widget->getWidgetId(); }); } $data['children'] = $children->toArray(); return $data; } public function render($context) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('@deprecated AbstractContainerWidget [' . $this->_name . '] render'); } $twig = Moto\Render::getInstance(); $templatePath = $this->getTemplatePath(); $template = $twig->loadTemplate($templatePath); $this->preRender(); if (0 && static::isPreviewMode()) { static::_addToCache($this, [ 'properties' => $this->properties, 'children' => $this->children, ]); } if (is_object($context)) { $context = (array) $context; } elseif (!is_array($context)) { $context = array(); } $context = $twig->mergeGlobals($context); $context = $twig->mergeGlobals($this->getRenderVariables()); $content = $template->render($context); $content = Moto\Hook::trigger(Moto\Hook::RENDER_FILTER__PAGE_HTML_CONTENT, $content, $this, '@widget:' . $this->getName()); return $content; } public function isBackgroundVideoSet() { return $this->getPropertyValue('bgVideo.track.webm.path') || $this->getPropertyValue('bgVideo.track.mp4.path'); } public function _getBackgroundVideoElement() { return [ 'name' => 'video_background', 'properties' => [ 'class' => $this->_getBackgroundVideoCssClass(), 'bgVideo' => $this->getPropertyValue('bgVideo'), ] ]; } public function _getBackgroundVideoCssClass() { $bgPosition = $this->getPropertyValue('bgPosition', ''); return 'moto-background-video moto-absolute-position' . (!empty($bgPosition) ? ' moto-absolute-position_' . str_replace(' ', '-', $bgPosition) : ''); } public function isBackgroundDividerSet($position) { return $this->getPropertyValue("bgDivider.$position.enabled"); } public function _getBackgroundDividerElement($settings) { if (is_string($settings)) { $settings = $this->getPropertyValue("bgDivider.$settings"); } if (!is_array($settings)) { return null; } return [ 'name' => 'background_divider', 'properties' => $settings, ]; } public function isBackgroundMultiLayerSet() { return $this->getPropertyValue('multiBg.enabled'); } public function _getBackgroundMultiLayer() { return [ 'name' => 'multilayer_background', 'properties' => $this->getPropertyValue('multiBg'), ]; } } 