<?php
 namespace Moto\System\Widgets; use Moto; use Zend\Stdlib\ArrayUtils; use Twig_Environment; use Illuminate; use JsonSerializable; use RuntimeException; abstract class AbstractWidget implements JsonSerializable, Illuminate\Contracts\Support\Arrayable, Illuminate\Contracts\Support\Jsonable { const LAZY_LOADING_CSS_CLASS = 'lazyload'; public $properties; protected static $_protectedProperties; protected static $_presetsProvidersByNames = []; protected $_innerCache = array(); protected $_name = ''; protected $_strictName = true; protected $_options = array(); protected $_originalOptions = array(); protected $_defaultOptions = array( 'link' => array( 'action' => null, 'properties' => null ), 'preset' => 'default', 'label' => '', 'align' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ), 'animation' => '', 'spacing' => array( 'top' => 'auto', 'left' => 'auto', 'right' => 'auto', 'bottom' => 'auto' ) ); protected static $_defaultProperties = null; protected $_spacingMap = array( 'auto' => 'a', 'zero' => 'z', 'small' => 's', 'medium' => 'm', 'large' => 'l' ); protected $_templateType = 'presets'; protected $_widget = array(); protected $_widgetId = false; protected $_parent = null; protected $_positionInParent = [ 'index' => -1, 'last' => false, 'first' => false, ]; protected $_allowDebug = false; protected $_renderEngine; protected $_renderOptions = []; public function __construct($options = array()) { if (!empty($options['name']) && array_key_exists('properties', $options) && $this->_isAllowThisName($options['name'])) { $this->_widgetId = Moto\Util::getFrom($options, 'id', true); $properties = Moto\Util::getValue($options, 'properties'); if (!is_array($properties)) { $properties = array(); } $properties = ArrayUtils::merge($this->_getDefaultProperties(), $properties); } else { $properties = ArrayUtils::merge($this->_options, $this->_getDefaultProperties()); if (is_array($options)) { $properties = ArrayUtils::merge($properties, $options); } } $this->_setProperties($properties); $this->_options = ArrayUtils::merge($this->_options, $properties); $this->_widget['align'] = $this->getOption('align'); $this->_widget['label'] = $this->getOption('label'); $this->_widget['animation'] = $this->getOption('animation'); $this->_allowDebug = Moto\Config::get('__DEV__.widgets_debug_deprecated'); $this->init(); } protected function _isAllowThisName($name) { if (!$this->_strictName) { return true; } return $this->_name === $name; } public function init() { } public function setRenderEngine($engine) { if ($engine instanceof Twig_Environment) { $this->_renderEngine = $engine; } else { throw new \InvalidArgumentException('This engine not supported'); } return $this; } public function getRenderEngine() { return $this->_renderEngine; } public function _getStyleHelper() { if ($this->_renderEngine) { return $this->_renderEngine->getExtension('motoStyleHelper'); } return Moto\System::app('StyleHelper'); } public function isPreviewMode() { return Moto\System\Widgets\Factory::isPreviewMode(); } public function isPreRenderMode() { return Moto\System\Widgets\Factory::isPreRenderMode(); } public function isContainer() { return false; } protected function _setProperties($properties) { if (is_array($properties)) { $this->properties = $properties; return true; } return false; } protected function _getDefaultProperties() { if (is_array(static::$_defaultProperties)) { return static::$_defaultProperties; } return is_array($this->_defaultOptions) ? $this->_defaultOptions : array(); } public function getWidgetId() { if ($this->_widgetId === false) { return false; } if (!is_string($this->_widgetId)) { $this->_widgetId = 'wid__' . str_replace(array('.', ':'), '_', trim($this->_name)) . '__' . Moto\Util::getUniqueId(); } return $this->_widgetId; } public function exportData() { $data = array( 'name' => $this->_name, 'id' => $this->getWidgetId(), 'widgetId' => $this->getWidgetId(), 'properties' => $this->getProperties(), ); return $this->_exportDataAfter($data); } protected function _exportDataAfter($data) { return $data; } public function toArray() { return [ 'id' => $this->getWidgetId(), 'name' => $this->_name, 'properties' => $this->getProperties(), ]; } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { $json = json_encode($this->jsonSerialize(), $options); if (json_last_error() !== JSON_ERROR_NONE) { throw new RuntimeException('Error encoding widget "' . $this->getName() . '" with id "' . $this->getWidgetId() . '" to JSON (' . json_last_error_msg() . ')'); } return $json; } public function getOption($name, $default = null) { if ($this->_allowDebug && Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('@deprecated widget [' . $this->_name . '] getOption( ' . $name . ' )'); } return (array_key_exists($name, $this->_options) ? $this->_options[$name] : $default); } public function getPropertyValue($name, $default = null) { if (static::$_protectedProperties === null) { return Moto\Util::getValue($this->properties, $name, $default); } $value = Moto\Util::getValue(static::$_protectedProperties, $name, null); if ($value === null) { $value = Moto\Util::getValue($this->properties, $name, $default); } return $value; } public function setRenderingOption($name, $value) { if (!is_string($name)) { return false; } $name = trim($name); if ($name === '') { return false; } $this->_renderOptions[$name] = $value; return true; } public function getRenderingOption($name, $default = null) { if (array_key_exists($name, $this->_renderOptions)) { return $this->_renderOptions[$name]; } return $default; } public function existsPropertyValue($name) { return Moto\Util::arrayHas($this->properties, $name); } public function getProperties($keys = null) { if (!empty($keys)) { return Moto\Util::arrayOnly($this->properties, $keys); } return $this->properties; } public function getName() { return $this->_name; } public function getRenderVariables() { return array( 'widget' => $this, 'currentWidget' => $this ); } public function preRender() { $this->_generateSpacing(); } public function getRenderTemplate($twig) { $templatePath = $this->getTemplatePath(); try { return $twig->loadTemplate($templatePath); } catch (\Twig_Error_Loader $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('Widgets (' . $this->getName() . ') template not found', array( 'templatePath' => $templatePath, )); } return null; } } public function getTemplatePath($preset = null) { $template = '@websiteWidgets/' . $this->getName() . '/'; if ($this->_templateType == 'templates') { return $template . 'templates/default.twig.html'; } if ($preset === null) { $preset = $this->getCurrentPreset(); } if (is_null($preset)) { $template .= 'templates/default.twig.html'; } else { $template .= 'presets/' . $preset . '/template.html.twig'; } return $template; } function __isset($name) { if (array_key_exists($name, $this->_widget)) { if ($this->_allowDebug && Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('@deprecated widget [' . $this->_name . '] __isset( ' . $name . ' )'); } return true; } return $this->existsPropertyValue($name); } function __get($name) { if (array_key_exists($name, $this->_widget)) { if ($this->_allowDebug && Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('@deprecated widget [' . $this->_name . '] __get( ' . $name . ' )'); } return $this->_widget[$name]; } return $this->getPropertyValue($name); } public function getCurrentPreset() { return $this->getPropertyValue('preset'); } public function getSpacingClasses($property = 'spacing') { $result = ''; if (is_string($property)) { $property = $this->getPropertyValue($property); } if (!empty($property) && is_array($property)) { foreach (array('top', 'right', 'bottom', 'left') as $direction) { if (empty($property[$direction])) { continue; } $result .= ' moto-spacing-' . $direction . '-' . $property[$direction]; } } return $result; } protected function _generateSpacing() { $classes = array(); $spacingShort = ''; $spacing = $this->getPropertyValue('spacing'); if (!empty($spacing) && is_array($spacing)) { foreach (array('top', 'right', 'bottom', 'left') as $direction) { $value = $spacing[$direction]; $spacingShort .= $this->_spacingMap[$value]; $classes[] = 'moto-spacing-' . $direction . '-' . $value; } $this->_widget['spacing'] = $spacingShort; $this->_widget['spacingClasses'] = implode(' ', $classes); } } public function convertToSting() { throw new \Exception('DEPRECATED METHOD : ' . __METHOD__); return Moto\System\Widgets\Factory::convertToSting($this->_name, $this->_originalOptions); } public function convertWidgetToMacros() { return '{{ widget(' . Moto\Util::toJson($this->exportData(), '@content') . ') }}'; } public function getProtectedHash() { $array = array( 'settings' => $this->getPropertyValue('settings', '') ); return Moto\System::encrypt($array); } public function getAlignClass($prefix = 'moto-align-', $propertyName = 'align') { $align = $this->getPropertyValue($propertyName); if (empty($align)) { return ''; } if (is_string($align)) { return $prefix . trim($align); } $css = ''; foreach ($align as $device => $value) { if (!is_string($value)) { continue; } $value = trim($value); if (empty($value)) { continue; } $css .= ' ' . $prefix . $value; if ($device !== 'desktop') { $css .= '_' . $device; } } $css = trim($css); return $css; } public function getSpacing($type = null) { if ($type === null) { return $this->getPropertyValue('spacing'); } if ($type === 'classes') { return Moto\Util::getFrom($this->_widget, 'spacingClasses'); } if ($type === 'short') { return Moto\Util::getFrom($this->_widget, 'spacing'); } return ''; } public function getVisibleOn($type = null) { $visibleOnValue = $this->getPropertyValue('visible_on'); if ($type === 'classes') { return Moto\System\Widgets\Helper::getCssClassesVisibleOn($visibleOnValue); } if ($type === 'short') { return Moto\System\Widgets\Helper::getShortVisibleOn($visibleOnValue); } return $visibleOnValue; } public function getPresetClasses() { if (empty($this->properties['preset'])) { return ''; } $presetName = $this->properties['preset']; $provider = 'default'; if (array_key_exists($presetName, static::$_presetsProvidersByNames)) { $provider = static::$_presetsProvidersByNames[$presetName]; } else { $separatorIndex = strrpos($presetName, '_'); if ($separatorIndex) { $provider = substr($presetName, 0, $separatorIndex); static::$_presetsProvidersByNames[$presetName] = $provider; } } return "moto-preset-$presetName moto-preset-provider-$provider"; } public function getAnimationClasses() { $result = ''; if (!empty($this->properties['animation'])) { $result .= 'moto-widget-animated wow ' . $this->properties['animation']; } return $result; } public function exportProperties() { $array = json_encode($this->getProperties()); echo $array; return ''; } public function setParent($parent, $positionInParent = []) { $this->_parent = $parent; $this->_positionInParent = $positionInParent; return $this; } public function getParent() { return $this->_parent; } public function getCssClassColor($color, $prefix = '') { $class = ''; if (!is_string($color) || empty($color)) { return $class; } $cacheKey = $prefix . '___' . $color; if (array_key_exists($cacheKey, $this->_innerCache)) { return $this->_innerCache[$cacheKey]; } if ($color[0] === '@') { $color = ltrim($color, '@'); $class = Moto\Util::toSnakeCase($color); if (preg_match('/(base|custom)_color([0-9\_]+)$/', $class, $match)) { $class = 'color' . ($match[1] === 'custom' ? '_custom' : '') . $match[2]; } } if (!empty($class)) { $class = $prefix . $class; } $this->_innerCache[$cacheKey] = $class; return $class; } public function getLazyLoadingCssClass() { if (Moto\Website\Settings::isLazyLoadingEnabled()) { return static::LAZY_LOADING_CSS_CLASS; } return ''; } protected function _findParent($filter) { if (!is_callable($filter)) { return null; } $parent = $this->getParent(); while ($parent) { if ($filter($parent)) { return $parent; } $parent = $parent->getParent(); } return $parent; } public function getCurrentPage() { return $this->getGlobalVariable('currentPage'); } public function getGlobalVariable($name, $default = null) { $engine = $this->getRenderEngine(); if (!$engine) { return $default; } $globals = $engine->getGlobals(); return Moto\Util::getValue($globals, $name, $default); } public function getPositionIndexInContainer() { return $this->_positionInParent['index']; } public function isFirstInParent() { return $this->_positionInParent['first']; } public function isLastInParent() { return $this->_positionInParent['last']; } public function shouldBeRendered() { return true; } public function beforeRendering() { } public function afterRendering() { } } 