<?php
 namespace Moto\System\Widgets; use Exception; use Illuminate\Support\Collection; use Moto; use ArrayAccess; use Countable; use IteratorAggregate; use Traversable; class OptionsStorage implements ArrayAccess, Countable, IteratorAggregate { const PROXY_METHODS = [ 'keys', 'first', 'where', 'firstWhere', 'whereIn', ]; protected $collection; public function __construct(array $data = []) { $this->reset(); $this->fill($data); } public function reset() { $this->collection = new Collection(); } public function getCollection() { return $this->collection; } public function exists($id) { if (is_array($id)) { return $this->collection->has($id); } return $this->collection->offsetExists($id); } public function get($id) { if ($this->collection->offsetExists($id)) { return $this->collection->offsetGet($id); } return null; } public function set($id, array $options) { if (!is_string($id) || empty($id)) { return false; } if (empty($options['name'])) { return false; } $options['id'] = $id; $this->collection->offsetSet($id, $options); return true; } public function fill(array $collection) { foreach ($collection as $data) { if (!array_key_exists('id', $data)) { continue; } $this->set($data['id'], $data); } return true; } public function addWidget(Moto\System\Widgets\AbstractWidget $widget) { return $this->set($widget->getWidgetId(), $widget->toArray()); } public function __call($name, $arguments) { if (!in_array($name, static::PROXY_METHODS)) { throw new \Exception('Function "' . $name . '" is not allowed'); } try { return call_user_func_array(array($this->collection, $name), $arguments); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { throw $e; } return null; } } public function offsetExists($offset) { return $this->collection->offsetExists($offset); } public function offsetGet($offset) { return $this->collection->offsetGet($offset); } public function offsetSet($offset, $value) { return $this->collection->offsetSet($offset, $value); } public function offsetUnset($offset) { return $this->collection->offsetUnset($offset); } public function count() { return $this->collection->count(); } public function getIterator() { return $this->collection->getIterator(); } } 