<?php
 namespace Moto\Twig\Extension; use Moto; class LinkerExtension extends AbstractExtension { protected $_name = 'motoLinker'; public function getGlobals() { return array( 'Linker' => $this ); } public function isCurrent($action, $properties = null) { return Moto\ClickAction\Factory::create($action)->isCurrent($properties, $this); } public function img($src) { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.img(\'' . $src . '\') }}'); } return Moto\System::getUploadUrl($src); } public function lazyImageSrcAttribute($src, $sizes = null) { if ($this->isPreRenderMode()) { Moto\System\Log::critical('Need update ' . __METHOD__ . ' # ' . __LINE__); return $this->_returnTemplate('{{ Linker.lazyImageSrcAttribute(\'' . $src . '\') }}'); } $src = Moto\System::getUploadUrl($src); $template = 'src="' . $src . '"'; if (Moto\Website\Settings::isLazyLoadingEnabled()) { $template = 'data-' . $template; if (is_array($sizes) && isset($sizes['width']) && isset($sizes['height'])) { $template .= ' src="' . $this->getImagePlaceholder($sizes['width'], $sizes['height']) . '"'; } } return $this->_returnTemplate($template); } public function lazySrcAttribute($src) { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.lazySrcAttribute(\'' . $src . '\') }}'); } $template = 'src="' . $src . '"'; if (Moto\Website\Settings::isLazyLoadingEnabled()) { $template = 'data-' . $template; } return $this->_returnTemplate($template); } public function file($src) { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.file(\'' . $src . '\') }}'); } return Moto\System::getUploadUrl($src); } public function homePage($fallback = '#') { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.homePage(\'' . $fallback . '\') }}'); } $click = Moto\ClickAction\Factory::create('home_page'); $click->set('anchor', ''); $click->set('fallback', ''); if (!empty($fallback) && preg_match('/^([^#]*)#([^#]+)$/', $fallback, $match)) { $click->set('fallback', $match[1]); $click->set('anchor', $match[2]); } $url = $fallback; if ($click) { $url = $click->getUrl(); } return $this->_returnTemplate($url); } public function pageLink($value, $fallback = '#') { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.pageLink(' . $value . ',\'' . $fallback . '\') }}'); } $click = Moto\ClickAction\Factory::create('page', array('id' => $value)); $click->set('anchor', ''); $click->set('fallback', $fallback); if (!empty($fallback) && preg_match('/^([^#]*)#([^#]+)$/', $fallback, $match)) { $click->set('fallback', $match[1]); $click->set('anchor', $match[2]); } $url = $fallback; if ($click) { $url = $click->getUrl(); } return $this->_returnTemplate($url); } public function popupLink($value) { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.popupLink(' . $value . ') }}'); } $url = '#'; $click = Moto\ClickAction\Factory::create('popup', array('id' => $value)); if ($click) { $url = $click->getUrl(); } return $url; } protected function _parseClickActionValue($value) { if (is_string($value)) { $value = trim($value); if ($value === '') { return $value; } if ($value[0] !== '{') { $temp = trim(base64_decode($value)); if ($temp !== '' && $temp[0] === '{') { $value = $temp; } } if ($value[0] === '{') { $temp = json_decode($value, true); if (is_array($temp)) { $value = $temp; } } } elseif (is_object($value)) { $value = json_decode(json_encode($value), true); } return $value; } public function taxonomyLink($value, $fallback = '#') { if ($this->isPreRenderMode()) { if (is_array($value) || is_object($value)) { $value = json_encode($value); } return $this->_returnTemplate('{{ Linker.taxonomyLink(\'' . $value . '\',\'' . $fallback . '\') }}'); } $params = $this->_parseClickActionValue($value); if (!is_array($params)) { $params = array('id' => $value); } $click = Moto\ClickAction\Factory::create('taxonomy', $params); $click->set('fallback', $fallback); if (!empty($fallback) && preg_match('/^([^#]*)#([^#]+)$/', $fallback, $match)) { $click->set('fallback', $match[1]); if (!$click->has('anchor')) { $click->set('anchor', $match[2]); } } $url = $click->getUrl(); return $url; } public function href($link, $default = '#') { if (!is_array($link)) { return $default; } if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.href(' . json_encode($link) . ',\'' . $default . '\') }}'); } $click = Moto\ClickAction\Factory::create($link); $click->set('fallback', $default); $url = $default; if ($click) { $url = $click->getUrl(); } return $this->_returnTemplate($url); } public function relativeUrl($path = '@website') { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.relativeUrl(\'' . $path . '\') }}'); } return Moto\System::getRelativeUrl($path); } public function absoluteUrl($path = '@website') { if ($this->isPreRenderMode()) { return $this->_returnTemplate('{{ Linker.absoluteUrl(\'' . $path . '\') }}'); } return Moto\System::getAbsoluteUrl($path); } public function getLinkAttributes($link) { if ($this->isPreRenderMode()) { $code = '{{ Linker.getLinkAttributes(' . json_encode($link) . ') }}'; } else { $code = Moto\ClickAction\Factory::create($link)->generateTagAttrs(); } return $this->_returnTemplate($code); } public function getAction($action, $options = array()) { if ($this->isPreRenderMode()) { throw new \Exception('PRE_RENDER_NOT_ALLOWED'); } if (is_string($options)) { if ($options[0] !== '{') { $temp = base64_decode($options); if ($temp[0] === '{') { $options = $temp; } } $temp = json_decode($options, true); if (is_array($temp)) { $options = $temp; } } return Moto\ClickAction\Factory::create($action, $options); } public function getImagePlaceholder($width, $height) { return "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 $width $height'%3E%3C/svg%3E"; } public function __call($name, $args) { if ($this->isPreRenderMode()) { throw new \Exception('PRE_RENDER_NOT_ALLOWED'); } $action = Moto\Util::toSnakeCase($name, '.'); if (strpos($action, 'get.action.') === 0) { $parts = explode('.', $action, 3); if (!empty($parts[2])) { $action = $parts[2]; } return $this->getAction($action, $args[0]); } return null; } } 