<?php
 namespace Moto\Twig\Extension; use Moto; use Twig; use Closure; class StyleHelperExtension extends AbstractExtension { protected $_name = 'motoStyleHelper'; protected $_options = array( 'colorAsVariable' => false, ); protected $_systemColors; protected $_constants = array( 'const_media_desktop_max_width' => '100%', 'const_media_tablet_max_width' => '1039px', 'const_media_mobile-h_max_width' => '767px', 'const_media_mobile-v_max_width' => '479px', ); protected $_cssRuleGenerators = []; protected $_transformers = []; public function __construct() { $this->addCssRuleGenerator('box-shadow', [$this, 'generateBoxShadowValue']); $this->addCssRuleGenerator('text-shadow', [$this, 'generateTextShadowValue']); $this->addCssRuleGenerator('background-image', [$this, 'generateBackgroundImageValue']); $this->addCssRuleGenerator('moto-vertical-alignment', [$this, 'generateVerticalAlignmentValue']); $this->addCssRuleGenerator('moto-icon-for-pseudo-element', [$this, 'generateMotoIconForPseudoElementValue']); $this->addCssRuleGenerator('opacity', [$this, 'generateOpacityValue']); $this->addTransformer([$this, 'transformStyledTextLists']); Moto\Hook::trigger(Moto\Hook::STYLE_HELPER__CREATED, $this); } public function addTransformer($handler) { if (!is_callable($handler)) { return false; } $this->_transformers[] = $handler; return true; } public function hasCssRuleGenerator($name) { return array_key_exists($name, $this->_cssRuleGenerators); } protected function getCssRuleGenerator($name) { if (!$this->hasCssRuleGenerator($name)) { return null; } $handler = $this->_cssRuleGenerators[$name]['handler']; if (is_string($handler)) { return $this->getCssRuleGenerator($handler); } return $handler; } public function addCssRuleGenerator($name, $handler, $rewritable = true) { if ($this->hasCssRuleGenerator($name) && !$this->_cssRuleGenerators[$name]['rewritable']) { return false; } if (!is_callable($handler) && !$this->hasCssRuleGenerator($handler)) { return false; } $this->_cssRuleGenerators[$name] = [ 'handler' => $handler, 'rewritable' => (boolean) $rewritable, ]; return true; } public function generateBoxShadowValue($value) { if (is_string($value)) { return $value; } if (!is_array($value)) { return null; } if (Moto\Util::arrayHas($value, 'enabled')) { if (!Moto\Util::getValue($value, 'enabled')) { return null; } unset($value['enabled']); $value['type'] = $value['inset'] ? 'inset' : 'outset'; unset($value['inset']); } if (!Moto\Util::arrayHas($value, 'type')) { return null; } if (Moto\Util::getValue($value, 'type') === 'none') { return new Moto\System\BagValue('box-shadow: none;'); } $result = []; $result[] = Moto\Util::getValue($value, 'offsetX'); $result[] = Moto\Util::getValue($value, 'offsetY'); $result[] = Moto\Util::getValue($value, 'blur'); $result[] = Moto\Util::getValue($value, 'spread'); $color = (string) Moto\Util::getValue($value, 'color'); $color = trim($color); if (!empty($color)) { if (strpos(strtolower($color), 'rgb') === 0 || $color[0] === '#') { $result[] = $color; } elseif ($this->getOption('colorAsVariable')) { $result[] = $color; } elseif ($this->isPreRenderMode()) { $result[] = '{{ StyleHelper.getSystemColor(\'' . $color . '\') }}'; } else { $result[] = $this->getSystemColor($color); } } if (Moto\Util::getValue($value, 'type') === 'inset') { $result[] = 'inset'; } if (count($result) < 1) { return null; } return new Moto\System\BagValue('box-shadow: ' . implode(' ', $result) . ';'); } public function generateTextShadowValue($value) { if (is_string($value)) { return $value; } if (!is_array($value)) { return null; } if (!Moto\Util::getValue($value, 'enabled', true)) { return null; } $result = []; $result[] = Moto\Util::getValue($value, 'offsetX'); $result[] = Moto\Util::getValue($value, 'offsetY'); $result[] = Moto\Util::getValue($value, 'blur'); $color = (string) Moto\Util::getValue($value, 'color'); $color = trim($color); if (!empty($color)) { if (strpos(strtolower($color), 'rgb') === 0 || $color[0] === '#') { $result[] = $color; } elseif ($this->getOption('colorAsVariable')) { $result[] = $color; } elseif ($this->isPreRenderMode()) { $result[] = '{{ StyleHelper.getSystemColor(\'' . $color . '\') }}'; } else { $result[] = $this->getSystemColor($color); } } if (count($result) < 1) { return null; } return new Moto\System\BagValue('text-shadow: ' . implode(' ', $result) . ';'); } public function generateBackgroundImageValue($value) { $result = ''; $gradientProperties = []; if (is_string($value)) { $value = trim($value); if ($value === 'none') { return 'none'; } if (substr($value, 0, 4 ) === 'url(') { return $value; } if ($this->isPreRenderMode()) { $result = 'url({{ Linker.img(\'' . $value . '\') }})'; } else { $result = 'url(' . Moto\System::getUploadUrl($value) . ')'; } return $result; } if (!is_array($value)) { return null; } if (Moto\Util::getValue($value, 'type') === 'none') { return 'none'; } if (Moto\Util::getValue($value, 'type') === 'image' && !empty($value['src'])) { if ($this->isPreRenderMode()) { $result = 'url({{ Linker.img(\'' . $value['src'] . '\') }})'; } else { $result = 'url(' . Moto\System::getUploadUrl($value['src']) . ')'; } } elseif (Moto\Util::getValue($value, 'type') === 'gradient') { $gradientProperties[] = 'to ' . Moto\Util::getValue($value, 'gradientDirection', 'left top'); $colors = (array) Moto\Util::getValue($value, 'colors'); foreach ($colors as $color) { $gradientProperties[] = $this->transformCssRuleValue('color', Moto\Util::getValue($color, 'color', 'transparent')); } $result = 'linear-gradient(' . implode(', ', $gradientProperties) . ')'; } return $result; } public function generateVerticalAlignmentValue($value) { if (is_string($value)) { return $value; } if (!is_array($value)) { return null; } $result = []; if ($value['position'] === 'center') { $result[] = "top: 50%;"; $result[] = "transform: translate(0, -50%);"; } elseif (!empty($value['value'])) { $result[] = $value['position'] . ": " . $value['value'] . ";"; $result[] = ($value['position'] === 'top' ? 'bottom' : 'top') . ": auto;"; } else { return null; } return new Moto\System\BagValue($result); } public function generateMotoIconForPseudoElementValue($value) { if (is_string($value)) { return $value; } if (!is_array($value)) { return null; } $result = []; $iconType = $value['icon_type']; if (empty($value[$iconType])) { return new Moto\System\BagValue('content:none;'); } $iconValue = $value[$iconType]; if ($iconType === 'icon') { if ($iconValue['provider'] === 'FontAwesome' && is_string($iconValue['unicode'])) { $result[] = "content:\"\\${iconValue['unicode']}\";"; $result[] = 'background-image:none;'; } } else if ($iconType === 'image') { if ($iconValue['id'] && $iconValue['path']) { $imageUrl = Moto\System::getUploadUrl($iconValue['path']); $result[] = 'content:" ";'; $result[] = "background-image:url($imageUrl);"; } } else { return new Moto\System\BagValue('content: none;'); } return new Moto\System\BagValue($result); } public function generateOpacityValue($value) { if (is_string($value)) { $value = (float) $value; } if (is_numeric($value)) { return new Moto\System\BagValue("opacity: $value;"); } return null; } public function transformStyledTextLists($input, $selector) { if (!is_array($input) || !is_string($selector)) { return $input; } if (strpos($selector, '.moto-text_') !== 0) { return $input; } foreach ($input as $key => $value) { if ($key === '^ul li&') { $input['^.moto-widget-text ul li&'] = $value; unset($input[$key]); } elseif ($key === '^ol li&') { $input['^.moto-widget-text ol li&'] = $value; unset($input[$key]); } } return $input; } protected function generateCssRuleValue($name, $value) { $handler = $this->getCssRuleGenerator($name); if (!$handler) { return $value; } try { $parameters = [$value, $name, $this]; if ($handler instanceof Closure) { $value = call_user_func_array($handler->bindTo($this, static::class), $parameters); } else { $value = call_user_func_array($handler, $parameters); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { throw $e; } } return $value; } public function _onInitRuntime() { parent::_onInitRuntime(); $this->_systemColors = Moto\Application\Styles\Service::getColorTheme(); } public function getGlobals() { return array( 'StyleHelper' => $this ); } public function getFunctions() { return array( new \Twig_SimpleFunction('generateLessFromArray', array($this, 'generateLessFromArraySafe'), array( 'is_safe' => array( 'html', ), ) ), new \Twig_SimpleFunction('generateWidgetInlineStyles', array($this, 'generateWidgetInlineStyles'), array( 'is_safe' => array( 'html', ), ) ), new \Twig_SimpleFunction('generatePresetSelector', array($this, 'generatePresetSelectorSafe'), array( 'is_safe' => array( 'html', ), ) ), new \Twig_SimpleFunction('getSystemColor', array($this, 'getSystemColor'), array( 'is_safe' => array( 'html', ), ) ), ); } public function generateLessFromArray($property, $class = null) { return new \Twig_Markup($this->generateLessFromArraySafe($property, $class), 'UTF-8'); } public function generatePresetSelector($widgetClassName, $presetClassName = null) { return new \Twig_Markup($this->generatePresetSelectorSafe($widgetClassName, $presetClassName), 'UTF-8'); } public function getSystemColor($name, $value = null) { if ($name[0] === '#') { return $name; } if (preg_match('/(base|custom)Color([0-9]+)_?([0-9]*)/', $name, $match)) { $value = Moto\Util::getValue($this->_systemColors, $match[1] . '.' . $match[2] . ($match[3] ? '.' . $match[3] : ''), $value); } return $value; } public function transformCssRuleValue($name, $value) { if (is_string($value) && $value[0] === '@' && strpos($name, 'color') !== false) { if ($this->getOption('colorAsVariable')) { return $value; } if ($this->isPreRenderMode()) { return '{{ StyleHelper.getSystemColor(\'' . $value . '\') }}'; } return $this->getSystemColor($value); } return $value; } public function transformStyleData($input, $className = null) { $input = (array) $input; if (array_key_exists('base', $input) || array_key_exists('before', $input) || array_key_exists('after', $input) || array_key_exists('hover', $input)) { return $input; } $transformers = $this->_transformers; foreach ($transformers as $handler) { try { $parameters = [$input, $className, $this]; if ($handler instanceof Closure) { $value = call_user_func_array($handler->bindTo($this, static::class), $parameters); } else { $value = call_user_func_array($handler, $parameters); } if (gettype($value) === gettype($input)) { $input = $value; } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { throw $e; } } } return $input; } public function generateLessFromArraySafe($property, $className = null) { $result = ''; if (empty($property)) { return $result; } if (is_string($property)) { if (is_string($className)) { $result .= $className . " {\n"; } $result .= $property; if (is_string($className)) { $result .= "\n}\n"; } return $result; } $property = $this->transformStyleData($property, $className); $inherits = []; foreach ($property as $name => $value) { if ((is_string($value) && empty($value)) || empty($name)) { continue; } if ($name === 'base') { $result .= $this->generateLessFromArraySafe($value); continue; } if ($name === 'before' || $name === 'after' || $name === 'hover') { $code = $this->generateLessFromArraySafe($value); if (!empty($code)) { $result .= '&:' . $name . " {\n"; $result .= $code; $result .= "}\n"; } continue; } if ($value instanceof Moto\System\BagValue) { $result .= (string) $value . "\n"; continue; } if ($name[0] === '^') { $className = (string) $className; if (empty($className)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] Empty ClassName for property name "' . $name . '"'); throw new \Exception('Class name is empty for "' . $name . '"'); } continue; } $name = substr($name, 1); $name = str_replace('&', (string) $className, $name); $inherits[$name] = $value; continue; } if ($name === 'moto-placeholder-color' && !empty($value)) { $result .= "&::-webkit-input-placeholder { color: $value }\n"; $result .= "&::-ms-input-placeholder { color: $value }\n"; $result .= "&::-moz-placeholder { color: $value }\n"; continue; } if ($this->hasCssRuleGenerator($name)) { $value = $this->generateCssRuleValue($name, $value); } if ($value instanceof Moto\System\BagValue) { $result .= (string) $value . "\n"; continue; } if (empty($value)) { continue; } if (is_array($value)) { if (array_key_exists('unicode', $value) && is_string($value['unicode'])) { $value['unicode'] = ltrim($value['unicode'], '\\'); $result .= $name . ':"\\' . $value['unicode'] . '";' . "\n"; } elseif (array_key_exists('type', $value) && $value['type'] === 'counter' && !empty($value['list-style-type'])) { $result .= $name . ':counter(moto-counter, ' . $value['list-style-type'] . ') "";' . "\n"; } continue; } $value = $this->transformCssRuleValue($name, $value); if (is_object($value)) { continue; } if ($value) { $result .= $name . ':' . $value . ';' . "\n"; } } if (is_string($className) && !empty($result)) { $result = $className . " {\n" . $result . "}\n"; } if (count($inherits) > 0) { foreach ($inherits as $selector => $value) { $result .= $this->generateLessFromArraySafe($value, $selector); } } return $result; } public function generateWidgetInlineStyles($styles) { if (is_string($styles)) { return $styles; } $styles = (array) $styles; $result = ''; foreach ($styles as $name => $value) { if (is_string($value) && empty($value)) { continue; } if ($this->hasCssRuleGenerator($name)) { $value = $this->generateCssRuleValue($name, $value); } if ($value instanceof Moto\System\BagValue) { $result .= (string) $value . "\n"; continue; } if (is_numeric($value)) { $value = (string) $value; } if (!is_string($value) || empty($value)) { continue; } if ($name === 'background-color' && $value[0] === '@') { continue; } if ($name === 'color' && $value[0] === '@') { continue; } $result .= $name . ':' . $value . ';'; } return $this->_returnTemplate($result); } public function generatePresetSelectorSafe($widgetClassName, $presetClassName = null) { $result = ''; if (!is_string($widgetClassName)) { Moto\System\Log::error('StyleHelper.generatePresetSelector: argument "$widgetClassName" should be a string:', array( '$widgetClassName' => $widgetClassName, '$presetClassName' => $presetClassName, ) ); return $result; } $result = $widgetClassName; if (!is_string($presetClassName)) { $presetClassName = Moto\Util::getValue($presetClassName, 'class_name', ''); } if (is_string($presetClassName) && !empty($presetClassName)) { $result .= '.' . $presetClassName; } return $result; } public function getDevicesList() { return ['desktop', 'tablet', 'mobile-h', 'mobile-v']; } public function getConstant($name, $default = '') { return Moto\Util::getValue($this->_constants, $name, $default); } public function addConstant($name, $value) { if (!is_string($name) || !is_string($value)) { return false; } $name = trim($name); if ($name === '') { return false; } if (array_key_exists($name, $this->_constants)) { return false; } $this->_constants[$name] = $value; return true; } } 