<?php
namespace Moto\Validator; use Moto; class NiceFilename extends Moto\Validator\AbstractValidator { const INVALID_TYPE = 'invalidType'; const EMPTY_VALUE = 'isEmpty'; const INVALID_FILENAME = 'invalidFilename'; protected $messageTemplates = array( self::INVALID_TYPE => 'Filename must be a string', self::EMPTY_VALUE => 'Filename can\'t be empty', self::INVALID_FILENAME => 'Invalid filename "%value%"', ); public function isValid($value) { if (!is_string($value)) { $this->error(static::INVALID_TYPE); return false; } if ($value === '') { $this->error(static::EMPTY_VALUE, $value); return false; } if (!preg_match('/^[a-z0-9_\-][a-z0-9_\-\.]*.[a-z0-9]+$/', $value)) { $this->error(static::INVALID_FILENAME, $value); return false; } return true; } } 