<?php
namespace Moto\Validator; use Moto; class NiceFilepath extends Moto\Validator\AbstractValidator { const INVALID_TYPE = 'invalidType'; const EMPTY_VALUE = 'isEmpty'; const INVALID_FILEPATH = 'invalidFilepath'; protected $messageTemplates = array( self::INVALID_TYPE => 'Filepath must be a string', self::EMPTY_VALUE => 'Filepath can\'t be empty', self::INVALID_FILEPATH => 'Invalid filepath "%value%"', ); public function isValid($value) { if (!is_string($value)) { $this->error(static::INVALID_TYPE); return false; } if ($value === '') { $this->error(static::EMPTY_VALUE); return false; } if ($value[0] === '@') { $regexp = '/^\@[a-zA-Z0-9]+\/([a-z0-9_\-]+\/)*[a-z0-9_\-][a-z0-9_\-\.]*.[a-z0-9]+$/'; } else { $regexp = '/^([a-z0-9_\-]+\/)+[a-z0-9_\-][a-z0-9_\-\.]*.[a-z0-9]+$/'; } if (!preg_match($regexp, $value)) { $this->error(static::INVALID_FILEPATH, $value); return false; } return true; } } 