<?php
 namespace Moto\Website; use Moto; use Twig; class ContentPage { use Moto\System\Traits\ChannelEventsTrait; protected $_title = array( 'format' => '', ); protected $_favicon = ''; protected $_headers = array(); protected $_body = ''; protected $_assets = array(); protected $_dependencies = array(); protected $_layout = ''; protected $_pageEntity; protected $_isPreview = false; protected $_isMainPage = false; protected $_isProtectedPage = false; protected $_isRenderingNow = false; protected $_canonicalUrl = ''; protected $_contentEntity = null; protected $_contentAttributes = []; protected $_templateEntity = null; protected $_renderEngine; protected $_metaSections = [ 'head' => null, ]; protected $_response; public function __construct($page = null) { $this->_resetContentAttribute(); if ($page instanceof Moto\Application\Pages\PageModel) { $this->setPageEntity($page); } } public static function wrap($target) { if ($target instanceof Moto\Website\ContentPage) { return $target; } if (!is_object($target)) { throw new \Exception('[ContentPage] Cant wrap target ' . var_export((is_object($target) ? get_class($target) : gettype($target)), true)); } $page = null; if ($target instanceof Moto\System\ContentSection\HasContentProviderInterface) { $provider = $target->getContentProvider(); if ($provider instanceof Moto\System\ContentSection\ContentProvider) { $page = $provider->wrapByContentPage($target); } } if ($page instanceof Moto\Website\ContentPage) { return $page; } if (!$target instanceof Moto\Application\Pages\PageModel) { throw new \Exception('[ContentPage] Cant wrap target ' . var_export((is_object($target) ? get_class($target) : gettype($target)), true)); } return new ContentPage($target); } public function setResponse(Moto\System\Response $response) { $this->_response = $response; } public function getResponse() { if (!$this->_response) { $this->_response = Moto\System::getResponse(); } return $this->_response; } public function setContentEntity($model) { $this->_contentEntity = $model; $this->_fireEvent('setContent'); } public function getContentEntity() { return $this->_contentEntity; } public function setTemplateEntity($model) { $this->_templateEntity = $model; $this->_fireEvent('setTemplate'); } public function getTemplateEntity() { return $this->_templateEntity; } public function setPageEntity(Moto\Application\Pages\PageModel $page) { $this->_pageEntity = $page; $template = $page->getTemplate(); if (!$template) { $template = $page; } $this->_canonicalUrl = ''; if (!$page->properties->meta->noindex && !$page->properties->meta->hideCanonical && !$page->isNotFoundPage()) { $this->setCanonicalUrl($page->getCanonicalUrl()); } $this->_resetContentAttribute(); $this->setTemplateEntity($template); $this->setContentEntity($page); return $this; } public function setRenderEngine($engine) { if ($engine instanceof \Twig_Environment) { $this->_renderEngine = $engine; return true; } return false; } public function getRenderEngine() { if (!$this->_renderEngine) { return Moto\Render::getInstance(); } return $this->_renderEngine; } public function setCanonicalUrl($url) { if (!is_string($url)) { return false; } $url = trim($url); if ($url !== '' && $url[0] === '@') { $url = Moto\System::getAbsoluteUrl($url); } $this->_canonicalUrl = $url; return true; } public function getCanonicalUrl() { return $this->_canonicalUrl; } public function addMetaTag($name, $content = null) { $meta = array(); if (is_array($name)) { $meta = $name; } } public function isPreviewMode() { return (Moto\System\Request::getQuery('mode') === 'preview'); } public function doPreRenderPage($data = array()) { $twig = $this->getRenderEngine(); $twig->addGlobal('isPreRender', true); $this->_doPreRenderSection($this->_templateEntity, $data); $this->_doPreRenderPageSections($data); $twig->addGlobal('isPreRender', false); } public function doPreRenderSection($section, $data = array()) { trigger_error('[DEPRECATED] ' . __METHOD__, E_USER_DEPRECATED); $twig = $this->getRenderEngine(); $twig->addGlobal('isPreRender', true); $this->_doPreRenderSection($section, $data); $twig->addGlobal('isPreRender', false); } protected function _doPreRenderPageSections($data = array()) { $pageSections = Moto\Util::getValue($this->_templateEntity, 'layout.sections'); if (empty($pageSections) || (!is_array($pageSections) && !is_object($pageSections))) { $this->_doPreRenderSectionByName('header', $data); $this->_doPreRenderSectionByName('footer', $data); return true; } foreach ($pageSections as $sectionName => $section) { $this->_doPreRenderSectionByName($sectionName, $data); } return true; } protected function _doPreRenderSectionByName($name, $data = array()) { $section = $this->_templateEntity->getSection($name); if (!$section) { return true; } return $this->_doPreRenderSection($section, $data); } protected function _doPreRenderSection($section, $data = array()) { if (!$section || !is_object($section)) { return true; } $isPreview = $this->isPreviewMode(); if (false && (($isPreview && !empty($section->content_data)) || empty($section->content))) { $contentHelper = new Moto\Website\PageSectionContent($section); $t0 = microtime(1); $mode = 'v4'; if ($mode === 'v1') { Moto\System\Widgets\Factory::addToCache($contentHelper->getWidgets()); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('ContentPage:PreRenderSection.v1 done by ' . (microtime(1) - $t0)); } } if ($mode === 'v2') { $section->content = $contentHelper->toTemplate(!$isPreview); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('ContentPage:PreRenderSection.v2 done by ' . (microtime(1) - $t0)); } return true; } if ($mode === 'v3') { $section->content = $contentHelper->toWidgetSection(); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('ContentPage:PreRenderSection.v3 done by ' . (microtime(1) - $t0)); } return; } if ($mode === 'v4') { $section->content = $contentHelper->getRawSection(); Moto\System\Widgets\Factory::addToCache($contentHelper->getWidgets()); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('ContentPage:PreRenderSection.v4 done by ' . (microtime(1) - $t0)); } return; } } if (is_string($section->content) && (strlen($section->content) > 1) && $section->content[0] == '{' && $section->content[1] !== '{') { $section->content = json_decode($section->content, true); } if (is_array($section->content)) { $twig = $this->getRenderEngine(); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('@ContentPage.PreRender: array to string "' . $section->name . '" [ ' . $section->id . ' ] ' . get_class($section)); } $section->content = Moto\System\Widgets\Factory::preRender($twig, 'section', $section->content, $data); } else { if (Moto\System::isDevelopmentStage() && Moto\Config::get('__DEV__.page_rendering_already_string')) { Moto\System\Log::debug('@ContentPage.PreRender: already string "' . $section->name . '" [ ' . $section->id . ' ] ' . get_class($section)); } } return true; } public function getSeoHtml() { return $this->_generateSeoHtml($this->properties); } protected function _generateSeoHtml($properties) { $result = ''; $settings = array('keywords', 'description', 'robots'); foreach ($settings as $key) { $value = Moto\Util::getValue($properties, 'meta.' . $key); if ($value) { $result .= "\n<meta name=\"" . $key . "\" content=\"" . htmlentities($value, ENT_COMPAT, 'UTF-8') . "\" />"; } } $canonicalUrl = trim((string) $this->getCanonicalUrl()); if ($canonicalUrl !== '' && !$properties->meta->noindex && !$properties->meta->hideCanonical && !$this->isNotFoundPage()) { $result .= "\n<link rel=\"canonical\" href=\"" . $this->getCanonicalUrl() . "\" />"; } $result .= $this->_generateOpenGraph($properties); return $result; } protected function _generateOpenGraph($properties) { $result = ''; $settings = Moto\Website\Settings::get('open_graph_settings'); $useDefault = Moto\Util::getValue($settings, 'default'); $og = Moto\Util::getValue($properties, 'meta.og'); if (is_object($og)) { $og = json_decode(json_encode($og), true); } $og = (array) $og; if ($useDefault) { if (empty($og['title'])) { $og['title'] = $this->title; } if (empty($og['description'])) { $og['description'] = Moto\Util::getValue($properties, 'meta.description'); } if (empty($og['url'])) { $og['url'] = $this->getCanonicalUrl(); } if (empty($og['image']) || empty($og['image']['path'])) { $og['image']['path'] = Moto\Util::getValue($properties, 'feature_media.src'); } } if (Moto\Util::getValue($this->getTemplateEntity(), 'type') === 'blog.post') { $og['type'] = 'article'; } else { $og['type'] = 'website'; } foreach ($og as $name => $value) { if (is_array($value) || is_object($value)) { switch ($name) { case 'image': $value = (array) $value; if (empty($value['path'])) { $value = ''; } else { $value = Moto\System::getUploadAbsoluteUrl($value['path']); } break; default: $value = ''; break; } } $value = trim($value); if (empty($value)) { continue; } $result .= "\n" . '<meta property="og:' . $name . '" content="' . htmlentities($value, ENT_COMPAT, 'UTF-8') . '"/>'; } return $result; } public function getLayoutTemplatePath() { $page = $this->_templateEntity; if (!$page) { return '@layoutTemplates/default/index.html.twig'; } if ($page->type === 'page') { $layoutPath = '@layoutTemplates/' . $page->layout->name . '/index.html.twig'; } else { $layoutPath = '@layoutTemplates/' . str_replace('.', '/', $page->type) . '.html.twig'; } return $layoutPath; } public function isMainPage() { if (!$this->_pageEntity) { return false; } return $this->_pageEntity->isMainPage(); } protected function _resetContentAttribute() { $this->_contentAttributes = []; $this->setContentLocale(Moto\Website\Settings::get('seo_html_attribute_lang', 'en')); } protected function _setContentAttribute($name, $value) { if (!is_string($name) || !is_string($value)) { return false; } $name = trim($name); if ($name === '') { return false; } $this->_contentAttributes[$name] = $value; return true; } protected function _getContentAttribute($name, $default = null) { if (array_key_exists($name, $this->_contentAttributes)) { return $this->_contentAttributes[$name]; } return $default; } public function setContentLocale($value) { return $this->_setContentAttribute('locale', $value); } public function getContentLocaleCode($default = null) { return $this->_getContentAttribute('locale', $default); } public function setContentDirection($value) { return $this->_setContentAttribute('direction', $value); } public function getMetaSection($name, $attribute = null) { if (!is_string($name)) { throw new Moto\Exception('Invalid name'); } $name = strtolower($name); if (!array_key_exists($name, $this->_metaSections)) { throw new Moto\Exception('Unknown meta section "' . $name . '"'); } if (!$this->_metaSections[$name]) { $this->_metaSections[$name] = new Moto\Website\Content\MetaSection(['name' => $name]); } if (!$attribute) { return $this->_metaSections[$name]; } return $this->_metaSections[$name]->getAttribute($attribute); } public function getContentDirection($default = null) { return $this->_getContentAttribute('direction', $default); } public function getRenderedWebsiteContent($force = false) { $response = $this->getResponse(); $cache = Moto\System::app('cache.website_page'); $cacheKey = null; if (($force || (!$this->isPreviewMode() && !Moto\System::getUser())) && $cache->isCacheable($this)) { $cacheKey = $cache->getKey($this); } if ($cacheKey && ($content = $cache->get($cacheKey))) { $response->setHeader('x-wsp-cache-status', 'HIT'); $response->setHeader('x-wsp-cache-key', $cacheKey); return $content; } $twig = $this->getRenderEngine(); $contentPage = $this; $twig->addGlobal('currentPage', $this); $contentPage->setRenderEngine($twig); $data = []; $this->doPreRenderPage($data); $layoutPath = $contentPage->getLayoutTemplatePath(); try { $bodyPageTemplate = $twig->loadTemplate($layoutPath); } catch (\Twig_Error_Loader $e) { if (!$this->isPreviewMode()) { Moto\System\Log::debug('Cant load layout template "' . $layoutPath . '"'); } $layoutPath = '@layoutTemplates/default/index.html.twig'; $bodyPageTemplate = $twig->loadTemplate($layoutPath); } $bodyPageContent = $bodyPageTemplate->render($data); $bodyPageContent = new Twig\Markup($bodyPageContent, 'UTF-8'); $data['PageBodyContent'] = $bodyPageContent; $websiteContent = $twig->render('@mainTemplates/base.html.twig', $data); if ($cacheKey) { $cache->put($cacheKey, $websiteContent); $response->setHeader('x-wsp-cache-status', 'MISS'); $response->setHeader('x-wsp-cache-key', $cacheKey); } else { $response->setHeader('x-wsp-cache-status', 'NONE'); } return $websiteContent; } public function __isset($name) { if (!$this->_pageEntity) { Moto\System\Log::debug("Try to check \"{$name}\" on not existed entity"); return null; } return isset($this->_pageEntity->{$name}); } public function __get($name) { if (!$this->_pageEntity) { Moto\System\Log::debug("Try to retrieve \"{$name}\" on not existed entity"); return null; } $method = 'get' . Moto\Util::toStudlyCase($name) . 'Value'; if (method_exists($this, $method)) { return $this->{$method}(); } return $this->_pageEntity->{$name}; } public function __call($name, $arguments) { if (!$this->_pageEntity) { Moto\System\Log::debug("Try to call \"{$name}\" on not existed entity"); return null; } try { return call_user_func_array(array($this->_pageEntity, $name), $arguments); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { throw $e; } return null; } } } 