<?php
namespace Moto\Website; use Moto; class PageSectionContent { protected $_version = 2; protected $_structure = null; protected $_widgets = array(); protected $_renderEngine; protected $_entity; public function __construct($entity = null) { $this->_entity = $entity; $this->_structure = new Moto\Website\PageSectionContentStructure($this); if ($entity && !empty($entity->content_data)) { $this->setRawContent($entity->content_data); } } public function setRawContent($content = null) { if ($content instanceof PageSectionContent) { $content = $content->toArray(); } if (!is_array($content) && !is_object($content)) { return false; } $this->_structure->setRawStructure(Moto\Util::getValue($content, 'structure')); $this->_widgets = Moto\Util::getValue($content, 'widgets'); return true; } public function setRenderEngine($engine) { if ($engine instanceof \Twig_Environment) { $this->_renderEngine = $engine; return true; } return true; } public function getRenderEngine() { if (!$this->_renderEngine) { return Moto\Website\Application::getInstance()->getRenderEngine(); } return $this->_renderEngine; } public function runSaving($action) { if ($action === 'insert') { return $this->runInserting(); } if ($action === 'update') { return $this->runUpdating(); } } public function runUpdating() { } public function runInserting() { } public function toWidgetSection() { $rawSection = $this->_structure->convertContent(); $t0 = microtime(1); $section = Moto\System\Widgets\Factory::create('section', $rawSection, array()); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('Creating widget "section" done by ' . (microtime(1) - $t0)); } return $section; } public function getRawSection() { return $this->_structure->getRawSection(); } public function toTemplate($createTemplate = false) { $t0 = microtime(1); $twig = $this->getRenderEngine(); $twig->addGlobal('isPreRender', true); $mode = 'v4'; if ($mode === 'v4') { $rawSection = $this->_structure->getRawSection(); Moto\System\Widgets\Factory::addToCache($this->getWidgets()); } else { $rawSection = $this->_structure->convertContent(); } $content = Moto\System\Widgets\Factory::preRender($twig, 'section', $rawSection, array()); $content = trim($content); $twig->addGlobal('isPreRender', false); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('PageSectionContent:toTemplate done by ' . (microtime(1) - $t0)); } if ($createTemplate) { $this->warmUpContent(); } return $content; } public function warmUpContent() { if (!$this->_entity) { return false; } $content = $this->_entity->content; $twig = $this->getRenderEngine(); try { $t0 = microtime(1); $localTemplate = $twig->createTemplate($content); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('PageSectionContent:warmUpContent done by ' . (microtime(1) - $t0)); } if (1==111) { echo "template class : " . get_class($localTemplate) . "\n"; echo "template name : " . $localTemplate->getTemplateName() . "\n"; echo "twig getTemplateClass : " . $twig->getTemplateClass($localTemplate->getTemplateName()) . "\n"; exit; } } catch (\Exception $e) { Moto\System\Log::emergency('Exception on "twig->createTemplate" ' . $e->getMessage()); return false; } return true; } public function toHtml() { if (!$this->_entity) { return false; } $twig = $this->getRenderEngine(); $twig->addGlobal('currentContentBlock', $this->_entity); $layoutPath = '@mainTemplates/popup/website.html.twig'; $pageTemplate = $twig->loadTemplate($layoutPath); return $pageTemplate->render(array( 'currentContentBlock' => $this->_entity, )); } public function getWidgetDataById($id) { if (!array_key_exists($id, $this->_widgets)) { return null; } return $this->_widgets[$id]; } public function getWidgets() { return $this->_widgets; } public function toArray() { return array( 'version' => $this->_version, 'structure' => $this->_structure->toArray(), 'widgets' => $this->_widgets ); } public function toJson($options = 0) { return Moto\Util::toJson($this->toArray(), $options); } } 