<?php
namespace Moto\Website; use Moto; class SettingsProvider { protected static $_instance; protected $_settingsProperties = [ 'home_page_provider' => [ 'type' => 'object', 'properties' => [ 'name' => [ 'control' => 'select', 'defaultValue' => 'page', 'defaultValues' => [ ], 'outputValues' => 'array', 'valueProviders' => [], ], ], ], ]; public static function getInstance() { if (!static::$_instance) { static::$_instance = new self(); } return static::$_instance; } protected function __construct() { $this->_init(); } protected function _init() { Moto\Hook::trigger(Moto\Hook::WEBSITE_SETTINGS_PROVIDER_CREATED, $this); } public function addValueProvider($name, $property, $handler) { if (!array_key_exists($name, $this->_settingsProperties)) { return false; } if (!array_key_exists($property, $this->_settingsProperties[$name]['properties'])) { return false; } if (is_string($handler)) { if ((int) strpos($handler, '@') < 1) { return false; } } elseif (!is_callable($handler)) { return false; } $this->_settingsProperties[$name]['properties'][$property]['valueProviders'][] = $handler; return true; } public function getSettingsControls($names) { $names = (array) $names; $result = []; foreach ($names as $name) { $values = $this->getSettingsControl($name); if ($values) { $result[$name] = $values; } } return $result; } public function getSettingsControl($controlName) { if (!is_string($controlName)) { return null; } if (!array_key_exists($controlName, $this->_settingsProperties)) { return null; } $inputControl = $this->_settingsProperties[$controlName]; if (!array_key_exists('properties', $inputControl)) { return null; } $controlProperties = $inputControl['properties']; if (!is_array($controlProperties)) { return null; } $result = [ 'properties' => [], ]; foreach ($controlProperties as $propertyName => $propertyOptions) { $propertyResult = []; if (array_key_exists('control', $propertyOptions)) { $propertyResult['control'] = $propertyOptions['control']; } if (array_key_exists('defaultValue', $propertyOptions)) { $propertyResult['defaultValue'] = $propertyOptions['defaultValue']; } $possibleValues = (array) Moto\Util::getValue($propertyOptions, 'defaultValues'); $valueProviders = (array) $propertyOptions['valueProviders']; foreach ($valueProviders as $valueProvider) { if (is_string($valueProvider) && strpos($valueProvider, '@')) { $parts = explode('@', $valueProvider, 2); if (count($parts) < 2) { continue; } $valueProvider = [Moto\System::app($parts[0]), $parts[1]]; } if (!is_callable($valueProvider)) { continue; } try { $values = call_user_func($valueProvider, $controlName, $propertyName, $possibleValues); } catch (\Exception $e) { continue; } if (is_array($values)) { $possibleValues = array_merge($possibleValues, $values); } } if (Moto\Util::getValue($propertyOptions, 'outputValues') === 'array') { $possibleValues = array_values($possibleValues); } $propertyResult['values'] = $possibleValues; $result['properties'][$propertyName] = $propertyResult; } return $result; } public function getInputFilter($settingsKeys) { return new Moto\Application\Settings\SaveWebsiteSettingsFilter([ 'enableInputs' => $settingsKeys, ]); } } 