<?php
 namespace Website\Widgets\Blog; use Illuminate\Support\Collection; use Moto\Database\Models\ContentTaxonomy; use Website; class AppliedFiltersWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.applied_filters'; protected static $_defaultProperties = [ 'elements' => [ 'label' => [ 'show' => false, 'content' => 'Filters:', 'textStyle' => 'moto-text_normal', 'spacingBetweenElements' => 'small', ], 'search' => [ 'show' => true, ], 'group' => [ 'show' => true, 'textStyle' => 'moto-text_normal', 'spacingBetweenElements' => 'small', 'separator' => ':', ], 'item' => [ 'textStyle' => 'moto-text_normal', 'spacingBetweenElements' => 'small', ], 'reset' => [ 'content' => 'Reset', 'textStyle' => 'moto-text_normal', 'spacingBetweenElements' => 'small', ], ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], 'animation' => '', 'visible_on' => [ 'desktop' => true, 'tablet' => true, 'mobile-h' => true, 'mobile-v' => true, ], ]; protected $_filters; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/applied_filters.twig.html'; } public function getRequest() { return Helper\FilterRequest::getInstance(); } protected function getPreviewContent() { $provider = $this->getContentProvider(); $data = []; $definitions = $provider->getTaxonomyDefinitions(); if ($definition = $definitions->get('category')) { $data[] = $definition; } if ($definition = $definitions->get('tag')) { $data[] = $definition; } if (count($data) < 2) { foreach ($definitions->except(['category', 'tag']) as $definition) { $data[] = $definition; if (count($data) >= 2) { break; } } } foreach ($data as $index => $definition) { $data[$index] = [ 'label' => $definition->getText('pluralName'), 'options' => [ [ 'label' => $definition->getText('name') . ' 1', ], [ 'label' => $definition->getText('name') . ' 2', ], ], ]; } if (count($data) >= 2) { return $data; } $samples = [ [ 'label' => 'Categories', 'options' => [ [ 'label' => 'Category 1', ], [ 'label' => 'Category 2', ], ], ], [ 'label' => 'Tags', 'options' => [ [ 'label' => 'Tag 1', ], [ 'label' => 'Tag 2', ], ], ] ]; foreach ($samples as $sample) { $data[] = $sample; if (count($data) >= 2) { break; } } return $data; } public function getFilters() { if ($this->isPreviewMode()) { return $this->getPreviewContent(); } if ($this->_filters !== null) { return $this->_filters; } $this->_filters = []; $request = $this->getRequest(); $groups = $request->getTaxonomies('type'); foreach ($groups as $group) { $first = $group->first(); $definition = $first->getDefinition(); if (!$definition) { continue; } $filter = [ 'label' => $definition->getText('pluralName'), 'options' => [], ]; foreach ($group as $item) { $filter['options'][] = [ 'label' => $item->name, 'id' => $item->id, 'type' => 'taxonomies', ]; } $this->_filters[] = $filter; } return $this->_filters; } public function getCssWidgetClass() { return 'moto-widget-' . $this->getFirstName() . '-applied_filters'; } public function getSearchQuery() { if ($this->isPreviewMode()) { return 'Search'; } return $this->getRequest()->getSearchQuery(); } public function needToShowSearch() { return $this->getPropertyValue('elements.search.show') && !empty($this->getSearchQuery()); } public function shouldBeRendered() { if ($this->isPreviewMode()) { return true; } return ($this->getRequest()->getTaxonomies()->count() > 0) || $this->needToShowSearch(); } public function getCssClasses() { $result = $this->getCssWidgetClass(); $result .= ' ' . $this->getSpacing('classes'); $result .= ' ' . $this->getVisibleOn('classes'); $result .= ' ' . $this->getAnimationClasses(); return $result; } } 