<?php
 namespace Website\Widgets\Blog; use Moto; use Website; class FiltersWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.filters'; protected static $_defaultProperties = [ 'anchor' => '', 'items' => [], 'elements' => [ 'header' => [ 'align' => [ 'desktop' => 'justify', 'tablet' => '', 'mobile-h' => '', 'mobile-v' => '', ], 'order' => 'normal', ], 'label' => [ 'content' => 'Filters:', 'show' => false, ], 'icon' => [ 'content' => [ 'iconType' => 'icon', 'icon' => [ 'provider' => 'FontAwesome', 'id' => 'filter', 'unicode' => 'f0b0', ], 'image' => NULL, ], 'show' => true, ], 'toggleIcon' => [ 'content' => [ 'iconType' => 'icon', 'icon' => [ 'provider' => 'FontAwesome', 'id' => 'angle-down', 'unicode' => 'f107', ], ], 'show' => true, ], 'filters' => [ 'align' => 'left', 'direction' => 'horizontal', 'type' => 'dropdown', 'spacingBetweenElements' => 'small', ], 'filter' => [ 'align' => [ 'desktop' => 'center', 'tablet' => '', 'mobile-h' => '', 'mobile-v' => '', ], 'styles' => [ 'min-width' => '200px', 'max-width' => '300px', ], ], 'checkbox' => [ 'preset' => 'default', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ], 'buttons' => [ 'direction' => '', 'spacingBetweenElements' => 'small', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-h' => '', 'mobile-v' => '', ], 'apply' => [ 'label' => 'Apply', 'preset' => 'default', 'size' => 'medium', ], 'reset' => [ 'label' => 'Reset', 'preset' => 'default', 'size' => 'medium', ], ], ], 'preset' => 'default', 'animation' => '', 'visible_on' => 'mobile-v', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ]; protected $_filters; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/filters.twig.html'; } public function getFilters() { if ($this->_filters !== null) { return $this->_filters; } $this->_filters = []; $filters = $this->getPropertyValue('items'); if (!is_array($filters)) { return []; } $types = []; foreach ($filters as $filter) { if (!$filter['visible']) { continue; } $types[] = $filter['entityName']; } if (empty($types)) { return []; } $query = Moto\Database\Models\ContentTaxonomy::query(); $query->whereIn('type', $types); $query->orderBy('name'); $taxonomies = $query->get(['id', 'name', 'type']); $taxonomies = $taxonomies->groupBy('type'); $requestedTaxonomies = $this->getRequest() ->getTaxonomies('type'); foreach ($filters as $index => $filter) { if (!$filter['visible']) { continue; } $options = $taxonomies->get($filter['entityName']); if (!$options || count($options) < 1) { continue; } $first = $options->first(); $temp = $requestedTaxonomies->get($first->type); $this->_filters[] = [ 'label' => $first->getDefinition()->getText('pluralName'), 'taxonomy' => $first->getMetaType('taxonomy'), 'selected' => ($temp ? $temp->count() : 0), 'position' => $index, 'options' => $options, ]; } if ($this->isPreviewMode() && count($this->_filters) > 0) { $this->_filters[0]['selected'] = 1; } return $this->_filters; } public function getPreviewLabelForMobile() { return 'Filters:'; } public function getCssWidgetClass() { return 'moto-widget-' . $this->getFirstName() . '-filters'; } public function getCssClasses() { $result = $this->getCssWidgetClass(); $result .= ' moto-widget-content_section-filters_direction-' . $this->getPropertyValue('elements.filters.direction'); $result .= ' moto-preset-' . $this->getPropertyValue('preset', 'default'); $result .= ' ' . $this->getSpacing('classes'); $result .= ' ' . $this->getVisibleOn('classes'); $result .= ' ' . $this->getAnimationClasses(); return $result; } public function isHeaderShown() { return $this->isHeaderLabelShown() || $this->isHeaderIconShown(); } public function isHeaderLabelShown() { return $this->getPropertyValue('elements.label.show') && !!$this->getPropertyValue('elements.label.content'); } public function isHeaderIconShown() { if (!$this->getPropertyValue('elements.icon.show')) { return false; } switch ($this->getPropertyValue('elements.icon.content.iconType')) { case 'icon': return !!$this->getPropertyValue('elements.icon.content.icon.id'); case 'image': return !!$this->getPropertyValue('elements.icon.content.image.path'); } return false; } public function createInnerWidget($name, $properties) { $widget = Moto\System\Widgets\Factory::create([ 'name' => $name, 'properties' => $properties, ]); return $widget; } public function getInnerCheckboxWidget($filter, $options, $loop = null) { return $this->createInnerWidget('form_elements.checkbox', $this->getInnerCheckboxWidgetProperties($filter, $options, $loop)); } public function getInnerButtonWidget($name) { return $this->createInnerWidget('button', $this->getInnerButtonWidgetProperties($name)); } public function getRequest() { return Helper\FilterRequest::getInstance(); } public function getInnerCheckboxWidgetProperties($filter, $taxonomy, $loop = null) { $properties = (array) $this->getPropertyValue('elements.checkbox'); $properties['name'] = "taxonomies[{$taxonomy['id']}]"; $properties['modelAccessor'] = "model.filters.taxonomies[{$taxonomy['id']}]"; $properties['label'] = $taxonomy['name']; $properties['checked'] = $this->getRequest() ->getTaxonomies('id') ->has($taxonomy->id); if ($this->isPreviewMode() && is_array($loop) && $filter['position'] === 0) { $properties['checked'] = ($loop['index0'] === 0); } return $properties; } public function getButtonsWrapperClasses() { $result = ''; $buttonsDirection = $this->getButtonsDirection(); $result .= ' moto-widget-content_section-filters__buttons-wrapper_direction-' . $buttonsDirection; if ($buttonsDirection === 'horizontal') { $result .= ' moto-widget_flex-alignment'; $result .= ' ' . $this->getAlignClass('moto-align-', 'elements.buttons.align'); } return $result; } public function getButtonsDirection() { $direction = $this->getPropertyValue('elements.buttons.direction'); if (empty($direction)) { $direction = $this->getPropertyValue('elements.filters.direction'); } return $direction; } public function getInnerButtonWidgetProperties($name) { $properties = (array) $this->getPropertyValue('elements.buttons.' . $name); if ($this->getButtonsDirection() === 'vertical') { $properties['align'] = $this->getPropertyValue('elements.buttons.align'); } $properties['tag'] = 'a'; $properties['attributes']['data-filters-button-type'] = $name; $anchor = $this->getPropertyValue('anchor'); if ($name === 'apply') { $properties['attributes']['href'] = '#' . (!empty($anchor) ? $anchor : ''); } if ($name === 'reset') { $properties['attributes']['href'] = $this->getCurrentPage()->getAbsoluteUrl() . (!empty($anchor) ? "#$anchor" : ''); } return $properties; } } 