<?php
 namespace Website\Widgets\Blog\Helper; use Illuminate\Support\Arr; use Illuminate\Support\Collection; use Moto; use Moto\Database\Models\ContentTaxonomy; class FilterRequest { protected static $instance; protected $attributes = []; protected $collections = []; public static function getInstance() { if (!static::$instance) { static::$instance = new static(); static::$instance->setFilters(Moto\System\Request::getQuery('filters')); $taxonomies = Moto\System\Request::getQuery('taxonomies'); if (!empty($taxonomies)) { static::$instance->setAttribute('taxonomies', $taxonomies); } static::$instance->setAttribute('search', Moto\System\Request::getQuery('search')); } return static::$instance; } protected function setFilters($filters) { if (is_string($filters)) { $filters = trim($filters); if ($filters === '') { return false; } if (!in_array($filters[0], ['{', '['])) { $filters = base64_decode($filters); } if (in_array($filters[0], ['{', '['])) { $filters = json_decode($filters, true); } } if (!is_array($filters)) { return false; } $this->fill($filters); } protected function fill($attributes) { if (!is_array($attributes)) { return null; } foreach ($attributes as $attribute => $value) { $this->setAttribute($attribute, $value); } } protected function setAttribute($attribute, $value) { $this->attributes[$attribute] = $this->castValue($attribute, $value); } protected function getAttribute($attribute, $default = null) { if (array_key_exists($attribute, $this->attributes)) { return $this->attributes[$attribute]; } return $default; } protected function castValue($attribute, $value) { $method = 'cast' . Moto\Util::toStudlyCase($attribute) . 'Value'; if (method_exists($this, $method)) { return $this->{$method}($value); } return $value; } protected function castTaxonomiesValue($value) { if (!is_array($value)) { $value = [$value]; } $value = array_map(function ($value) { return (int) $value; }, $value); return $value; } protected function resolveTaxonomies() { $ids = (array) Arr::get($this->attributes, 'taxonomies'); if (empty($ids)) { return new Collection(); } $query = ContentTaxonomy::query(); $query->whereIn('id', $ids); return $query->get(['id', 'name', 'slug', 'type']); } public function getTaxonomies($groupBy = null) { if (!array_key_exists('taxonomies', $this->collections)) { $this->collections['taxonomies'] = $this->resolveTaxonomies(); } $collection = $this->collections['taxonomies']; if ($groupBy) { $key = 'taxonomies:' . $groupBy; if (!array_key_exists($key, $this->collections)) { $this->collections[$key] = $collection->groupBy($groupBy); } $collection = $this->collections[$key]; } return $collection; } public function getSearchQuery() { return $this->getAttribute('search'); } public function toArray() { return $this->attributes; } } 