<?php
 namespace Website\Widgets\Blog\Helper; use Illuminate\Support\Arr; use Illuminate\Support\Collection; use Moto; use Zend\Db\Sql\Where; class PaginatorWrapper { protected $paginator; protected $items; protected $pageRange = 5; protected $query = []; protected $path; public function __construct($paginator = null) { $this->setPaginator($paginator); } public function appends($data, $value = null) { if (is_string($data)) { $data = [$data => $value]; } if (!is_array($data)) { throw new \InvalidArgumentException('Data is not array'); } $this->query = array_merge($this->query, $data); return $this; } public function setPath($path) { $this->path = $path; return $this; } public function setPaginator($paginator) { $this->paginator = $paginator; return $this; } public function setCurrentItems($items) { if (is_array($items) && array_key_exists('records', $items)) { $items = $items['records']; } if ($items instanceof Collection) { $items = $items->toArray(); } if (!is_array($items)) { throw new Moto\Exception('Invalid argument "items"'); } $this->items = null; $paginator = new \Illuminate\Pagination\LengthAwarePaginator( $items, count($items), count($items), 1, [ 'path' => $this->path, ] ); $this->setPaginator($paginator); if (count($items) > 0) { $first = Arr::first($items); if ($first instanceof Moto\Application\Pages\PageModel) { $this->items = $items; } } return $this; } public function getCurrentItems() { if ($this->items) { return $this->items; } $relations = null; if ($this->paginator instanceof \Illuminate\Pagination\LengthAwarePaginator) { $collections = $this->paginator->getCollection(); $relations = $collections->keyBy('id'); $ids = $relations->keys()->toArray(); $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $select = $table->createSelect(); if (!empty($ids)) { $where = new Where(); $where->in('id', $ids); $select->where($where); } $select->order(['published' => 'DESC']); $this->items = $table->selectWith($select); } if ($this->paginator instanceof \Zend\Paginator\Paginator) { $this->items = $this->paginator->getCurrentItems(); } if ($this->items instanceof \Traversable) { $this->items = iterator_to_array($this->items); } if ($relations) { foreach ($this->items as $item) { $model = $relations->get($item->id); if (!$model) { continue; } $item->setEloquentModel($model); } } return $this->items; } public function getTotalItemCount() { if ($this->paginator instanceof \Illuminate\Pagination\LengthAwarePaginator) { return $this->paginator->total(); } if ($this->paginator instanceof \Zend\Paginator\Paginator) { return $this->paginator->getTotalItemCount(); } } public function getPages() { $result = []; if ($this->paginator instanceof \Illuminate\Pagination\LengthAwarePaginator) { $result['pageCount'] = $this->paginator->lastPage(); $result['first'] = 1; $result['last'] = $result['pageCount']; $result['current'] = $this->paginator->currentPage(); $result['previous'] = ($result['current'] > 1 ? $result['current'] - 1 : null); $result['next'] = ($result['last'] > $result['current'] ? $result['current'] + 1 : null); $result['pagesInRange'] = $this->getPagesInRange($result['current'], $result['last'], $this->pageRange); $result['total'] = $this->paginator->total(); $result['totalItemCount'] = $result['total']; } if ($this->paginator instanceof \Zend\Paginator\Paginator) { $result = $this->paginator->getPages(); } return (object) $result; } protected function getPagesInRange($current, $last, $range) { if ($range > $last) { $range = $last; } $delta = ceil($range / 2); if ($current - $delta > $last - $range) { $start = $last - $range + 1; $end = $last; } else { if ($current - $delta < 0) { $delta = $current; } $offset = $current - $delta; $start = $offset + 1; $end = $offset + $range; } $pages = []; for ($current = $start; $current <= $end; $current++) { $pages[$current] = $current; } return $pages; } public function url($page = 0) { $page = (int) $page; if ($page <= 0) { $page = 1; } $parameters = $this->query; $parameters['page'] = ($page > 1 ? $page : null); unset($parameters['url']); $url = $this->path; $tail = http_build_query($parameters, '', '&'); if ($tail !== '') { $url .= (mb_strpos($url, '?') ? '&' : '?') . $tail; } return $url; } } 