<?php
 namespace Website\Widgets\Blog; use Illuminate\Support\Collection; use Moto; use Website; use Zend; use Zend\Db\Sql\Where; class PostListWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.post_list'; protected static $_defaultProperties = array( 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), 'item_count' => 5, 'page' => null, 'read_more_label' => '', 'style' => array( 'title' => array( 'font_style' => 'moto-text_system_7', ), 'meta' => array( 'font_style' => 'moto-text_system_11', ), 'author' => array( 'font_style' => null ), 'button' => array( 'preset' => '5', 'size' => 'small', ), 'feature_image' => array( 'preset' => 'default', ), 'divider' => array( 'preset' => 'default', ), 'emptyPlaceholder' => array( 'font_style' => 'moto-text_system_7', ), ), 'layout' => [ 'name' => 'default', 'settings' => [], 'elements' => [ 'post' => [ 'name' => 'blog.post_list.post', 'properties' => [ 'styles' => [ 'desktop' => [ 'base' => [ 'background-color' => '' ], ], ], ], 'children' => [ 'image' => [ 'name' => 'blog.post_list.featured_image', 'visible' => true, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ], ], 'content' => [ 'name' => 'blog.post_list.content', 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ], 'children' => [ 'title' => [ 'properties' => [ 'spacing' => [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'description' => [ 'visible' => true, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'button' => [ 'visible' => true, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'date' => [ 'visible' => true, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'author' => [ 'visible' => false, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'taxonomy' => [ 'visible' => false, 'properties' => [ 'font_style' => 'moto-text_normal', 'maxItems' => 0, 'preset' => 'default', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], ], ], ], ], ], ], 'pagination' => [ 'name' => 'pagination', 'visible' => true, ], 'emptyPlaceholder' => [ 'name' => 'emptyPlaceholder', 'visible' => false, 'content' => '', ], ], ], 'contentAlignment' => array( 'title' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'date' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'author' => array( 'desktop' => 'right', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'image' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'pagination' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'button' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), 'emptyPlaceholder' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '' ), ) ); protected $_paginator = null; protected $_items = null; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/record_list/' . $this->getPropertyValue('layout.name', 'default') . '.twig.html'; } public function setPaginator($paginator) { if (!(($paginator instanceof \Zend\Paginator\Paginator) || ($paginator instanceof Helper\PaginatorWrapper))) { throw new Moto\Exception('Invalid argument "paginator"'); } $this->_paginator = $paginator; return true; } public function getPaginator() { if ($this->_paginator) { return $this->_paginator; } $perPage = $this->getPropertyValue('item_count', 5); $pageNumber = $this->getPropertyValue('page'); if (!is_int($pageNumber)) { $pageNumber = (int) Moto\System\Request::getQuery('page', 1); } $pageNumber = max(1, $pageNumber); if (Moto\Util::getValue($_GET, 'paginator') === 'zend') { $table = $this->_getTable(); $where = new Where(); $where->lessThanOrEqualTo('published', date('Y-m-d H:i:s', time())); $where->equalTo('type', $this->getFirstName() . '.post'); $where->equalTo('status', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $this->_updatePaginatorQueryFilter($where); $order = array( 'published' => 'DESC' ); $this->_paginator = $table->getPaginator($where, $order); $this->_paginator->setCurrentPageNumber($pageNumber); $this->_paginator->setItemCountPerPage($perPage); $this->_paginator->setPageRange(5); } else { $query = Moto\Database\Page::query(); $with = []; if ($this->getPropertyValue('layout.elements.post.children.content.children.author.visible')) { $with[] = 'author'; } if ($this->getPropertyValue('layout.elements.post.children.content.children.taxonomy.visible')) { $with[] = 'taxonomies'; } if (count($with) > 0) { $query->with($with); } $query->where('published', '<=', date('Y-m-d H:i:s', time())); $query->where('type', $this->getFirstName() . '.post'); $query->where('status', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $this->applyPostQuery($query); $query->orderBy('published', 'DESC'); $this->_paginator = $query->paginate($perPage, [ 'id', 'parent_id', 'author_id', 'category_id', ], 'page', $pageNumber); } $this->_paginator = new Helper\PaginatorWrapper($this->_paginator); $this->_paginator ->setPath($this->getCurrentPage()->getAbsoluteUrl()) ->appends(Moto\System\Request::getQuery()); return $this->_paginator; } public function getRequest() { return Helper\FilterRequest::getInstance(); } protected function applyPostQuery($query) { if ($this->getRenderingOption('ignoreQueryFilter')) { return; } $currentPage = $this->getCurrentPage(); if ($currentPage instanceof Moto\Website\ContentTaxonomyPage) { $taxonomy = $currentPage->getContentEntity(); if (!$taxonomy) { return; } if ($taxonomy instanceof Moto\Database\Models\ContentTaxonomyCategory) { return $query->where('category_id', $taxonomy->id); } $query->whereHas('taxonomies', function ($query) use ($taxonomy) { $query->where('id', $taxonomy->id); return $query; }); return $query; } $request = $this->getRequest(); $taxonomies = $request->getTaxonomies('type'); foreach ($taxonomies as $type => $records) { $ids = $records->pluck('id'); if (strpos($type, '.category') !== false) { $query->whereIn('category_id', $ids); continue; } $query->whereHas('taxonomies', function ($query) use ($ids) { $query->whereIn('id', $ids); return $query; }); } $search = $request->getSearchQuery(); if (!empty($search)) { $search = '%' . $search . '%'; $query->where(function ($query) use ($search) { $query->where('name', 'like', $search); $query->orWhere('title', 'like', $search); $query->orWhere('short_description', 'like', $search); }); } } public function getPostCategory($post) { if ($post instanceof Moto\Application\Pages\PageModel) { return $post->getCategoryModel(); } if ($post instanceof Moto\Database\Page) { return $post->category; } return null; } public function getPostTaxonomies($post) { if ($post instanceof Moto\Database\Page) { return $post->taxonomies; } $page = Moto\Database\Page::find($post->id); return $page->taxonomies; } protected function _updatePaginatorQueryFilter($where) { if ($this->getRenderingOption('ignoreQueryFilter')) { return; } $currentPage = $this->getCurrentPage(); if ($currentPage instanceof Moto\Website\ContentTaxonomyPage) { $currentTaxonomy = $currentPage->getContentEntity(); if (!$currentTaxonomy) { return; } $query = $currentTaxonomy->publishedTargets(); $posts = $query->get(['id']); $postsId = Moto\Database\Util::listsOrPluck($posts, 'id'); if (count($postsId) > 0) { $where->in('id', $postsId); } else { $where->equalTo('id', 0); } } } public function getPaginatorPages() { return $this->getPaginator()->getPages(); } public function getCurrentItems($offset = 0, $length = null) { $items = $this->getPaginator()->getCurrentItems(); if ($offset === 0 && $length === null) { return $items; } return array_slice($items, $offset, $length); } public function isAllowShowContent() { if ($this->getRenderingOption('showingContent')) { return true; } $currentPage = $this->getCurrentPage(); if ($currentPage && $currentPage->isTemplate() && $this->isPreviewMode()) { return false; } return true; } public function getColumnWidth() { return round(12 / max(1, (int) $this->getPropertyValue('layout.settings.columns', 1))); } public function getInnerWidgetProperties($name, $post = null) { $properties = []; $prefix = $this->getFirstName(); switch ($name) { case $prefix . '.post_published_on': case '@post_published_on': $properties = [ 'font_style' => $this->getDesignOption('meta.font_style', 'moto-text_system_11'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.content.children.date.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), 'align' => $this->getPropertyValue('contentAlignment.date'), ]; break; case $prefix . '.post_author': case '@post_author': $properties = [ 'font_style' => $this->getDesignOption('author.font_style', 'moto-text_system_11'), 'align' => $this->getPropertyValue('contentAlignment.author'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.content.children.author.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case $prefix . 'post_taxonomy': case '@post_taxonomy': $properties = $this->getPropertyValue('layout.elements.post.children.content.children.taxonomy.properties'); $properties['section'] = $prefix; break; case 'image': $properties = [ 'src' => Moto\Util::getValue($post, 'properties.feature_media.src'), 'alt' => Moto\Util::getValue($post, 'properties.feature_media.alt'), 'title' => Moto\Util::getValue($post, 'properties.feature_media.title'), 'preset' => $this->getDesignOption('feature_image.preset', 'default'), 'link' => [ 'action' => $prefix . '.post', 'properties' => [ 'id' => Moto\Util::getValue($post, 'id'), 'anchor' => '', ], ], 'animation' => '', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], 'align' => $this->getPropertyValue('contentAlignment.image'), ]; break; case 'button': $properties = [ 'link' => [ 'action' => $prefix . '.post', 'properties' => [ 'id' => Moto\Util::getValue($post, 'id'), 'anchor' => '', ], ], 'label' => $this->getPropertyValue('read_more_label', 'Read More'), 'preset' => $this->getDesignOption('button.preset', '5'), 'size' => $this->getDesignOption('button.size', 'medium'), 'align' => $this->getPropertyValue('contentAlignment.button'), 'animation' => '', 'spacing' => $this->getPropertyValue('layout.elements.post.children.content.children.button.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case 'pagination': $properties = [ 'paginator' => $this->getPaginator(), 'align' => $this->getPropertyValue('contentAlignment.pagination'), 'visible' => $this->getPropertyValue('layout.elements.pagination.visible'), ]; break; } return $properties; } public function getInnerWidget($name, $post = null) { $widgetName = $name; if ($widgetName[0] === '@') { $widgetName = str_replace('@', $this->getFirstName() . '.', $widgetName); } $properties = $this->getInnerWidgetProperties($name, $post); if (Moto\Util::getValue($properties, 'taxonomy.name') === 'category') { $widgetName = $this->getFirstName() . '.post_category'; } $widget = Moto\System\Widgets\Factory::create([ 'name' => $widgetName, 'properties' => $properties, ]); if ($widget instanceof PostTaxonomyWidget) { $widget->setCurrentPage($post); } return $widget; } } 