<?php
 namespace Website\Widgets\Blog; use Moto; use Website; use Zend\Db\Sql\Select; use Zend\Db\Sql\Where; class RecentPostsWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.recent_posts'; protected static $_defaultProperties = array( 'visible_on' => 'mobile-v', 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), 'item_count' => 5, 'filter' => [ 'type' => 'none', 'categories' => [], 'tags' => [], ], 'layout' => [ 'name' => 'default', 'settings' => [ ], 'elements' => [ 'post' => [ 'properties' => [ 'styles' => [ 'background-color' => '', ], 'spacing' => [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ], 'children' => [ 'heading' => [ 'properties' => [ 'spacing' => [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'title' => [ 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'image' => [ 'visible' => true, 'properties' => [ 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'date' => [ 'visible' => false, 'properties' => [ 'font_style' => 'moto-text_system_11', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'author' => [ 'visible' => false, 'properties' => [ 'font_style' => 'moto-text_system_11', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'description' => [ 'visible' => false, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'button' => [ 'visible' => false, 'properties' => [ 'label' => 'Read More', 'preset' => 'default', 'size' => 'small', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], ], ], ], ], 'label' => '', 'style' => array( 'heading' => array( 'font_style' => 'moto-text_system_7', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], ), 'title' => array( 'font_style' => 'moto-text_system_8', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], ), 'feature_image' => array( 'preset' => 'default', ), ), ); protected $_posts = null; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/recent_records.twig.html'; } public function __get($name) { if ($name === 'posts') { return $this->getPosts(); } return parent::__get($name); } public function getPosts() { if ($this->_posts) { return $this->_posts; } $table = $this->_getTable(); $count_post = $this->getPropertyValue('item_count') * 1; $count_post = max(1, $count_post); $count_post = min(20, $count_post); $where = new Where(); $where->lessThanOrEqualTo('published', date('Y-m-d H:i:s', time())); $where->equalTo('type', $this->getFirstName() . '.post'); $where->equalTo('status', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $where = $this->_applyFilter($where); $this->_posts = $table->getList($where, array('*'), array('published' => 'DESC'), $count_post); return $this->_posts; } protected function _applyFilter(Where $where) { $type = $this->getPropertyValue('filter.type'); if ($type === 'none' || empty($type)) { return $where; } if ($type === 'categories') { $categories = (array) $this->getPropertyValue('filter.categories'); if (!empty($categories)) { $where->in('category_id', $categories); } } else { $tags = (array) $this->getPropertyValue('filter.' . $type); if (!empty($tags)) { $select = new Select(Moto\Database\Provider::getTablePrefix() . 'content_taxonomy_relations'); $select->columns(['target_id']); $select->where([ 'taxonomy_id' => $tags, ]); $where->in('id', $select); } } return $where; } public function getColumnWidth() { return (int) round(12 / max(1, (int) $this->getPropertyValue('layout.settings.columns', 1))); } public function getInnerWidgetProperties($name, $post = null) { $properties = []; $prefix = $this->getFirstName(); switch ($name) { case $prefix . '.post_published_on': case '@post_published_on': $properties = [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.date.properties.font_style', 'moto-text_system_11'), 'align' => $this->getPropertyValue('layout.elements.post.children.date.properties.align', 'left'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.date.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case $prefix . '.post_author': case '@post_author': $properties = [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.author.properties.font_style', 'moto-text_system_11'), 'align' => $this->getPropertyValue('layout.elements.post.children.author.properties.align', 'left'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.author.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case 'image': if (!is_object($post) || !method_exists($post, 'getAbsoluteUrl')) { return null; } $properties = [ 'link' => [ 'action' => 'url', 'properties' => [ 'url' => $post->getAbsoluteUrl(), ], ], 'src' => Moto\Util::getValue($post, 'properties.feature_media.src'), 'alt' => Moto\Util::getValue($post, 'properties.feature_media.alt'), 'title' => Moto\Util::getValue($post, 'properties.feature_media.title'), 'preset' => $this->getDesignOption('feature_image.preset', 'default'), 'align' => $this->getPropertyValue('layout.elements.post.children.image.properties.align', 'left'), 'animation' => '', 'spacing' => $this->getPropertyValue('layout.elements.post.children.image.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case 'button': if (!is_object($post) || !method_exists($post, 'getAbsoluteUrl')) { return null; } $properties = [ 'link' => [ 'action' => 'url', 'properties' => [ 'url' => $post->getAbsoluteUrl(), ], ], 'label' => $this->getPropertyValue('layout.elements.post.children.button.properties.label', 'Read More'), 'preset' => $this->getPropertyValue('layout.elements.post.children.button.properties.preset', 'default'), 'size' => $this->getPropertyValue('layout.elements.post.children.button.properties.size', 'small'), 'align' => $this->getPropertyValue('layout.elements.post.children.button.properties.align', 'left'), 'animation' => '', 'spacing' => $this->getPropertyValue('layout.elements.post.children.button.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; } return $properties; } public function getInnerWidget($name, $post = null) { $widgetName = $name; if ($widgetName[0] === '@') { $widgetName = str_replace('@', $this->getFirstName() . '.', $widgetName); } $widget = Moto\System\Widgets\Factory::create([ 'name' => $widgetName, 'properties' => $this->getInnerWidgetProperties($name, $post), ]); return $widget; } public function getInnerRecordListWidgetProperties() { return [ 'version' => 1, 'item_count' => $this->getPropertyValue('item_count', 5), 'page' => 1, 'read_more_label' => $this->getPropertyValue('layout.elements.post.children.button.properties.label', ''), 'style' => [ 'title' => [ 'font_style' => $this->getDesignOption('title.font_style', 'moto-text_system_8'), ], 'meta' => [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.date.properties.font_style', 'moto-text_system_11'), ], 'author' => [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.author.properties.font_style', 'moto-text_system_11'), ], 'button' => [ 'preset' => $this->getPropertyValue('layout.elements.post.children.button.properties.preset', 'default'), 'size' => $this->getPropertyValue('layout.elements.post.children.button.properties.size', 'small'), ], ], 'layout' => [ 'name' => $this->getPropertyValue('layout.name', 'default'), 'settings' => $this->getPropertyValue('layout.settings', []), 'elements' => [ 'post' => [ 'name' => 'blog.post_list.post', 'properties' => [ 'styles' => [ 'background-color' => $this->getPropertyValue('layout.elements.post.properties.styles.background-color', ''), ], ], 'children' => [ 'image' => [ 'name' => 'blog.post_list.featured_image', 'visible' => $this->getPropertyValue('layout.elements.post.children.image.visible', true), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.image.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'content' => [ 'name' => 'blog.post_list.content', 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.properties.spacing', [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ]), ], 'children' => [ 'title' => [ 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.title.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'description' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.description.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.description.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'button' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.button.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.button.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'date' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.date.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.date.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'author' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.author.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.author.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], ], ], ], ], 'pagination' => [ 'visible' => false, ], ], ], 'contentAlignment' => [ 'title' => $this->getPropertyValue('style.title.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'date' => $this->getPropertyValue('layout.elements.post.children.date.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'author' => $this->getPropertyValue('layout.elements.post.children.author.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'image' => $this->getPropertyValue('layout.elements.post.children.image.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'button' => $this->getPropertyValue('layout.elements.post.children.button.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), ], ]; } public function getInnerRecordListWidget() { $widget = Moto\System\Widgets\Factory::create([ 'id' => $this->getWidgetId() . '_post_list', 'name' => $this->getFirstName() . '.post_list', 'properties' => $this->getInnerRecordListWidgetProperties(), ]); $widget->setRenderingOption('showingContent', true); $widget->setRenderingOption('ignoreQueryFilter', true); $paginator = new Helper\PaginatorWrapper(); $paginator->setCurrentItems(Moto\Util::getValue($this->getPosts(), 'records', [])); $widget->setPaginator($paginator); return $widget; } } 