<?php
 namespace Website\Widgets\Blog; use Moto; use Website; class SearchWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.search'; protected static $_defaultProperties = [ 'showSearchButton' => true, 'anchor' => '', 'direction' => 'horizontal', 'spaceBetweenControls' => 'small', 'resetFilters' => false, 'elements' => [ 'box' => [ 'placeholder' => 'Search', 'icon' => [ 'id' => 'search', 'provider' => 'FontAwesome', 'unicode' => 'f002', ], 'preset' => 'default', ], 'button' => [ 'preset' => 'default', 'size' => 'medium', 'label' => 'Search', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-h' => '', 'mobile-v' => '', ], ], ], 'animation' => '', 'visible_on' => 'mobile-v', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ]; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/search.twig.html'; } public function getCssWidgetClass() { return 'moto-widget-' . $this->getFirstName() . '-search'; } public function getCssClasses() { $result = $this->getCssWidgetClass(); if ($this->getPropertyValue('showSearchButton')) { $result .= ' moto-widget-content_section-search_direction-' . $this->getPropertyValue('direction'); } else { $result .= ' moto-widget-content_section-search_direction-horizontal'; } $result .= ' ' . $this->getSpacing('classes'); $result .= ' ' . $this->getVisibleOn('classes'); $result .= ' ' . $this->getAnimationClasses(); return $result; } public function getInnerSearchBoxWidgetProperties() { $properties = (array) $this->getPropertyValue('elements.box'); $properties['name'] = 'search'; if (empty($properties['spacing'])) { $properties['spacing'] = [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ]; } $properties['modelAccessor'] = "model.search"; return $properties; } public function getInnerButtonWidgetProperties() { $properties = (array) $this->getPropertyValue('elements.button'); if (empty($properties['spacing'])) { $properties['spacing'] = [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ]; } if ($this->getPropertyValue('direction') === 'horizontal') { unset($properties['align']); $properties['spacing']['left'] = $this->getPropertyValue('spaceBetweenControls', 'small'); } else { $properties['spacing']['top'] = $this->getPropertyValue('spaceBetweenControls', 'small'); } $anchor = $this->getPropertyValue('anchor'); $properties['tag'] = 'a'; $properties['attributes']['href'] = '#' . (!empty($anchor) ? $anchor : ''); $properties['attributes']['data-search-button-apply'] = ""; return $properties; } public function getInnerSearchBoxWidget() { return $this->createInnerWidget('form_elements.input', $this->getInnerSearchBoxWidgetProperties()); } public function getInnerButtonWidget() { return $this->createInnerWidget('button', $this->getInnerButtonWidgetProperties()); } public function createInnerWidget($name, $properties) { $widget = Moto\System\Widgets\Factory::create([ 'name' => $name, 'properties' => $properties, ]); return $widget; } public function getRequest() { return Helper\FilterRequest::getInstance(); } public function getSearchQuery() { return $this->getRequest()->getSearchQuery(); } } 