<?php
 namespace Website\Widgets\Blog; use Illuminate; use Moto; use Website; class TaxonomyListWidget extends Website\Widgets\Blog\AbstractPostsWidget { use Helper\TaxonomyWidgetTrait; protected $_name = 'blog.taxonomy_list'; protected static $_defaultProperties = array( 'section' => 'blog', 'taxonomy' => null, 'listType' => 'all', 'customList' => [], 'hideEmpty' => false, 'title' => [ 'content' => '', 'textStyle' => 'moto-text_system_8', 'bottomSpacing' => 'small' ], 'enableDelimiter' => true, 'icon' => null, 'postsCount' => [ 'visible' => false, ], 'verticalAlign' => 'center', 'align' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ), 'preset' => 'default', 'visible_on' => 'mobile-v', 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), ); protected $_taxonomies; public function getTemplatePath($preset = null) { $definition = $this->getTaxonomyDefinition(); if ($definition) { $type = $definition->type; } else { $type = 'empty'; } return '@websiteWidgets/content_sections/templates/taxonomy_list/' . $type . '.twig.html'; } public function shouldBeRendered() { return $this->isPreviewMode() || parent::shouldBeRendered() && !empty($this->getPropertyValue('taxonomy.name')); } protected function getTaxonomyFullType() { $section = $this->getContentProviderName(); $entity = $this->getPropertyValue('taxonomy.name'); if (empty($entity)) { $entity = $this->getSecondName(); if (preg_match('/^(?<entity>[^_]+)_(?<tail>.*)$/', $entity, $match)) { $entity = $match['entity']; } } return $section . '.' . $entity; } protected function getTaxonomyQuery() { $query = Moto\Database\Models\ContentTaxonomyTag::query(); $query->where('type', $this->getTaxonomyFullType()); return $query; } public function getCssWidgetClass() { $classes = 'moto-widget-content_section-taxonomy_list moto-widget-' . $this->getContentProviderName() . '-taxonomy_list'; $definition = $this->getTaxonomyDefinition(); if (!$definition) { return $classes; } if ($definition->type === 'one') { $classes .= ' moto-widget-content_section-taxonomy_one_list moto-widget-blog-category_list'; } else { $classes .= ' moto-widget-content_section-taxonomy_many_list moto-widget-blog-tag_list moto-widget-blog-post_tags'; } $classes .= ' moto-widget-' . $this->getContentProviderName() . '-' . $definition->name . '_list'; return $classes; } public function getVerticalAlignClass() { return ' moto-align-items_' . $this->getPropertyValue('verticalAlign'); } public function getCssClasses() { $classes = 'moto-preset-' . $this->getPropertyValue('preset'); $classes .= ' ' . $this->getCssWidgetClass(); $classes .= ' ' . $this->getSpacing('classes'); $classes .= ' ' . $this->getAlignClass(); $classes .= ' ' . $this->getVisibleOn('classes'); $definition = $this->getTaxonomyDefinition(); if (!$definition) { return $classes; } if ($definition->type === 'one') { if ($this->getPropertyValue('enableDelimiter')) { $classes .= ' moto-widget-blog-category_list_show-delimiter'; } if (empty($this->getPropertyValue('icon'))) { $classes .= ' moto-widget-blog-category_list_no-icon'; } } return $classes; } public function getTaxonomies() { if ($this->_taxonomies) { return $this->_taxonomies; } $query = $this->getTaxonomyQuery(); if ($this->getPropertyValue('hideEmpty')) { $query->whereHas('publishedTargets'); } if ($this->getPropertyValue('postsCount.visible')) { $query->withCount('publishedTargets'); } if ($this->getPropertyValue('listType') === 'custom') { $customList = []; foreach ((array) $this->getPropertyValue('customList') as $item) { $id = $item; if (is_array($item)) { $id = Moto\Util::getValue($item, 'id'); } $customList[] = (int) $id; } $query->whereIn('id', $customList); $collection = $query->get(); $items = new Illuminate\Database\Eloquent\Collection(); foreach ($customList as $id) { $item = $collection->find($id); if ($item) { $items->add($item); } } } else { $query->orderBy('name'); $items = $query->get(); } $this->_taxonomies = $items; return $this->_taxonomies; } } 