<?php
namespace Website\Widgets\Breadcrumbs; use Moto; use Website; class Widget extends Moto\System\Widgets\AbstractWidget { protected $_name = 'breadcrumbs'; protected static $_defaultProperties = array( 'currentPageDisplay' => 'none', 'homePageDisplay' => 'icon_name', 'homePageName' => 'Home', 'homePageIcon' => [ 'id' => 'home', 'provider' => 'FontAwesome', 'unicode' => 'f015' ], 'delimiter' => '>', 'preset' => 'default', 'align' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ), 'visible_on' => 'mobile-v', 'animation' => '', 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), ); protected $_templateType = 'templates'; protected $_widgetId = true; protected static $_fullPageCollection; public function getCssClasses() { $result = $this->getAlignClass(); $result .= ' ' . $this->getSpacing('classes'); $result .= ' ' . $this->getVisibleOn('classes'); $result .= ' ' . $this->getAnimationClasses(); $result .= ' moto-preset-' . $this->properties['preset']; return $result; } protected function _createMainPage() { return new Website\Widgets\Breadcrumbs\MainPage(); } protected function _getPageCollection() { if (static::$_fullPageCollection) { return static::$_fullPageCollection; } static::$_fullPageCollection = Website\Widgets\Breadcrumbs\PageCollection::create([ 'previewData' => $this->isPreviewMode(), ]); $collection = static::$_fullPageCollection; if ($collection->isFilled()) { return $collection; } $columns = ['id', 'name', 'url', 'title', 'parent_id', 'status', 'author_id', 'category_id', 'is_system', 'type', 'visibility']; $contentPage = $this->getCurrentPage(); $contentEntity = $contentPage->getContentEntity(); $collection->insert($this->_createMainPage(), 'MAIN_PAGE'); if (Moto\System\Request::getRequestUrl() === '/') { return $collection->markAsFilled(); } $homePageProvider = Moto\System::app('HomePageProvider'); $application = $homePageProvider->getApplicationInstance(); if (!$application) { $application = $homePageProvider->getApplicationInstance('page'); } if ($application->isMainPage($contentPage)) { return $collection->markAsFilled(); } $collection->insert($contentEntity, 'CURRENT_PAGE'); $parentPage = $contentEntity->getParentPage($columns); $level = 0; while ($parentPage) { if ($application->isMainPage($parentPage)) { break; } $level ++; $target = $collection->insert($parentPage, 'PARENT_PAGE'); $target->decreasePriority($level); $parentPage = $parentPage->getParentPage($columns); } return $collection->markAsFilled(); } public function getPageList() { $list = $this->_getPageCollection()->targets(); if ($this->getPropertyValue('homePageDisplay') === 'none') { array_shift($list); } if ($this->getPropertyValue('currentPageDisplay') === 'none') { array_pop($list); } return $list; } public function isHomePage($item) { if (!$item) { return false; } if (method_exists($item, 'isMainPage')) { return $item->isMainPage(); } return (boolean) Moto\Util::getValue($item, 'isMainPage'); } public function getItemRelativeUrl($item) { if (!$item) { return ''; } if (method_exists($item, 'getRelativeUrl')) { return Moto\System::getRelativeUrl($item->getRelativeUrl()); } return (string) Moto\Util::getValue($item, 'relativeUrl'); } public function isVisibleItemIcon($item) { if ($this->isHomePage($item)) { return (strpos((string) $this->getPropertyValue('homePageDisplay'), 'icon') !== false); } return false; } public function isVisibleItemName($item) { if ($this->isHomePage($item)) { return (strpos((string) $this->getPropertyValue('homePageDisplay'), 'name') !== false); } return true; } public function getVisibleName($item) { if ($item instanceof Website\Widgets\Breadcrumbs\MainPage) { return $this->getPropertyValue('homePageName'); } if (method_exists($item, 'getName')) { return $item->getName(); } return (string) Moto\Util::getValue($item, 'name'); } public function getVisibleIconId($item) { if ($this->isHomePage($item)) { return $this->getPropertyValue('homePageIcon.id'); } return ''; } public function shouldBeRendered() { if ($this->isPreviewMode()) { return true; } return (boolean) count($this->getPageList()); } } 