<?php
namespace Website\Widgets\ContactForm; use Moto; class Widget extends Moto\System\Widgets\AbstractWidget { protected $_name = 'contact_form'; protected static $_defaultProperties = array( 'preset' => 'default', 'animation' => '', 'inline' => false, 'inlineOn' => array( 'desktop' => true, 'tablet' => true, 'mobile-v' => true, 'mobile-h' => true, ), 'spacingBetweenElements' => 'zero', 'justify' => false, 'align' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ), 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), 'fields' => array(), 'messages' => array(), 'buttons' => array(), 'settings' => array( 'recipient' => '', 'useSenderEmail' => false, ), 'postAction' => array( 'action' => 'none', 'properties' => array( 'id' => '', 'target' => '_self', ), ), 'resetAfterSubmission' => false ); protected $_templateType = 'templates'; protected $_widgetId = true; public function getProtectedHash() { $array = array( 'settings' => array( 'recipient' => $this->getPropertyValue('settings.recipient', ''), 'useSenderEmail' => $this->getPropertyValue('settings.useSenderEmail', false), ), ); return Moto\System::encrypt($array); } public function isEmpty() { $fieldList = $this->properties['fields']; foreach ($fieldList as $value) { if ($value['enabled']) { return false; } } return true; } public function getActionAfterSubmission() { $clickAction = Moto\ClickAction\Factory::create($this->properties['postAction']); $data = $clickAction->toArray(['url', 'target']); $data['id'] = Moto\Util::getValue($data, 'properties.id'); return json_encode(Moto\Util::arrayOnly($data, ['action', 'url', 'target', 'id'])); } public function getJustifyCssClass() { $result = ''; if ($this->getPropertyValue('justify', false)) { $result .= ' moto-widget-contact_form-form__inline-align_' . $this->getPropertyValue('justify'); } return $result; } public function getCssClassesForInline() { $inlineProperties = $this->getPropertyValue('inlineOn'); $classes = ['moto-widget-contact_form-form__inline']; foreach ($inlineProperties as $device => $value) { if ($value) { array_push($classes, "moto-widget-contact_form-form__inline-on_" . $device); } } return join(" ", $classes); } public function getInnerWidgetProperties($name) { switch ($name) { case 'submit_button': return [ 'preset' => $this->getPropertyValue('buttons.submit.preset', 'default'), 'align' => [ 'desktop' => $this->getPropertyValue('buttons.submit.align', 'left'), ], 'size' => $this->getPropertyValue('buttons.submit.size', 'medium'), 'label' => $this->getPropertyValue('buttons.submit.label', 'Send'), 'tag' => 'button', 'attributes' => [ 'type' => 'submit', ], ]; case 'attach_button': $attachmentLabel = ''; foreach ($this->getPropertyValue('fields') as $index => $field) { if ($field['type'] == 'file') { $attachmentLabel = $field['placeholder']; break; } } return [ 'preset' => $this->getPropertyValue('buttons.attachment.preset', 'default'), 'align' => [ 'desktop' => $this->getPropertyValue('buttons.attachment.align', 'left'), ], 'size' => $this->getPropertyValue('buttons.attachment.size', 'medium'), 'label' => !empty($attachmentLabel) ? $attachmentLabel : 'Upload', 'tag' => 'button', 'attributes' => [ 'type' => 'button', 'ngf-select' => '', 'ng-model' => 'attachment', ], ]; } throw new \Exception('ContactForm.getInnerWidgetProperties: Wrong $name passed: ' . $name); } public function getInnerWidgetName($name) { switch ($name) { case 'submit_button': case 'attach_button': return 'button'; } throw new \Exception('ContactForm.getInnerWidgetName: Wrong $name passed: ' . $name); } public function getInnerWidget($name) { return Moto\System\Widgets\Factory::create([ 'name' => $this->getInnerWidgetName($name), 'properties' => $this->getInnerWidgetProperties($name), ]); } } 