<?php
namespace Website\Widgets\Container; use Moto; use Twig_Markup; class Widget extends Moto\System\Widgets\AbstractContainerWidget { protected $_name = 'container'; protected static $_defaultProperties = array( 'anchor' => '', 'stickyEnabled' => false, 'stickyHidden' => false, 'stickyMobile' => false, 'bgParallaxed' => false, 'bgFixed' => false, 'viewportHeight' => false, 'justify' => false, 'visible_on' => 'mobile-v' ); protected $_templateType = 'templates'; protected $_widgetId = true; public $customAttributes = []; public function getCustomAttributes() { return $this->customAttributes; } public function preRender() { parent::preRender(); if ($this->getPropertyValue('stickyEnabled')) { $sticky = []; if ($this->getPropertyValue('stickyHidden')) { $sticky['hidden'] = true; } if ($this->getPropertyValue('stickyMobile')) { $sticky['mobile'] = true; } $this->customAttributes['data-moto-sticky'] = (object) $sticky; } if ($this->getPropertyValue('bgParallaxed')) { $this->customAttributes['data-stellar-background-ratio'] = '0.5'; } $this->customAttributes['data-css-name'] = $this->getPropertyValue('cssName'); return; $style = new Moto\Application\Styles\StyleModel(); $style->class_name = $this->getPropertyValue('cssName'); $style->name = $this->getPropertyValue('cssName'); $style->type = 'widget'; $style->properties = $this->getPropertyValue('styles'); $twig = Moto\Render::getInstance(); $content = $twig->render('@lessTemplates/styler.less.twig', array( 'items' => [$style] )); Moto\Hook::on(Moto\Hook::RENDER_WEBSITE_BODY_BOTTOM, function($event, $value) use ($content) { $value .= "\n" . '<style>' . $content . '</style>' . "\n"; return $value; }); } public function exportStyles() { $styles = $this->getPropertyValue('styles.desktop.base'); if ($this->isPreRenderMode()) { $css = '{{ StyleHelper.generateLessFromArray(' . json_encode($styles) . ') }}'; } else { $css = $this->_getStyleHelper()->generateLessFromArray($styles); } $css = trim($css); if (!strlen($css)) { return ''; } $code = '<style>.' . $this->getPropertyValue('cssName') . ' { ' . $css . '} </style>'; return new Twig_Markup($code, 'UTF-8'); } public function getCssClasses() { $result = $this->getPropertyValue('cssName', ''); if ($this->getPropertyValue('bgFixed', false)) { $result .= ' moto-background-fixed'; } if ($this->getPropertyValue('bgParallaxed', false)) { $result .= ' moto-parallax'; } if ($this->getPropertyValue('viewportHeight', false)) { $result .= ' moto-min-height_100vh'; } if ($this->getPropertyValue('justify', '')) { $result .= ' moto-justify-content_' . $this->getPropertyValue('justify'); } $result .= ' ' . $this->getVisibleOn('classes'); return $result; } } 